
#==============================================================================#
# exerb/nametable.rb
# $Id: nametable.rb,v 1.5 2003/02/21 05:14:48 yuya Exp $
#==============================================================================#

#==============================================================================#
# Exerb Module
module Exerb

  #============================================================================#
  # NameTable Class
  class NameTable

    def initialize
      @name = []
    end

    def add(name)
      @name << Item.new(@name.size + 1, name)
      return @name.size
    end

    def size
      return @name.size
    end

    def pack
      header = ''
      table  = ''
      header_size = @name.size * NameHeader.size

      @name.each { |name|
        name_header = NameHeader.new
        name_header.id     = name.id
        name_header.offset = header_size + table.size
        name_header.size   = name.size

        header << name_header.pack
        table  << name.pack
      }

      return header + table
    end

    #==========================================================================#
    # Item Class
    class Item

      def initialize(id, name)
        @id   = id
        @name = name
      end

      attr_reader :id, :name

      def size
        return @name.size
      end

      def pack
        return @name + "\0"
      end

    end # Item

  end # NameTable

end # Exerb

#==============================================================================#
#==============================================================================#
