=begin

$Id: README.en.rd,v 1.36 2003/02/20 09:58:12 yuya Exp $

= Exerb

* ((<1. Overview>))
* ((<2. Features>))
* ((<3. Installation>))
* ((<4. Documentation>))
* ((<5. Example>))
  * ((<5.1. The libraries which are used in examples>))
* ((<6. The core>))
* ((<7. How to get>))
* ((<8. Checking environment>))
* ((<9. License>))
* ((<10. Copyright>))
* ((<11. Exemption from responsibility>))
* ((<12. Acknowledgment>))
* ((<13. Author>))
* ((<14. And>))

== 1. Overview

Exerb is the software which converts scripts/extension-libraries of the object-
oriented programming language Ruby into a 32 bits Windows executable (is called
the executable file in this document) file which can execute alone and
independently.

== 2. Features

The main features of Exerb are as follows.

* Exerb can convert a number of files(script, extension-library) into a
  executable file in one piece.
* A executable file which is created by Exerb can execute on an environment
  Ruby is not installed, because the executable file contains Ruby.
* Any compiler is not needed to create an executable file.

== 3. Installation

Run following commands to install Exerb.
You may need an administrator's authority to run "install".

  $ ruby install.rb config
  $ ruby install.rb setup
  # ruby install.rb install

== 4. Documentation

: ((<"ChangeLog.en.rd"|URL:ChangeLog.en.html>))
    ChangeLog.

: ((<"doc/tutorial.en.rd"|URL:doc/tutorial.en.html>))
    Tutorial.

: ((<"doc/command.en.rd"|URL:doc/command.en.html>))
    Command reference.

: ((<"doc/recipe.en.rd"|URL:doc/recipe.en.html>))
    About the recipe file.

== 5. Example

Four examples are in the example directory.

: example1
    This is the example which displays a message box using Win32API.

: example2
    This is the example which occurs an exception and displays an
    exception dialog.

: example3
    This is the example which displays a window using VisualuRuby.

: example4
    This is the example which gets strings from the standard input,
    and puts these with line numbers.

To convert example1 into an executable file, do as followings.

  $ cd example
  $ exerb.rb example1.rbc

You can convert other example in same method.

=== 5.1. The libraries which are used in examples

VisualuRuby(under vr/, and swin.so) and Win32API(Win32API.so) are used in
example programs.

VisualuRuby is a Win32 GUI library that is provided by NISHIKAWA Yasuhiro.
You can get the information about VisualuRuby from
((<URL:http://www.osk.3web.ne.jp/~nyasu/software/vrproject.html>)).
Thanks for the great library.

== 6. The core

There are two kinds of the cores, the GUI version and the CUI version.
The name "ruby168g.rbx" is for the GUI version, and the name "ruby168c.rbx" for
the CUI version.
The deference between the GUI version and the CUI version is as follows.

* In the GUI version, standard input/output can't be used, the CUI version can
  use that.
* In the GUI version, the dialog is popped up when an exception is raised, in
  the CUI version, the message is written to a console.

== 7. How to get

You can get the latest information and version of Exerb at the following URL.

* ((<URL:http://exerb.sourceforge.jp/index.en.html>))
* ((<URL:http://sourceforge.jp/projects/exerb/>))

And you can get the information and source code of Ruby at the following URL.

* ((<URL:http://www.ruby-lang.org/>))

== 8. Checking environment

We checked out that the executable file created by Exerb can run on following
environments.

* Microsoft Windows XP
* Microsoft Windows 2000
* Microsoft Windows Me
* Microsoft Windows 98 SecondEdition
* Microsoft Windows 98
* Microsoft Windows 95

== 9. License

You can redistribute it and/or modify it under the terms of the	LGPL.

== 10. Copyright

* The Ruby part of Exerb is copyrighted by Yukihiro Matsumoto and the people
  who is concerned in the development of it.
* The other parts is copyrighted by Yuya Kato.

== 11. Exemption from responsibility

THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

== 12. Acknowledgment

We would like to thank Yukihiro Matsumoto and the other people who is concerned
in the development of the Great language Ruby.
Thanks for the great language!

== 13. Author

Yuya Kato <yuya@katoden.co.jp>

I'll be happy if you send me your advices, impressions, demands or bug reports.

== 14. And

Good Ruby life. :-)

=end
