// $Id: def.h,v 1.8 2003/01/30 08:21:07 yuya Exp $

////////////////////////////////////////////////////////////////////////////////

const int EXERB_OPTIONS_KCODE_NONE = 0;
const int EXERB_OPTIONS_KCODE_EUC  = 1;
const int EXERB_OPTIONS_KCODE_SJIS = 2;
const int EXERB_OPTIONS_KCODE_UTF8 = 3;

const int EXERB_ENTRY_TYPE_SCRIPT  = 1;
const int EXERB_ENTRY_TYPE_LIBRARY = 2;
const int EXERB_ENTRY_TYPE_BINARY  = 3;

////////////////////////////////////////////////////////////////////////////////

typedef void (*INITPROC)(void);
typedef VALUE (__cdecl *RUBYPROC)(...);

////////////////////////////////////////////////////////////////////////////////

typedef struct {
    WORD   signature;                     // 00 - Magic number
    WORD   last_page_size;                // 02 - Bytes on last page of file
    WORD   total_pages_in_file;           // 04 - Pages in file
    WORD   relocation_items;              // 06 - Relocations
    WORD   paragraphs_in_header;          // 08 - Size of header in paragraphs
    WORD   minimum_extra_paragraphs;      // 0A - Minimum extra paragraphs needed
    WORD   maximum_extra_paragraphs;      // 0C - Maximum extra paragraphs needed
    WORD   initial_stack_segment;         // 0E - Initial (relative) SS value
    WORD   initial_stack_pointer;         // 10 - Initial SP value
    WORD   complemented_checksum;         // 12 - Checksum
    WORD   initial_instruction_pointer;   // 14 - Initial IP value
    WORD   initial_code_segment;          // 16 - Initial (relative) CS value
    WORD   relocation_table_offset;       // 18 - File address of relocation table
    WORD   overlay_number;                // 1A - Overlay number
    WORD   reserved11;                    // 1C - Reserved words
    WORD   reserved12;                    // 1E - Reserved words
    WORD   reserved13;                    // 20 - Reserved words
    WORD   reserved14;                    // 22 - Reserved words
    WORD   oem_identifier;                // 24 - OEM identifier (for e_oeminfo)
    WORD   oem_information;               // 26 - OEM information; e_oemid specific
    WORD   reserved21;                    // 28 - Reserved words
    WORD   reserved22;                    // 2A - Reserved words
    WORD   reserved23;                    // 2C - Reserved words
    WORD   reserved24;                    // 2E - Reserved words
    DWORD  offset_to_archive;             // 30 - Reserved words
    DWORD  size_of_archive;               // 34 - Reserved words
    DWORD  size_of_compressed_archive;    // 38 - Reserved words
    LONG   offset_to_new_header;          // 3C - File address of new exe header
} EXERB_DOS_HEADER, *PEXERB_DOS_HEADER;

typedef struct {
	DWORD signature;                        // 00 - Signature 0x59425552:"RUBY"
	DWORD time_date_stamp;                  // 04 - Creating Date and Time
	DWORD offset_to_name;                   // 08 - Offset to Name Table
	DWORD number_of_name;                   // 0C - Number of Name Table Entries
	DWORD offset_to_entry;                  // 10 - Offset to Entry Table
	DWORD number_of_entry;                  // 14 - Number of Entry Table Entries
	union {
		DWORD all;
		struct {
			DWORD kcode:2;
			DWORD reserved:30;
		};
	} options;
} EXERB_ARCHIVE_HEADER, *PEXERB_ARCHIVE_HEADER;

typedef struct {
	DWORD id;      // 00 - ID
	DWORD offset;  // 04 - Offset to Name
	DWORD size;    // 08 - Size of Name
} EXERB_NAME_HEADER, *PEXERB_NAME_HEADER;

typedef struct {
	DWORD id;      // 00 - ID
	DWORD type;    // 04 - Entry Type
	DWORD offset;  // 08 - Offset to Entry
	DWORD size;    // 0C - Size of Entry
} EXERB_ENTRY_HEADER, *PEXERB_ENTRY_HEADER;

////////////////////////////////////////////////////////////////////////////////
