# $Id: test-kcode.rb,v 1.4 2002/12/01 14:40:14 yuya Exp $

require 'testcase'

class KcodeTestCase < ExerbTestCase

  def test_none
    make('kcode.none', 'none')
    assert_equal(normalize(`ruby ./kcode.none.rb`), normalize(`./kcode.none.exe`))
  end

  def test_euc
    make('kcode.euc', 'euc')
    assert_equal(normalize(`ruby -Ke ./kcode.euc.rb`), normalize(`./kcode.euc.exe`))
  end

  def test_sjis
    make('kcode.sjis', 'sjis')
    assert_equal(normalize(`ruby -Ks ./kcode.sjis.rb`), normalize(`./kcode.sjis.exe`))
  end

  def test_utf8
    make('kcode.utf8', 'utf8')
    assert_equal(normalize(`ruby -Ku ./kcode.utf8.rb`), normalize(`./kcode.utf8.exe`))
  end

end
