
#==============================================================================#
# exerb/archiveheader.rb
# $Id: archiveheader.rb,v 1.7 2003/01/14 10:29:07 yuya Exp $
#==============================================================================#

#==============================================================================#
# Exerb Module
module Exerb

  #============================================================================#
  # ArchiveHeader Class
  class ArchiveHeader

    OPTIONS_KCODE_NONE = 0
    OPTIONS_KCODE_EUC  = 1
    OPTIONS_KCODE_SJIS = 2
    OPTIONS_KCODE_UTF8 = 3

    ENTRY_TYPE_SCRIPT  = 1
    ENTRY_TYPE_LIBRARY = 2
    ENTRY_TYPE_BINARY  = 3

    #==========================================================================#
    # Initialize Method

    def initialize
      @signature        = nil
      @time_date_stamp  = nil
      @offset_to_name   = nil
      @number_of_name   = nil
      @offset_to_entry  = nil
      @number_of_entry  = nil
      @options          = nil
    end

    #==========================================================================#
    # Accessor

    attr_accessor :signature, :time_date_stamp, :offset_to_name, :number_of_name,
                  :offset_to_entry, :number_of_entry, :options

    #==========================================================================#
    # Class Methods

    def self.size
      return 4 * 7
    end

    #==========================================================================#
    # Instance Methods

    def pack
      return [@signature, @time_date_stamp, @offset_to_name, @number_of_name, @offset_to_entry, @number_of_entry, @options].pack('Z4L6')
    end

  end # ArchiveHeader

end # Exerb

#==============================================================================#
#==============================================================================#
