###################################
#
# vrtwopane.rb
# Programmed by  nyasu <nyasu@osk.3web.ne.jp>
# Copyright 1999-2001 Nishikawa,Yasuhiro
#
# More information at http://www.threeweb.ad.jp/~nyasu/software/vrproject.html
# (in Japanese)
#
###################################

vr_DIR="vr/" unless vr_DIR
require vr_DIR+'vruby'
require vr_DIR+'vrhandler'

=begin
= VisualuRuby(tmp) Multi-pane Window
=end


module VRTwoPane
=begin
==VRTwoPane
This module is a base module for VRVertTwoPane and VRHorizTwoPane.
The meanings of 'Upper' and 'Lower' depend on those modules.
 
--- addPanedControl(type,name,caption,astyle)
    Adds a new control. This can be called only twice. The first call adds
    an upper/left control and the next call adds lower/right control.
    The third call causes RuntimeError.

--- addControlUpper(type,name,caption,astyle)
    ((*obsolete*)).
    Adds new control on the window upperside or leftside.
    The arguments are the same of VRParent#addControl.
--- addControlLower(type,name,caption,astyle)
    ((*obsolete*)).
    Adds new control on the window downside or rightside.
    The arguments are the same of VRParent#addControl.
=end

#  include VRMouseFeasible
  include VRParent

  attr :ratio,1
  attr :seperatorheight,1
  attr :pane_1
  attr :pane_2

  def twopaneinit
    @_vr_dragging=false
    @ratio=0.5
    @seperatorheight=6
    @_vr_app=@screen.application
    @_vr_acmethod=self.method(:addControlUpper) unless @_vr_acmethod
    addHandler WMsg::WM_LBUTTONUP,  "vrseplbuttonup",  MSGTYPE::ARGINTSINTSINT,nil
    addHandler WMsg::WM_LBUTTONDOWN,"vrseplbuttondown",MSGTYPE::ARGINTSINTSINT,nil
    addHandler WMsg::WM_SIZE,       "vrpaneresize",    MSGTYPE::ARGLINTINT,nil
    addHandler WMsg::WM_MOUSEMOVE,  "vrsepmousemove",  MSGTYPE::ARGINTSINTSINT,nil
    acceptEvents [
      WMsg::WM_SIZE,WMsg::WM_LBUTTONUP,WMsg::WM_LBUTTONDOWN,WMsg::WM_MOUSEMOVE
     ]
  end
  def vrinit
    super
    twopaneinit
  end

  def addControlUpper(type,name,caption,style=0)
    @pane_1=addControl(type,name,caption,0,0,10,10,style)
    @_vr_acmethod=self.method(:addControlLower)
  end
  def addControlLower(type,name,caption,style=0)
    @pane_2=addControl(type,name,caption,0,20,10,10,style)
    @_vr_acmethod=self.method(:addControlIllegal)
  end
  def addControlIllegal(*arg)
    raise "added more than two child windows."
  end

  def addPanedControl(*args)
    @_vr_acmethod.call(*args)
  end

  def self_vrseplbuttondown(shift,x,y)
    setCapture
    @_vr_dragging=true
    @_vr_app.setCursor @_vr_dragcur
    x,y,@_vr_w,@_vr_h = self.clientrect   #attr w,h is the size when drag starts.
  end

  def self_vrseplbuttonup(shift,x,y)
    releaseCapture
    @_vr_dragging=false
    splitterDragEnd(x,y)
  end

  def self_vrsepmousemove(shift,x,y)
    @_vr_app.setCursor @_vr_dragcur
    return unless @_vr_dragging
    splitterDragging(x,y)
  end

  def self_vrpaneresize(w,h)
    return unless @pane_1 and @pane_2
    x,y,w,h = self.clientrect
    resizepane(x,y,w,h,@ratio)
  end

  def splitterDragEnd(*arg) end
  def splitterDragging(*arg) end
  def resizepane(*arg) end
end

module VRVertTwoPane
=begin
== VRVertTwoPane
This module is a kind of VRTwoPane to separate the window vertically 
and places the controls in the separeted area.
=end

  include VRTwoPane

  def vrinit
    super
    @_vr_dragcur = @_vr_app::SysCursors::SizeNS()
  end

  def splitterDragEnd(x,y)
    @ratio=y.to_f/@_vr_h
  end

  def splitterDragging(x,y)
    sh=(@seperatorheight/2).to_i
    return if y+sh>@_vr_h || y<0
    @pane_1.move 0,0,@_vr_w,y-sh
    @pane_2.move 0,y+sh,@_vr_w,@_vr_h-y-sh
  end

  def resizepane(x,y,w,h,ratio)
    ys = (h*@ratio).to_i
    sh=(@seperatorheight/2).to_i
    @pane_1.move 0,0,w,ys-sh
    @pane_2.move 0,ys+sh,w,h-ys-sh
  end
end

module VRHorizTwoPane
=begin
== VRHorizTwoPane
This module is a kind of VRTwoPane to separate the window horizontally 
and places the controls in the separeted area.
=end
  include VRTwoPane

  def vrinit
    super
    @_vr_dragcur = @_vr_app::SysCursors::SizeWE()
  end

  def splitterDragEnd(x,y)
    @ratio=x.to_f/@_vr_w
  end

  def splitterDragging(x,y)
    sh=(@seperatorheight/2).to_i
    return if x+sh>@_vr_w || x<0
    @pane_1.move 0,0,x-sh,@_vr_h
    @pane_2.move x+sh,0,@_vr_w-x-sh,@_vr_h
  end

  def resizepane(x,y,w,h,ratio)
    xs = (w*ratio).to_i
    sh=(@seperatorheight/2).to_i
    return if x+sh>w || x<0
    @pane_1.move 0,0,xs-sh,h
    @pane_2.move xs+sh,0,w-xs-sh,h
  end
end

