/****
 *  $Id: compile.c 24 2004-08-18 11:19:08Z ko1 $
 *  Create : K.S. 04/08/25 02:31:54
*/

#include "ruby.h"

void
debug_indent(int level, int debug_level, int indent_level)
{
    if (level < debug_level) {
	int i;
	for (i = 0; i < indent_level; i++) {
	    printf(" ");
	}
	fflush(stdout);
    }
}

VALUE
debug_value(int level, int debug_level, char *header, VALUE obj)
{
    if (level < debug_level) {
	VALUE str;
	str = rb_inspect(obj);
	printf("DBG> %s: %s\n", header,
	       obj == -1 ? "" : StringValueCStr(str));
	fflush(stdout);
    }
    return obj;
}

void
debug_v(VALUE v)
{
    debug_value(0, 1, "", v);
}

ID
debug_id(int level, int debug_level, char *header, ID id)
{
    if (level < debug_level) {
	printf("DBG> %s: %s\n", header, rb_id2name(id));
	fflush(stdout);
    }
    return id;
}

void
gc_check_func(void)
{
    int i;
#define GCMKMAX 0x10
    for (i = 0; i < GCMKMAX; i++) {
	rb_ary_new2(1000);
    }
    rb_gc();
}

void
debug_breakpoint(void)
{
    /* */
}
