
#==============================================================================#
# $Id: config.rb,v 1.20 2006/07/06 00:56:20 yuya Exp $
#==============================================================================#

require 'rbconfig'

#==============================================================================#

module Exerb

  # Search directories of a core.
  # If running exerb on exerb, Add self path to the search directories of a core.
  CORE_PATH = [
    (File.dirname(ExerbRuntime.filepath) if defined?(ExerbRuntime)),
    ENV['EXERBCORE'],
    File.join(Config::CONFIG['datadir'], 'exerb'),
    '.',
  ].compact

  # Name definitions of a core.
  CORE_NAME = {
    'cui'    => 'ruby184c.exc',
    'cuid'   => 'ruby184cd.exc',
    'cuirt'  => 'ruby184crt.exc',
    'cuirtd' => 'ruby184crtd.exc',
    'gui'    => 'ruby184g.exc',
    'guid'   => 'ruby184gd.exc',
    'guirt'  => 'ruby184grt.exc',
    'guirtd' => 'ruby184grtd.exc',
    'cui19'  => 'ruby190c.exc',
    'gui19'  => 'ruby190g.exc',
    'cui20'  => 'ruby200c.exc',
    'gui20'  => 'ruby200g.exc',
  }

  # Descriptions of a core.
  CORE_DESC = {
    # FIXME: Add descriptions
    # 'ruby182c.exc' => '...',
  }

end # Exerb

#==============================================================================#

# Load a configuration file of Exerb Core Collection if found that.
configcc = File.join(File.dirname(__FILE__), 'configcc.rb')
if File.exist?(configcc)
  require(configcc)
end

#==============================================================================#
#==============================================================================#
