
#==============================================================================#
# $Id: config.rb,v 1.19 2006/05/16 01:44:26 yuya Exp $
#==============================================================================#

require 'rbconfig'

#==============================================================================#

module Exerb

  # Search directories of a core.
  # If running exerb on exerb, Add self path to the search directories of a core.
  CORE_PATH = [
    (File.dirname(ExerbRuntime.filepath) if defined?(ExerbRuntime)),
    ENV['EXERBCORE'],
    File.join(Config::CONFIG['datadir'], 'exerb'),
    '.',
  ].compact

  # Name definitions of a core.
  CORE_NAME = {
    'cui'   => 'ruby184c.exc',
    'cuid'  => 'ruby184cd.exc',
    'cuirt' => 'ruby184crt.exc',
    'gui'   => 'ruby184g.exc',
    'guid'  => 'ruby184gd.exc',
    'guirt' => 'ruby184grt.exc',
    'cui19' => 'ruby190c.exc',
    'gui19' => 'ruby190g.exc',
  }

  # Descriptions of a core.
  CORE_DESC = {
    # FIXME: Add descriptions
    # 'ruby182c.exc' => '...',
  }

end # Exerb

#==============================================================================#

# Load a configuration file of Exerb Core Collection if found that.
configcc = File.join(File.dirname(__FILE__), 'configcc.rb')
if File.exist?(configcc)
  require(configcc)
end

#==============================================================================#
#==============================================================================#
