// $Id: exerb.h,v 1.6 2002/10/09 15:57:07 yuya Exp $

// Options - Kanji Code
#define EXERB_OPTIONS_KCODE_NONE  0
#define EXERB_OPTIONS_KCODE_EUC   1
#define EXERB_OPTIONS_KCODE_SJIS  2
#define EXERB_OPTIONS_KCODE_UTF8  3


typedef struct {
    WORD   Signature;                     // 00 - Magic number
    WORD   LastPageSize;                  // 02 - Bytes on last page of file
    WORD   TotalPagesInFile;              // 04 - Pages in file
    WORD   RelocationItems;               // 06 - Relocations
    WORD   ParagraphsInHeader;            // 08 - Size of header in paragraphs
    WORD   MinimumExtraParagraphs;        // 0A - Minimum extra paragraphs needed
    WORD   MaximumExtraParagraphs;        // 0C - Maximum extra paragraphs needed
    WORD   InitialStackSegment;           // 0E - Initial (relative) SS value
    WORD   InitialStackPointer;           // 10 - Initial SP value
    WORD   ComplementedChecksum;          // 12 - Checksum
    WORD   InitialInstructionPointer;     // 14 - Initial IP value
    WORD   InitialCodeSegment;            // 16 - Initial (relative) CS value
    WORD   RelocationTableOffset;         // 18 - File address of relocation table
    WORD   OverlayNumber;                 // 1A - Overlay number
    WORD   Reserved11;                    // 1C - Reserved words
    WORD   Reserved12;                    // 1E - Reserved words
    WORD   Reserved13;                    // 20 - Reserved words
    WORD   Reserved14;                    // 22 - Reserved words
    WORD   OEMIdentifier;                 // 24 - OEM identifier (for e_oeminfo)
    WORD   OEMInformation;                // 26 - OEM information; e_oemid specific
    WORD   Reserved21;                    // 28 - Reserved words
    WORD   Reserved22;                    // 2A - Reserved words
    WORD   Reserved23;                    // 2C - Reserved words
    WORD   Reserved24;                    // 2E - Reserved words
    DWORD  OffsetToArchive;               // 30 - Reserved words
    DWORD  SizeOfArchive;                 // 34 - Reserved words
    DWORD  SizeOfCompressedArchive;       // 38 - Reserved words
    LONG   OffsetToNewHeader;             // 3C - File address of new exe header
} EXERB_DOS_HEADER, *PEXERB_DOS_HEADER;

typedef struct {
	DWORD Signature;                        // 00 - Signature 0x59425552:"RUBY"
	DWORD TimeDateStamp;                    // 04 - Creating Date and Time
	DWORD OffsetToName;                     // 08 - Offset to Name Table
	DWORD NumberOfName;                     // 0C - Number of Name Table Entries
	DWORD OffsetToScript;                   // 10 - Offset to Script Table
	DWORD NumberOfScript;                   // 14 - Number of Script Table Entries
	DWORD OffsetToDLL;                      // 18 - Offset to DLL Table
	DWORD NumberOfDLL;                      // 1C - Number of DLL Table Entries
	union {
		DWORD All;
		struct {
			DWORD Kcode:2;
			DWORD Reserved:30;
		};
	} Options;
} EXERB_ARCHIVE_HEADER, *PEXERB_ARCHIVE_HEADER;

typedef struct {
	DWORD ID;      // 00 - NameID
	DWORD Offset;  // 04 - Offset to Name
	DWORD Size;    // 08 - Size of Name
} EXERB_NAME_HEADER, *PEXERB_NAME_HEADER;

typedef struct {
	DWORD NameID;  // 00 - NameID
	DWORD Offset;  // 04 - Offset to Script
	DWORD Size;    // 08 - Size of Script
} EXERB_SCRIPT_HEADER, *PEXERB_SCRIPT_HEADER;

typedef struct {
	DWORD NameID;  // 00 - NameID
	DWORD Offset;  // 04 - Offset to DLL
	DWORD Size;    // 08 - Size of DLL
} EXERB_DLL_HEADER, *PEXERB_DLL_HEADER;
