
#==============================================================================#
# exerb/scripttable.rb
# $Id: scripttable.rb,v 1.4 2002/09/20 09:12:12 yuya Exp $
#==============================================================================#

#==============================================================================#
# Exerb Module
module Exerb

  #============================================================================#
  # ScriptTable Class
  class ScriptTable

    #==========================================================================#
    # Initialize Method

    def initialize
      @script = []
    end

    #==========================================================================#
    # Instance Methods

    def add(name_id, data)
      @script << Item.new(name_id, data)
    end

    def size
      return @script.size
    end

    def pack
      header_size = ScriptHeader.size * @script.size
      header = ''
      table  = ''

      @script.each { |script|
        script_header = ScriptHeader.new
        script_header.name_id = script.name_id
        script_header.offset  = header_size + table.size
        script_header.size    = script.size

        header << script_header.pack
        table  << script.pack
      }

      return header + table
    end

    #==========================================================================#
    # Item Class
    class Item

      #========================================================================#
      # Initialize Method

      def initialize(name_id, data)
        @name_id = name_id
        @data    = data
      end

      #========================================================================#
      # Accessor

      attr_reader :name_id, :data

      #========================================================================#
      # Instance Method

      def size
        return @data.size
      end

      def pack
        return @data + "\0"
      end

    end # Item

  end # ScriptTable

end # Exerb

#==============================================================================#
#==============================================================================#
