
#==============================================================================#
# $Id: testcase.rb,v 1.16 2005/04/15 09:42:52 yuya Exp $
#==============================================================================#

require 'test/unit/testcase'
require 'exerb/recipe'
require 'exerb/executable'

#==============================================================================#

module ExerbTestCase

  def setup
    @name = self.name
    self.setup_exe
  end

  def setup_exe
    create_exe(@name)
  end

  def name
    raise(NotImplementedError)
  end

  def create_exe(name, exename = name)
    corefile   = '../data/exerb/ruby182c.exc'
    recipe     = Exerb::Recipe.new_from_file("#{name}/#{exename}.exr")
    executable = Exerb::Executable.new_from_file(corefile)
    executable.rsrc.add_archive(recipe.archive)
    executable.write_to_file("#{name}/#{exename}.exe")
  end

  def execute_cmd(cmd)
    return `#{cmd}`.gsub(/\r\n/, "\n")
  end

  def execute_exe(name, argv = '')
    return execute_cmd("#{name}/#{name}.exe #{argv}")
  end

  def read_file(filepath)
    return File.open(filepath) { |file| file.read }.gsub(/\r\n/) {"\n"}
  end

  def read_result(name)
    return read_file("#{name}/#{name}.ret")
  end

end # ExerbTestCase

#==============================================================================#
#==============================================================================#
