
#==============================================================================#
# $Id: image_resource_data_entry.rb,v 1.3 2005/03/14 04:58:05 yuya Exp $
#==============================================================================#

require 'exerb/win32/struct/base'

#==============================================================================#

module Exerb

  module Win32

    module Struct

      class ImageResourceDataEntry < Base

        FORMAT = 'LLLL'

        def initialize
          super()
          @offset_to_data = 0
          @size_of_data   = 0
          @code_page      = 0
          @reserved       = 0
        end

        attr_accessor :offset_to_data, :size_of_data, :code_page, :reserved

        def pack
          return [@offset_to_data, @size_of_data, @code_page, @reserved].pack(FORMAT)
        end

        def unpack(bin)
          @offset_to_data, @size_of_data, @code_page, @reserved = bin.unpack(FORMAT)
          return self
        end

      end # ImageResourceDataEntry

    end # Struct

  end # Win32

end # Exerb

#==============================================================================#
#==============================================================================#
