
#==============================================================================#
# $Id: icon_header.rb,v 1.2 2005/03/14 04:58:05 yuya Exp $
#==============================================================================#

require 'exerb/win32/struct/base'

#==============================================================================#

module Exerb

  module Win32

    module Struct

      class IconHeader < Base

        FORMAT = 'SSS'

        def initialize
          @reserved = 0
          @type     = 0
          @count    = 0
        end

        attr_accessor :reserved, :type, :count

        def pack
          return [@reserved, @type, @count].pack(FORMAT)
        end

        def unpack(bin)
          @reserved, @type, @count = bin.unpack(FORMAT)
          return self
        end

      end # IconHeader

    end # Struct

  end # Win32

end # Exerb

#==============================================================================#
#==============================================================================#
