
#==============================================================================#
# $Id: icon_dir_entry.rb,v 1.3 2005/03/14 04:58:05 yuya Exp $
#==============================================================================#

require 'exerb/win32/struct/base'

#==============================================================================#

module Exerb

  module Win32

    module Struct

      class IconDirEntry < Base

        FORMAT = 'CCCCSSLL'

        def initialize
          @width        = 0
          @height       = 0
          @color_count  = 0
          @reserved     = 0
          @planes       = 0
          @bit_count    = 0
          @bytes_in_res = 0
          @image_offset = 0
        end

        attr_accessor :width, :height, :color_count, :reserved, :planes, :bit_count, :bytes_in_res, :image_offset

        def pack
          return [@width, @height, @color_count, @reserved, @planes, @bit_count, @bytes_in_res, @image_offset].pack(FORMAT)
        end

        def unpack(bin)
          @width, @height, @color_count, @reserved, @planes, @bit_count, @bytes_in_res, @image_offset = bin.unpack(FORMAT)
          return self
        end

      end # IconDirEntry

    end # Struct

  end # Win32

end # Exerb

#==============================================================================#
#==============================================================================#
