
#==============================================================================#
# $Id: plugin_table.rb,v 1.4 2005/03/14 06:55:41 yuya Exp $
#==============================================================================#

require 'exerb/utility'

#==============================================================================#

module Exerb

  class PluginTable

    def initialize
      @entries = []
    end

    def add(data)
      @entries << Entry.new(data)
      return @entries.last
    end

    def add_from_file(path)
      return File.open(path, 'rb') { |file| self.add(file.read) }
    end

    def pack
      headers = ''
      pool    = ''

      @entries.each { |entry|
        headers << entry.pack_header(pool)
        pool    << entry.pack_pool
      }

      packed_headers = Utility.alignment16(headers)
      packed_pool    = Utility.alignment16(pool)

      table_header = PluginTableHeader.new
      table_header.signature         = PluginTableHeader::SIGNATURE
      table_header.number_of_headers = @entries.size
      table_header.offset_of_headers = Utility.alignment16(table_header.pack).size
      table_header.offset_of_pool    = table_header.offset_of_headers + packed_headers.size

      return Utility.alignment16(table_header.pack) + packed_headers + packed_pool
    end

    class Entry

      def initialize(data)
        @data = data
      end

      attr_reader :data

      def pack_header(pool)
        entry_header = PluginEntryHeader.new
        entry_header.offset_of_plugin = pool.size
        entry_header.size_of_plugin   = @data.size

        return entry_header.pack
      end

      def pack_pool
        return Utility.alignment16(@data)
      end

    end # Entry

  end # PluginTable

  class PluginTableHeader

    SIGNATURE = 0x01005450

    def initialize
      @signature         = 0
      @number_of_headers = 0
      @offset_of_headers = 0
      @offset_of_pool    = 0
    end

    attr_accessor :signature, :number_of_headers, :offset_of_headers, :offset_of_pool

    def pack
      return [@signature, @number_of_headers, @offset_of_headers, @offset_of_pool].pack('LSLL')
    end

  end # PluginTableHeader

  class PluginEntryHeader

    def initialize
      @offset_of_plugin = 0
      @size_of_plugin   = 0
    end

    attr_accessor :offset_of_plugin, :size_of_plugin

    def pack
      return [@offset_of_plugin, @size_of_plugin].pack('LL')
    end

  end # PluginEntryHeader

end # Exerb

#==============================================================================#
#==============================================================================#
