
#==============================================================================#
# $Id: mkexr.rb,v 1.4 2005/04/14 16:53:23 yuya Exp $
#==============================================================================#

BEGIN {
  #STDERR.puts('mkexr: this is obsolete program. please use mkexy.')
}

END {
  files = [['add_ruby_script', $0, $0]]

  $".sort.each { |filename|
    next if /#{File.basename(__FILE__)}$/ =~ filename

    type = case filename
           when /\.rb$/i       then "add_ruby_script"
           when /\.(so|dll)$/i then "add_extension_library"
           else "#unknown"
           end

    if File.exist?(filename)
      files << [type, filename, filename]
    else
      $LOAD_PATH.each { |path|
        filepath = File.join(path, filename)
        if File.exist?(filepath)
          files << [type, filename, filepath]
          break
        end
      }
    end
  }

  exrfile = $0.sub(/\.rb$/, '.exr')
  exrfile << ".exr" unless /\.exr$/ =~ exrfile
  makfile = $0.sub(/\.rb$/, '.mak')
  makfile << ".mak" unless /\.mak$/ =~ makfile
  exefile = $0.sub(/\.rb$/, '.exe')
  exefile << ".exe" unless /\.exe$/ =~ exefile

  File.open(exrfile, 'w') { |file|
    file.puts "# generated by mkexr.rb"
    file.puts "set_kcode\t#{$KCODE.downcase}"
    files.each { |type, internalname, filename|
      if internalname == filename
        file.puts "#{type}\t#{internalname}"
      else
        file.puts "#{type}\t#{internalname}\t#{filename}"
      end
    }
  }

  File.open(makfile, 'w') { |file|
    file.puts "# generated by mkexr.rb"
    file.puts
    file.puts "EXERB  = exerb"
    file.puts "OUTPUT = #{exefile}"
    file.puts "INPUT  = #{exrfile}"
    file.puts "FILES  = " + files.collect { |type, internalname, filename| filename }.join(" ")
    file.puts
    file.puts "all: $(OUTPUT)"
    file.puts
    file.puts "$(OUTPUT): $(INPUT) $(FILES)"
    file.puts "\t$(EXERB) $(INPUT)"
    file.puts "\tchmod +x $(OUTPUT)"
    file.puts
    file.puts "go: all"
    file.puts "\t$(OUTPUT)"
    file.puts
    file.puts "clean:"
    file.puts "\trm $(OUTPUT)"
  }
}

#==============================================================================#
#==============================================================================#
