
#==============================================================================#
# exerb/binary.rb
# $Id: binary.rb,v 1.6 2002/09/20 09:12:12 yuya Exp $
#==============================================================================#

#==============================================================================#
# Exerb Module
module Exerb

  #============================================================================#
  # Binary Module
  module Binary

    #==========================================================================#
    # Archive Class
    class Archive

      #========================================================================#
      # Initialize Method

      def initialize(binary)
        @binary = binary
      end

      #========================================================================#
      # Class Methods

      def self.new_from_file(filepath)
        return self.new(File.open(filepath, 'rb') { |file| file.read })
      end

      #========================================================================#
      # Instance Methods

      def size
        return @binary.size
      end

      def selfcheck
        unless @binary[0, 4] == 'RUBY'
          raise 'the header of the archive has invalid signature'
        end
      end

      def output(io)
        io.print(@binary)
      end

    end # Archive

    #==========================================================================#
    # Core Class
    class Core

      #========================================================================#
      # Class Constants

      ARCHIVE_OFFSET = 0x34
      ARCHIVE_SIZE   = 0x38

      #========================================================================#
      # Initialize Method

      def initialize(binary)
        @binary = binary
      end

      #========================================================================#
      # Class Methods

      def self.new_from_file(filepath)
        return self.new(File.open(filepath, 'rb') { |file| file.read })
      end

      #========================================================================#
      # Instance Method

      def size
        return @binary.size
      end

      def archive_offset
        return @binary[ARCHIVE_OFFSET, 4].unpack('I')[0]
      end

      def archive_offset=(value)
        @binary[ARCHIVE_OFFSET, 4] = [value].pack('I')
      end

      def archive_size
        return @binary[ARCHIVE_SIZE, 4].unpack('I')[0]
      end

      def archive_size=(value)
        @binary[ARCHIVE_SIZE, 4] = [value].pack('I')
      end

      def selfcheck
        unless @binary[0, 2] == 'MZ'
          raise 'the header of the core has invalid signature'
        end

        unless self.archive_offset == 0 && self.archive_size == 0
          raise 'the core is already joined with an archive'
        end
      end

      def output(io)
        io.print(@binary)
      end

    end # Core

    #==========================================================================#
    # Executable Class
    class Executable

      #========================================================================#
      # Initialize Method

      def initialize(archive, core)
        @archive = archive
        @core    = core
      end

      #========================================================================#
      # Instance Method

      def selfcheck
        @archive.selfcheck
        @core.selfcheck
      end

      def output(io)
        @core.archive_offset = @core.size
        @core.archive_size   = @archive.size
        @core.output(io)
        @archive.output(io)
      end

      def output_to_file(filepath)
        File.open(filepath, 'wb') { |file|
          self.output(file)
        }
      end

    end # Executable

  end # Binary

end # Exerb

#==============================================================================#
#==============================================================================#
