/*
 * Decompiled with CFR 0.152.
 */
package net.w_horse.excelpojo.excel;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.text.DateFormat;
import java.util.Date;
import net.w_horse.excelpojo.ExcelPOJOException;
import net.w_horse.excelpojo.bean.Utils;
import net.w_horse.excelpojo.converter.CellFieldConverter;
import net.w_horse.excelpojo.converter.NothingConverter;
import net.w_horse.excelpojo.excel.CellDateFormat;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.springframework.util.ReflectionUtils;

public class ExcelUtils {
    public static Object getCellValue(Cell cell) {
        if (cell == null) {
            return null;
        }
        switch (cell.getCellType()) {
            case 3: {
                return "";
            }
            case 1: {
                return cell.getRichStringCellValue().getString();
            }
            case 0: {
                if (DateUtil.isCellDateFormatted((Cell)cell) || CellDateFormat.contains(cell.getCellStyle().getDataFormat())) {
                    return cell.getDateCellValue();
                }
                return ExcelUtils.getNumericType(cell);
            }
            case 4: {
                return cell.getBooleanCellValue();
            }
            case 2: {
                return ExcelUtils.getFormulaType(cell);
            }
        }
        return "";
    }

    public static <T> T getCellValue(Cell cell, Class<T> clazz) throws ExcelPOJOException {
        return ExcelUtils.getCellValue(cell, clazz, new NothingConverter());
    }

    public static <T> T getCellValue(Cell cell, Class<T> clazz, CellFieldConverter cellFieldConverter) throws ExcelPOJOException {
        Object object;
        if (cell == null) {
            return (T)Utils.convertIfNecessary(null, clazz);
        }
        switch (cell.getCellType()) {
            case 3: {
                object = cellFieldConverter.convertCell2Field("");
                break;
            }
            case 1: {
                object = cellFieldConverter.convertCell2Field(cell.getRichStringCellValue().getString());
                break;
            }
            case 0: {
                if (DateUtil.isCellDateFormatted((Cell)cell) || CellDateFormat.contains(cell.getCellStyle().getDataFormat())) {
                    object = ExcelUtils.getDateType(cell, clazz, cellFieldConverter);
                    break;
                }
                if (clazz.equals(String.class)) {
                    DataFormatter dataFormatter = new DataFormatter();
                    String string = dataFormatter.formatCellValue(cell);
                    if (string.endsWith("_ ")) {
                        string = string.substring(0, string.length() - 2);
                    }
                    return (T)string.trim();
                }
                object = cellFieldConverter.convertCell2Field(ExcelUtils.getNumericType(cell));
                break;
            }
            case 4: {
                object = cellFieldConverter.convertCell2Field(cell.getBooleanCellValue());
                break;
            }
            case 2: {
                object = ExcelUtils.getFormulaType(cell, clazz, cellFieldConverter);
                break;
            }
            default: {
                object = cellFieldConverter.convertCell2Field("");
            }
        }
        return (T)Utils.convertIfNecessary(object, clazz);
    }

    private static <T> T getFormulaType(Cell cell, Class<T> clazz, CellFieldConverter cellFieldConverter) throws ExcelPOJOException {
        FormulaEvaluator formulaEvaluator = cell.getSheet().getWorkbook().getCreationHelper().createFormulaEvaluator();
        return ExcelUtils.getCellValue(formulaEvaluator.evaluateInCell(cell), clazz, cellFieldConverter);
    }

    private static Object getFormulaType(Cell cell) {
        FormulaEvaluator formulaEvaluator = cell.getSheet().getWorkbook().getCreationHelper().createFormulaEvaluator();
        return ExcelUtils.getCellValue(formulaEvaluator.evaluateInCell(cell));
    }

    private static <T> T getDateType(Cell cell, Class<T> clazz, CellFieldConverter cellFieldConverter) throws ExcelPOJOException {
        Object object = cellFieldConverter.convertCell2Field(cell.getDateCellValue());
        if (cellFieldConverter instanceof NothingConverter && clazz.equals(String.class)) {
            return (T)ExcelUtils.getDateTypeString(cell);
        }
        return (T)object;
    }

    private static String getDateTypeString(Cell cell) {
        CellStyle cellStyle = cell.getCellStyle();
        Date date = cell.getDateCellValue();
        DateFormat dateFormat = CellDateFormat.getFormt(cellStyle.getDataFormat()).getDateFormat();
        return dateFormat.format(date);
    }

    private static Object getNumericType(Cell cell) {
        BigDecimal bigDecimal = new BigDecimal(cell.getNumericCellValue(), new MathContext(17));
        try {
            BigInteger bigInteger = bigDecimal.toBigIntegerExact();
            if (bigInteger.compareTo(BigInteger.valueOf(bigInteger.intValue())) == 0) {
                return bigInteger.intValue();
            }
            return bigInteger;
        }
        catch (ArithmeticException arithmeticException) {
            return cell.getNumericCellValue();
        }
    }

    public static void setCellValue(Cell cell, Object object, CellFieldConverter cellFieldConverter) {
        if (cell == null) {
            return;
        }
        if (object == null) {
            object = "";
        }
        try {
            Object object2 = cellFieldConverter.convertField2Cell(object);
            Class<Object> clazz = object2.getClass();
            if (clazz.equals(Integer.TYPE) || clazz.equals(Integer.class) || clazz.equals(Double.TYPE) || clazz.equals(Double.class) || clazz.equals(Short.TYPE) || clazz.equals(Short.class) || clazz.equals(Long.TYPE) || clazz.equals(Long.class) || clazz.equals(Float.TYPE) || clazz.equals(Float.class)) {
                clazz = Double.TYPE;
            } else if (clazz.equals(Boolean.class)) {
                clazz = Boolean.TYPE;
            }
            Method method = cell.getClass().getDeclaredMethod("setCellValue", clazz);
            ReflectionUtils.invokeMethod((Method)method, (Object)cell, (Object[])new Object[]{object2});
        }
        catch (Exception exception) {
            cell.setCellValue(String.valueOf(object));
        }
    }
}

