/*
 * Decompiled with CFR 0.152.
 */
package net.w_horse.excelpojo.converter;

import java.util.HashMap;
import net.w_horse.excelpojo.converter.CellFieldConverter;
import org.springframework.util.StringUtils;

public class StringBooleanConverter
implements CellFieldConverter {
    public static final HashMap<Object, Object>[] TYPE_TRUE_FALSE;
    public static final HashMap<Object, Object>[] TYPE_YES_NO;
    public static final HashMap<Object, Object>[] TYPE_OX;
    public static final HashMap<Object, Object>[] TYPE_ON_OFF;
    public static final HashMap<Object, Object>[] TYPE_10;
    public static final HashMap<Object, Object>[] TYPE_10_INTEGER;
    public static final HashMap<Object, Object>[] TYPE_OK_CANCEL;
    public static final FalseType FALSE;
    private HashMap<Object, Object>[] mappings = TYPE_TRUE_FALSE;
    private boolean ignoreCase = true;
    private CapitalizeType capitalizeType = CapitalizeType.NOTHING;

    public StringBooleanConverter() {
        this.mappings = TYPE_TRUE_FALSE;
        this.capitalizeType = CapitalizeType.NOTHING;
    }

    @Override
    public Object convertCell2Field(Object object) {
        return this.getValue(object, this.mappings[0]);
    }

    @Override
    public Object convertField2Cell(Object object) {
        return this.getValue(object, this.mappings[1]);
    }

    public void setMappings(HashMap<Object, Object>[] hashMapArray) {
        this.mappings = hashMapArray;
    }

    public void setIgnoreCase(boolean bl) {
        this.ignoreCase = bl;
    }

    public void setCapitalizeType(CapitalizeType capitalizeType) {
        this.capitalizeType = capitalizeType;
    }

    private Object getValue(Object object, HashMap<Object, Object> hashMap) {
        Object object2 = null;
        if (object instanceof String) {
            for (Object object3 : hashMap.keySet()) {
                if (!object3.getClass().equals(String.class) || !((String)object).equals((String)object3) && (!this.ignoreCase || !((String)object).equalsIgnoreCase((String)object3))) continue;
                object2 = hashMap.get(object3);
                break;
            }
        } else {
            object2 = hashMap.get(object);
        }
        if (object2 == null) {
            object2 = hashMap.get((Object)FALSE);
        }
        return object2 instanceof String ? this.capitalize((String)object2) : object2;
    }

    private String capitalize(String string) {
        String string2;
        switch (this.capitalizeType) {
            case UPPER_CASE: {
                string2 = string.toUpperCase();
                break;
            }
            case LOWER_CASE: {
                string2 = string.toLowerCase();
                break;
            }
            case CAPITALIZE: {
                string2 = StringUtils.capitalize((String)string);
                break;
            }
            case UN_CAPITARIZE: {
                string2 = StringUtils.uncapitalize((String)string);
                break;
            }
            default: {
                string2 = string;
            }
        }
        return string2;
    }

    static {
        FALSE = FalseType.FALSE;
        TYPE_TRUE_FALSE = new HashMap[2];
        StringBooleanConverter.TYPE_TRUE_FALSE[0] = new HashMap();
        TYPE_TRUE_FALSE[0].put("true", Boolean.TRUE);
        TYPE_TRUE_FALSE[0].put("false", Boolean.FALSE);
        TYPE_TRUE_FALSE[0].put((Object)FALSE, Boolean.FALSE);
        StringBooleanConverter.TYPE_TRUE_FALSE[1] = new HashMap();
        TYPE_TRUE_FALSE[1].put(Boolean.TRUE, "true");
        TYPE_TRUE_FALSE[1].put(Boolean.FALSE, "false");
        TYPE_TRUE_FALSE[1].put((Object)FALSE, "false");
        TYPE_YES_NO = new HashMap[2];
        StringBooleanConverter.TYPE_YES_NO[0] = new HashMap();
        TYPE_YES_NO[0].put("yes", Boolean.TRUE);
        TYPE_YES_NO[0].put("no", Boolean.FALSE);
        TYPE_YES_NO[0].put("y", Boolean.TRUE);
        TYPE_YES_NO[0].put("n", Boolean.FALSE);
        TYPE_YES_NO[0].put((Object)FALSE, Boolean.FALSE);
        StringBooleanConverter.TYPE_YES_NO[1] = new HashMap();
        TYPE_YES_NO[1].put(Boolean.TRUE, "yes");
        TYPE_YES_NO[1].put(Boolean.FALSE, "no");
        TYPE_YES_NO[1].put((Object)FALSE, "no");
        TYPE_OX = new HashMap[2];
        StringBooleanConverter.TYPE_OX[0] = new HashMap();
        TYPE_OX[0].put("\u25cb", Boolean.TRUE);
        TYPE_OX[0].put("\u00d7", Boolean.FALSE);
        TYPE_OX[0].put((Object)FALSE, Boolean.FALSE);
        StringBooleanConverter.TYPE_OX[1] = new HashMap();
        TYPE_OX[1].put(Boolean.TRUE, "\u25cb");
        TYPE_OX[1].put(Boolean.FALSE, "\u00d7");
        TYPE_OX[1].put((Object)FALSE, "\u00d7");
        TYPE_ON_OFF = new HashMap[2];
        StringBooleanConverter.TYPE_ON_OFF[0] = new HashMap();
        TYPE_ON_OFF[0].put("on", Boolean.TRUE);
        TYPE_ON_OFF[0].put("off", Boolean.FALSE);
        TYPE_ON_OFF[0].put((Object)FALSE, Boolean.FALSE);
        StringBooleanConverter.TYPE_ON_OFF[1] = new HashMap();
        TYPE_ON_OFF[1].put(Boolean.TRUE, "on");
        TYPE_ON_OFF[1].put(Boolean.FALSE, "off");
        TYPE_ON_OFF[1].put((Object)FALSE, "off");
        TYPE_10 = new HashMap[2];
        StringBooleanConverter.TYPE_10[0] = new HashMap();
        TYPE_10[0].put("1", Boolean.TRUE);
        TYPE_10[0].put("0", Boolean.FALSE);
        TYPE_10[0].put((Object)FALSE, Boolean.FALSE);
        StringBooleanConverter.TYPE_10[1] = new HashMap();
        TYPE_10[1].put(Boolean.TRUE, "1");
        TYPE_10[1].put(Boolean.FALSE, "0");
        TYPE_10[1].put((Object)FALSE, "0");
        TYPE_10_INTEGER = new HashMap[2];
        StringBooleanConverter.TYPE_10_INTEGER[0] = new HashMap();
        TYPE_10_INTEGER[0].put(1, Boolean.TRUE);
        TYPE_10_INTEGER[0].put(0, Boolean.FALSE);
        TYPE_10_INTEGER[0].put((Object)FALSE, Boolean.FALSE);
        StringBooleanConverter.TYPE_10_INTEGER[1] = new HashMap();
        TYPE_10_INTEGER[1].put(Boolean.TRUE, 1);
        TYPE_10_INTEGER[1].put(Boolean.FALSE, 0);
        TYPE_10_INTEGER[1].put((Object)FALSE, 0);
        TYPE_OK_CANCEL = new HashMap[2];
        StringBooleanConverter.TYPE_OK_CANCEL[0] = new HashMap();
        TYPE_OK_CANCEL[0].put("ok", Boolean.TRUE);
        TYPE_OK_CANCEL[0].put("cancel", Boolean.FALSE);
        TYPE_OK_CANCEL[0].put((Object)FALSE, Boolean.FALSE);
        StringBooleanConverter.TYPE_OK_CANCEL[1] = new HashMap();
        TYPE_OK_CANCEL[1].put(Boolean.TRUE, "ok");
        TYPE_OK_CANCEL[1].put(Boolean.FALSE, "cancel");
        TYPE_OK_CANCEL[1].put((Object)FALSE, "cancel");
    }

    private static enum FalseType {
        FALSE;

    }

    public static enum CapitalizeType {
        NOTHING,
        UPPER_CASE,
        LOWER_CASE,
        CAPITALIZE,
        UN_CAPITARIZE;

    }
}

