/*
 * Decompiled with CFR 0.152.
 */
package org.bbreak.excella.reports.tag;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.util.PoiUtil;
import org.bbreak.excella.core.util.TagUtil;
import org.bbreak.excella.reports.model.ParamInfo;
import org.bbreak.excella.reports.model.ParsedReportInfo;
import org.bbreak.excella.reports.processor.ReportsParserInfo;
import org.bbreak.excella.reports.tag.ReportsTagParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleParamParser
extends ReportsTagParser<Object> {
    private static Log log = LogFactory.getLog(SingleParamParser.class);
    public static final String DEFAULT_TAG = "$";
    public static final String PARAM_VALUE = "";

    public SingleParamParser() {
        super(DEFAULT_TAG);
    }

    public SingleParamParser(String tag) {
        super(tag);
    }

    @Override
    public ParsedReportInfo parse(Sheet sheet, Cell tagCell, Object data) throws ParseException {
        ArrayList<String> tmpTargets = new ArrayList<String>();
        StringTokenizer tagTokenizer = new StringTokenizer(tagCell.getStringCellValue(), this.getTag());
        while (tagTokenizer.hasMoreTokens()) {
            tmpTargets.add(tagTokenizer.nextToken());
        }
        ArrayList<String> finalTargets = new ArrayList<String>();
        for (String tempTarget : tmpTargets) {
            if (tempTarget.startsWith("{") && !tempTarget.endsWith("}")) {
                finalTargets.add(tempTarget.substring(0, tempTarget.indexOf("}") + 1));
                finalTargets.add(tempTarget.substring(tempTarget.indexOf("}") + 1));
                continue;
            }
            finalTargets.add(tempTarget);
        }
        ParsedReportInfo parsedReportInfo = new ParsedReportInfo();
        ArrayList<String> paramValues = new ArrayList<String>();
        for (int i = 0; i < finalTargets.size(); ++i) {
            String target = (String)finalTargets.get(i);
            if (!target.startsWith("{")) {
                paramValues.add(target);
                continue;
            }
            target = this.getTag() + target;
            Map map = TagUtil.getParams((String)target);
            this.checkParam(map, tagCell);
            ReportsParserInfo reportsParserInfo = (ReportsParserInfo)data;
            ParamInfo paramInfo = reportsParserInfo.getParamInfo();
            if (paramInfo == null) continue;
            String replaceParam = (String)map.get(PARAM_VALUE);
            paramValues.add((String)this.getParamData(paramInfo, replaceParam));
            if (!log.isDebugEnabled()) continue;
            Workbook workbook = sheet.getWorkbook();
            String sheetName = workbook.getSheetName(workbook.getSheetIndex(sheet));
            log.debug((Object)("[\u30b7\u30fc\u30c8\u540d=" + sheetName + ",\u30bb\u30eb=(" + tagCell.getRowIndex() + "," + tagCell.getColumnIndex() + ")] " + tagCell.getStringCellValue() + " \u21d2 " + paramValues.get(i)));
        }
        if (paramValues.size() > 1) {
            StringBuilder builder = new StringBuilder();
            for (Object e : paramValues) {
                if (e instanceof Date) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
                    builder.append(sdf.format(e));
                    continue;
                }
                builder.append(e);
            }
            PoiUtil.setCellValue((Cell)tagCell, (Object)builder.toString());
            parsedReportInfo.setParsedObject(builder.toString());
        } else if (paramValues.size() == 1) {
            PoiUtil.setCellValue((Cell)tagCell, paramValues.get(0));
            parsedReportInfo.setParsedObject(paramValues.get(0));
        }
        parsedReportInfo.setDefaultRowIndex(tagCell.getRowIndex());
        parsedReportInfo.setDefaultColumnIndex(tagCell.getColumnIndex());
        parsedReportInfo.setRowIndex(tagCell.getRowIndex());
        parsedReportInfo.setColumnIndex(tagCell.getColumnIndex());
        return parsedReportInfo;
    }

    private void checkParam(Map<String, String> paramDef, Cell tagCell) throws ParseException {
    }

    @Override
    public boolean useControlRow() {
        return false;
    }

    public boolean isParse(Sheet sheet, Cell tagCell) throws ParseException {
        String cellTag;
        return tagCell.getCellType() == 1 && (cellTag = TagUtil.getTag((String)tagCell.getStringCellValue())).endsWith(this.getTag());
    }
}

