/*
 * Decompiled with CFR 0.152.
 */
package org.bbreak.excella.reports.tag;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.tag.TagParser;
import org.bbreak.excella.core.util.PoiUtil;
import org.bbreak.excella.core.util.TagUtil;
import org.bbreak.excella.reports.model.ParamInfo;
import org.bbreak.excella.reports.model.ParsedReportInfo;
import org.bbreak.excella.reports.processor.ReportsParserInfo;
import org.bbreak.excella.reports.tag.BlockRowRepeatParamParser;
import org.bbreak.excella.reports.tag.ReportsTagParser;
import org.bbreak.excella.reports.tag.RowRepeatParamParser;
import org.bbreak.excella.reports.tag.SingleParamParser;
import org.bbreak.excella.reports.util.ReportsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockColRepeatParamParser
extends ReportsTagParser<Object[]> {
    private static Log log = LogFactory.getLog(BlockColRepeatParamParser.class);
    public static final String DEFAULT_TAG = "$BC[]";
    public static final String PARAM_VALUE = "";
    public static final String PARAM_FROM = "fromCell";
    public static final String PARAM_TO = "toCell";
    public static final String PARAM_REPEAT = "repeatNum";
    public static final String PARAM_TURN = "turnNum";
    protected static final String PARAM_DUPLICATE = "hideDuplicate";
    public static final String PARAM_REMOVE_TAG = "removeTag";

    public BlockColRepeatParamParser() {
        super(DEFAULT_TAG);
    }

    public BlockColRepeatParamParser(String tag) {
        super(tag);
    }

    @Override
    public boolean useControlRow() {
        return true;
    }

    @Override
    public ParsedReportInfo parse(Sheet sheet, Cell tagCell, Object data) throws ParseException {
        try {
            Object[] paramInfos;
            Map paramDef = TagUtil.getParams((String)tagCell.getStringCellValue());
            this.checkParam(paramDef, tagCell);
            ReportsParserInfo info = (ReportsParserInfo)data;
            ParamInfo paramInfo = info.getParamInfo();
            ParsedReportInfo parsedReportInfo = new ParsedReportInfo();
            ArrayList<Object> resultList = new ArrayList<Object>();
            String bcTagname = (String)paramDef.get(PARAM_VALUE);
            if (log.isDebugEnabled()) {
                log.debug((Object)("BC\u30d1\u30e9\u30e1\u30fc\u30bf\u540d : " + bcTagname));
            }
            if ((paramInfos = (Object[])this.getParamData(paramInfo, bcTagname)) == null) {
                return parsedReportInfo;
            }
            List<SingleParamParser> singleParsers = this.getSingleReplaceParsers(info);
            ArrayList<ParamInfo> paramInfoList = new ArrayList<ParamInfo>();
            for (Object obj : paramInfos) {
                if (obj instanceof ParamInfo) {
                    paramInfoList.add((ParamInfo)obj);
                    continue;
                }
                ParamInfo childParamInfo = new ParamInfo();
                Map map = PropertyUtils.describe((Object)obj);
                for (Map.Entry entry : map.entrySet()) {
                    for (SingleParamParser parser : singleParsers) {
                        childParamInfo.addParam(parser.getTag(), (String)entry.getKey(), entry.getValue());
                    }
                }
                paramInfoList.add(childParamInfo);
            }
            paramInfos = paramInfoList.toArray(new ParamInfo[paramInfoList.size()]);
            Integer repeatNum = paramInfos.length;
            if (paramDef.containsKey(PARAM_REPEAT) && Integer.valueOf((String)paramDef.get(PARAM_REPEAT)) < repeatNum) {
                repeatNum = Integer.valueOf((String)paramDef.get(PARAM_REPEAT));
            }
            HashMap<String, Object> beforeBlockSingleDataMap = new HashMap<String, Object>();
            if (paramDef.containsKey(PARAM_DUPLICATE)) {
                String[] tmp;
                for (String str : tmp = ((String)paramDef.get(PARAM_DUPLICATE)).split(";")) {
                    for (SingleParamParser parser : singleParsers) {
                        str = parser.getTag() + "{" + str + "}";
                        beforeBlockSingleDataMap.put(str, PARAM_VALUE);
                    }
                }
            }
            boolean removeTag = false;
            if (paramDef.containsKey(PARAM_REMOVE_TAG)) {
                removeTag = Boolean.valueOf((String)paramDef.get(PARAM_REMOVE_TAG));
            }
            int[] fromCellPosition = ReportsUtil.getCellIndex((String)paramDef.get(PARAM_FROM), PARAM_FROM);
            int defaultFromCellRowIndex = tagCell.getRow().getRowNum() + fromCellPosition[0];
            int defaultFromCellColIndex = tagCell.getColumnIndex() + fromCellPosition[1];
            int[] toCellIndex = ReportsUtil.getCellIndex((String)paramDef.get(PARAM_TO), PARAM_TO);
            int defaultToCellRowIndex = tagCell.getRow().getRowNum() + toCellIndex[0];
            int defaultToCellColIndex = tagCell.getColumnIndex() + toCellIndex[1];
            int blockEndRowIndex = defaultToCellRowIndex;
            int blockEndColIndex = defaultToCellColIndex;
            int blockStartRowIndex = defaultFromCellRowIndex;
            int blockStartColIndex = defaultFromCellColIndex;
            Object[][] blockCellsValue = ReportsUtil.getBlockCellValue(sheet, defaultFromCellRowIndex, defaultToCellRowIndex, defaultFromCellColIndex, defaultToCellColIndex);
            CellStyle[][] blockCellsStyle = ReportsUtil.getBlockCellStyle(sheet, defaultFromCellRowIndex, defaultToCellRowIndex, defaultFromCellColIndex, defaultToCellColIndex);
            int[][] blockCellTypes = ReportsUtil.getBlockCellType(sheet, defaultFromCellRowIndex, defaultToCellRowIndex, defaultFromCellColIndex, defaultToCellColIndex);
            int[] columnWidths = ReportsUtil.getColumnWidth(sheet, defaultFromCellColIndex, defaultToCellColIndex);
            int rowlen = defaultToCellRowIndex - defaultFromCellRowIndex + 1;
            int collen = defaultToCellColIndex - defaultFromCellColIndex + 1;
            CellRangeAddress[] margedCells = ReportsUtil.getMargedCells(sheet, defaultFromCellRowIndex, defaultToCellRowIndex, defaultFromCellColIndex, defaultToCellColIndex);
            int turnCount = 0;
            int maxblockEndRowIndex = blockEndRowIndex;
            TagParser<?> parser = null;
            ParsedReportInfo result = null;
            int totalPlusColNum = 0;
            for (int repeatCount = 0; repeatCount < repeatNum; ++repeatCount) {
                collen = defaultToCellColIndex - defaultFromCellColIndex + 1;
                if (turnCount > 0) {
                    blockStartColIndex = blockEndColIndex + 1;
                    blockEndColIndex = blockStartColIndex + collen - 1;
                }
                ++turnCount;
                if (repeatCount > 0) {
                    CellRangeAddress rangeAddress = new CellRangeAddress(blockStartRowIndex, sheet.getLastRowNum(), blockStartColIndex, blockStartColIndex + collen - 1);
                    PoiUtil.insertRangeRight((Sheet)sheet, (CellRangeAddress)rangeAddress);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"\u30c7\u30d5\u30a9\u30eb\u30c8\u30d6\u30ed\u30c3\u30af\u633f\u5165");
                        log.debug((Object)(blockStartRowIndex + ":" + sheet.getLastRowNum() + ":" + blockStartColIndex + ":" + (blockStartColIndex + collen - 1)));
                    }
                    int targetColNum = blockEndColIndex - defaultToCellColIndex;
                    for (CellRangeAddress address : margedCells) {
                        int firstRowNum = address.getFirstRow();
                        int lastRowNum = address.getLastRow();
                        int firstColumnNum = address.getFirstColumn() + targetColNum;
                        int lastColumnNum = address.getLastColumn() + targetColNum;
                        CellRangeAddress copyAddress = new CellRangeAddress(firstRowNum, lastRowNum, firstColumnNum, lastColumnNum);
                        sheet.addMergedRegion(copyAddress);
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("\u25cf\u25cf\u25cf\u30d6\u30ed\u30c3\u30af\u60c5\u5831\u3092\u30b3\u30d4\u30fc\u25cf\u25cf\u25cf \u30c7\u30fc\u30bf\u30eb\u30fc\u30d7=" + repeatCount));
                }
                for (int rowIdx = 0; rowIdx < blockCellsValue.length; ++rowIdx) {
                    int copyToRowIndex = blockStartRowIndex + rowIdx;
                    Row row = sheet.getRow(copyToRowIndex);
                    if (row == null && !ReportsUtil.isEmptyRow(blockCellTypes[rowIdx], blockCellsValue[rowIdx], blockCellsStyle[rowIdx])) {
                        row = sheet.createRow(copyToRowIndex);
                    }
                    if (row == null) continue;
                    for (int colIdx = 0; colIdx < blockCellsValue[rowIdx].length; ++colIdx) {
                        int copyToColIndex = blockStartColIndex + colIdx;
                        sheet.setColumnWidth(copyToColIndex, columnWidths[colIdx]);
                        Cell cell = row.getCell(copyToColIndex);
                        int cellType = blockCellTypes[rowIdx][colIdx];
                        Object cellValue = blockCellsValue[rowIdx][colIdx];
                        CellStyle cellStyle = blockCellsStyle[rowIdx][colIdx];
                        if (cell == null && !ReportsUtil.isEmptyCell(cellType, cellValue, cellStyle)) {
                            cell = row.createCell(copyToColIndex);
                        }
                        if (cell == null) continue;
                        cell.setCellType(cellType);
                        PoiUtil.setCellValue((Cell)cell, (Object)cellValue);
                        if (cellStyle != null) {
                            cell.setCellStyle(cellStyle);
                        }
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("row=" + copyToRowIndex + " col" + copyToColIndex + ">>>>>>" + blockCellsValue[rowIdx][colIdx]));
                    }
                }
                int plusRowNum = 0;
                int plusColNum = 0;
                collen = defaultToCellColIndex - defaultFromCellColIndex + 1;
                for (int targetRow = blockStartRowIndex; targetRow < blockStartRowIndex + rowlen + plusRowNum; ++targetRow) {
                    if (sheet.getRow(targetRow) == null) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("row=" + targetRow + " : row is not available. continued..."));
                        continue;
                    }
                    Cell chgTargetCell = null;
                    for (int targetCol = blockStartColIndex; targetCol <= blockStartColIndex + collen + plusColNum - 1; ++targetCol) {
                        chgTargetCell = sheet.getRow(targetRow).getCell(targetCol);
                        if (chgTargetCell == null) {
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("row=" + targetRow + " col=" + targetCol + " : cell is not available. continued..."));
                            continue;
                        }
                        parser = info.getMatchTagParser(sheet, chgTargetCell);
                        if (parser == null) {
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("row=" + targetRow + " col=" + targetCol + " parser is not available. continued..."));
                            continue;
                        }
                        String chgTargetCellString = chgTargetCell.getStringCellValue();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("########## \u30bf\u30b0\u30bb\u30eb\u5ea7\u6a19 row=" + targetRow + " col=" + targetCol + " \u30bf\u30b0\u6587\u5b57=" + chgTargetCellString + " ##########"));
                        }
                        result = (ParsedReportInfo)parser.parse(sheet, chgTargetCell, (Object)info.createChildParserInfo((ParamInfo)paramInfos[repeatCount]));
                        plusRowNum += result.getRowIndex() - result.getDefaultRowIndex();
                        plusColNum += result.getColumnIndex() - result.getDefaultColumnIndex();
                        if (parser instanceof SingleParamParser && beforeBlockSingleDataMap.containsKey(chgTargetCellString)) {
                            if (beforeBlockSingleDataMap.get(chgTargetCellString).equals(result.getParsedObject())) {
                                PoiUtil.setCellValue((Cell)chgTargetCell, (Object)PARAM_VALUE);
                            } else {
                                beforeBlockSingleDataMap.put(chgTargetCellString, result.getParsedObject());
                            }
                        }
                        if (blockStartColIndex != result.getDefaultColumnIndex() && maxblockEndRowIndex <= blockEndRowIndex && result.getRowIndex() > result.getDefaultRowIndex()) {
                            CellRangeAddress preRangeAddress = new CellRangeAddress(blockEndRowIndex + 1, blockEndRowIndex + (result.getRowIndex() - result.getDefaultRowIndex()), blockStartColIndex, targetCol - 1);
                            PoiUtil.insertRangeDown((Sheet)sheet, (CellRangeAddress)preRangeAddress);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"***\u7e26\u88dc\u6b63***");
                                log.debug((Object)("\u633f\u5165\u7bc4\u56f21 : " + (blockEndRowIndex + 1) + ":" + (blockEndRowIndex + (result.getRowIndex() - result.getDefaultRowIndex())) + ":" + blockStartColIndex + ":" + (targetCol - 1)));
                            }
                        }
                        if (parser instanceof RowRepeatParamParser && maxblockEndRowIndex <= blockEndRowIndex && result.getRowIndex() > result.getDefaultRowIndex()) {
                            CellRangeAddress rearRangeAddress = new CellRangeAddress(blockEndRowIndex + 1, blockEndRowIndex + (result.getRowIndex() - result.getDefaultRowIndex()), result.getDefaultColumnIndex() + 1, blockEndColIndex);
                            PoiUtil.insertRangeDown((Sheet)sheet, (CellRangeAddress)rearRangeAddress);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"***\u7e26\u88dc\u6b63***");
                                log.debug((Object)("\u633f\u5165\u7bc4\u56f22 : " + (blockEndRowIndex + 1) + ":" + (blockEndRowIndex + (result.getRowIndex() - result.getDefaultRowIndex())) + ":" + (result.getDefaultColumnIndex() + 1) + ":" + blockEndColIndex));
                            }
                        }
                        blockEndRowIndex = defaultToCellRowIndex + plusRowNum;
                        resultList.add(result.getParsedObject());
                        if (parser instanceof BlockColRepeatParamParser || parser instanceof BlockRowRepeatParamParser) {
                            collen += result.getColumnIndex() - result.getDefaultColumnIndex();
                            plusColNum -= result.getColumnIndex() - result.getDefaultColumnIndex();
                        }
                        if (blockStartColIndex + collen + plusColNum - 1 <= blockEndColIndex) continue;
                        int beforeLastColIndex = blockEndColIndex;
                        blockEndColIndex = blockStartColIndex + collen + plusColNum - 1;
                        CellRangeAddress preRangeAddress = new CellRangeAddress(tagCell.getRowIndex(), targetRow - 1, beforeLastColIndex + 1, blockEndColIndex);
                        PoiUtil.insertRangeRight((Sheet)sheet, (CellRangeAddress)preRangeAddress);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"***\u6a2a\u88dc\u6b63***");
                            log.debug((Object)("\u633f\u5165\u7bc4\u56f21 : " + tagCell.getRowIndex() + ":" + (targetRow - 1) + ":" + (beforeLastColIndex + 1) + ":" + blockEndColIndex));
                        }
                        CellRangeAddress rangeAddress = new CellRangeAddress(blockEndRowIndex + 1, sheet.getLastRowNum(), beforeLastColIndex + 1, blockEndColIndex);
                        PoiUtil.insertRangeRight((Sheet)sheet, (CellRangeAddress)rangeAddress);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)"***\u6a2a\u88dc\u6b63***");
                        log.debug((Object)("\u633f\u5165\u7bc4\u56f23 : " + (blockEndRowIndex + 1) + ":" + sheet.getLastRowNum() + ":" + (beforeLastColIndex + 1) + ":" + blockEndColIndex));
                    }
                    if (blockStartColIndex + collen + plusColNum - 1 < blockEndColIndex) {
                        CellRangeAddress rearRangeAddress = new CellRangeAddress(targetRow, targetRow, blockStartColIndex + collen + plusColNum, blockEndColIndex);
                        PoiUtil.insertRangeRight((Sheet)sheet, (CellRangeAddress)rearRangeAddress);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"***\u6a2a\u88dc\u6b63***");
                            log.debug((Object)("\u633f\u5165\u7bc4\u56f22 : " + targetRow + ":" + targetRow + ":" + (blockStartColIndex + collen + plusColNum) + ":" + blockEndColIndex));
                        }
                    }
                    totalPlusColNum += plusColNum;
                    plusColNum = 0;
                }
                if (maxblockEndRowIndex >= blockEndRowIndex) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"***\u7e26\u88dc\u6b63***");
                }
                if (repeatCount != 0) {
                    CellRangeAddress preRangeAddress = new CellRangeAddress(maxblockEndRowIndex + 1, blockEndRowIndex, defaultFromCellColIndex, blockStartColIndex - 1);
                    PoiUtil.insertRangeDown((Sheet)sheet, (CellRangeAddress)preRangeAddress);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("\u633f\u5165\u7bc4\u56f21 : " + (maxblockEndRowIndex + 1) + ":" + blockEndRowIndex + ":" + defaultFromCellColIndex + ":" + (blockStartColIndex - 1)));
                    }
                }
                CellRangeAddress rearRangeAddress = new CellRangeAddress(maxblockEndRowIndex + 1, blockEndRowIndex, blockEndColIndex + 1, PoiUtil.getLastColNum((Sheet)sheet));
                PoiUtil.insertRangeDown((Sheet)sheet, (CellRangeAddress)rearRangeAddress);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("\u633f\u5165\u7bc4\u56f22 : " + (maxblockEndRowIndex + 1) + ":" + blockEndRowIndex + ":" + (blockEndColIndex + 1) + ":" + PoiUtil.getLastColNum((Sheet)sheet)));
                }
                maxblockEndRowIndex = blockEndRowIndex;
            }
            if (removeTag) {
                tagCell.setCellType(3);
            }
            parsedReportInfo.setDefaultRowIndex(defaultToCellRowIndex);
            parsedReportInfo.setDefaultColumnIndex(defaultToCellColIndex);
            parsedReportInfo.setColumnIndex(blockEndColIndex);
            parsedReportInfo.setParsedObject(resultList);
            parsedReportInfo.setRowIndex(maxblockEndRowIndex);
            if (log.isDebugEnabled()) {
                log.debug((Object)("finalBlockRowIndex= " + maxblockEndRowIndex));
                log.debug((Object)("finalBlockColIndex=" + blockEndColIndex));
            }
            return parsedReportInfo;
        }
        catch (Exception e) {
            throw new ParseException(tagCell, (Throwable)e);
        }
    }

    private List<SingleParamParser> getSingleReplaceParsers(ReportsParserInfo reportsParserInfo) {
        List<ReportsTagParser<?>> parsers = reportsParserInfo.getReportParsers();
        ArrayList<SingleParamParser> singleParsers = new ArrayList<SingleParamParser>();
        for (ReportsTagParser<?> reportsParser : parsers) {
            if (!(reportsParser instanceof SingleParamParser)) continue;
            singleParsers.add((SingleParamParser)reportsParser);
        }
        return singleParsers;
    }

    private void checkParam(Map<String, String> paramDef, Cell tagCell) throws ParseException {
        if (!paramDef.containsKey(PARAM_FROM)) {
            throw new ParseException(tagCell + "\u5fc5\u9808\u30d1\u30e9\u30e1\u30fc\u30bf\u306a\u3057\uff1a" + PARAM_FROM);
        }
        if (!paramDef.containsKey(PARAM_TO)) {
            throw new ParseException(tagCell + "\u5fc5\u9808\u30d1\u30e9\u30e1\u30fc\u30bf\u306a\u3057\uff1a" + PARAM_TO);
        }
        if (paramDef.get(PARAM_FROM).split(":").length != 2) {
            throw new ParseException(tagCell + "\u30d1\u30e9\u30e1\u30fc\u30bf\u5024\u4e0d\u6b63\uff1a" + PARAM_FROM);
        }
        if (paramDef.get(PARAM_TO).split(":").length != 2) {
            throw new ParseException(tagCell + "\u30d1\u30e9\u30e1\u30fc\u30bf\u5024\u4e0d\u6b63\uff1a" + PARAM_TO);
        }
        int[] fromCellIndex = ReportsUtil.getCellIndex(paramDef.get(PARAM_FROM), PARAM_FROM);
        int[] toCellIndex = ReportsUtil.getCellIndex(paramDef.get(PARAM_TO), PARAM_TO);
        if (fromCellIndex[0] < 0 || fromCellIndex[1] < 0) {
            throw new ParseException(tagCell + "\u30d1\u30e9\u30e1\u30fc\u30bf\u4e0d\u6b63\uff1a" + PARAM_FROM);
        }
        if (toCellIndex[0] < 0 || toCellIndex[1] < 0) {
            throw new ParseException(tagCell + "\u30d1\u30e9\u30e1\u30fc\u30bf\u4e0d\u6b63\uff1a" + PARAM_TO);
        }
        if (fromCellIndex[0] > toCellIndex[0]) {
            throw new ParseException(tagCell + "\u30d1\u30e9\u30e1\u30fc\u30bf\u4e0d\u6b63\uff08\u884c\uff09\uff1a" + PARAM_FROM + "," + PARAM_TO);
        }
        if (fromCellIndex[1] > toCellIndex[1]) {
            throw new ParseException(tagCell + "\u30d1\u30e9\u30e1\u30fc\u30bf\u4e0d\u6b63\uff08\u5217\uff09\uff1a" + PARAM_FROM + "," + PARAM_TO);
        }
        try {
            if (paramDef.containsKey(PARAM_REPEAT) && Integer.valueOf(paramDef.get(PARAM_REPEAT)) < 0) {
                throw new ParseException(tagCell, "\u30d1\u30e9\u30e1\u30fc\u30bf\u5024\u4e0d\u6b63\uff1arepeatNum");
            }
        }
        catch (NumberFormatException e) {
            throw new ParseException(tagCell + "\u30d1\u30e9\u30e1\u30fc\u30bf\u4e0d\u6b63\uff1a" + PARAM_REPEAT);
        }
    }
}

