/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Reports - Excelt@C𗘗p[c[
 *
 * $Id: ReportBook.java 136 2010-07-29 04:29:25Z akira-yokoi $
 * $Revision: 136 $
 *
 * This file is part of ExCella Reports.
 *
 * ExCella Reports is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Reports is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Reports .  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.reports.model;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

/**
 * [NubN̒uێNX
 * 
 * @since 1.0
 */
@SuppressWarnings("serial")
public class ReportBook implements Serializable{

    /**
     * [NV[guQ
     */
    private List<ReportSheet> reportSheets = new ArrayList<ReportSheet>();

    /**
     * ev[gt@CURL
     */
    private URL templateFileURL = null;
    
    /**
     * ev[gt@C
     */
    private String templateFileName = null;

    /**
     * o̓pX{t@CigqȂj
     */
    private String outputFileName = null;

    /**
     * o͕ϊ
     */
    private ConvertConfiguration[] configurations = null;

    
    /**
     * ftHgRXgN^
     */
    public ReportBook(){
    }
    
    /**
     * @param templateFileName ev[gt@C(tpX)
     * @param outputFileName o̓pX{t@CigqȂj
     * @param configurations ϊ
     */
    public ReportBook( String templateFileName, String outputFileName, ConvertConfiguration... configurations){
        this.templateFileName = templateFileName;
        this.outputFileName = outputFileName;
        this.configurations = configurations;
    }

    /**
     * @param templateFileName ev[gt@C(tpX)
     * @param outputFileName o̓pX{t@CigqȂj
     * @param formatTypes ϊ^Cv
     */
    public ReportBook( String templateFileName, String outputFileName, String... formatTypes){
        this.templateFileName = templateFileName;
        this.outputFileName = outputFileName;

        configurations = new ConvertConfiguration[formatTypes.length];
        for ( int i = 0; i < formatTypes.length; i++) {
            configurations[i] = new ConvertConfiguration( formatTypes[i]);
        }
    }
    
    /**
     * jarɊ܂܂ev[gw肵ꍇ͂gp
     * 
     * @param templateFileURL ev[gt@C
     * @param outputFileName o̓pX{t@CigqȂj
     * @param configurations ϊ
     */
    public ReportBook( URL templateFileURL, String outputFileName, ConvertConfiguration... configurations){
        this.templateFileURL = templateFileURL;
        this.outputFileName = outputFileName;
        this.configurations = configurations;
    }
    
    /**
     * jarɊ܂܂ev[gw肵ꍇ͂gp
     *      
     * @param templateFileURL ev[gt@C
     * @param outputFileName o̓pX{t@CigqȂj
     * @param formatTypes ϊ^Cv
     */
    public ReportBook( URL templateFileURL, String outputFileName, String... formatTypes){
        this.templateFileURL = templateFileURL;
        this.outputFileName = outputFileName;

        configurations = new ConvertConfiguration[formatTypes.length];
        for ( int i = 0; i < formatTypes.length; i++) {
            configurations[i] = new ConvertConfiguration( formatTypes[i]);
        }
    }

    /**
     * [NV[guQݒ肵܂B
     * 
     * @param reportSheets [NV[guQ
     */
    public void setReportSheets( List<ReportSheet> reportSheets) {
        this.reportSheets = reportSheets;
    }

    /**
     * [NV[guQ擾܂B
     * 
     * @return [NV[guQ
     */
    public List<ReportSheet> getReportSheets() {
        return reportSheets;
    }

    /**
     * [NV[guǉB
     * 
     * @param reportSheet [NV[gu
     */
    public void addReportSheet( ReportSheet reportSheet) {
        reportSheets.add( reportSheet);
    }

    /**
     * [NV[guQǉB
     * 
     * @param reportSheets [NV[guQ
     */
    public void addReportSheets( List<ReportSheet> reportSheets) {
        this.reportSheets.addAll( reportSheets);
    }

    /**
     * [NV[gu폜B
     * 
     * @param reportSheet [NV[gu
     */
    public void removeReportSheet( ReportSheet reportSheet) {
        reportSheets.remove( reportSheet);
    }

    /**
     * [NV[guQ폜B
     */
    public void clearReportSheets() {
        reportSheets.clear();
    }

    /**
     * o̓pX{t@CigqȂj擾܂B
     * 
     * @return o̓pX{t@CigqȂj
     */
    public String getOutputFileName() {
        return outputFileName;
    }

    /**
     * o̓pX{t@CigqȂjݒ肵܂B
     * 
     * @param outputFileName o̓pX{t@CigqȂj
     */
    public void setOutputFileName( String outputFileName) {
        this.outputFileName = outputFileName;
    }

    /**
     * o͕ϊ擾܂B
     * 
     * @return o͕ϊ
     */
    public ConvertConfiguration[] getConfigurations() {
        return configurations;
    }

    /**
     * o͕ϊݒ肵܂B
     * 
     * @param configurations o͕ϊ
     */
    public void setConfigurations( ConvertConfiguration... configurations) {
        this.configurations = configurations;
    }

    /**
     * ev[gt@C擾܂B
     * 
     * @return ev[gt@C
     */
    public String getTemplateFileName() {
        return templateFileName;
    }

    /**
     * ev[gt@Cݒ肵܂B
     * 
     * @param templateFileName ev[gt@C
     */
    public void setTemplateFileName( String templateFileName) {
        this.templateFileName = templateFileName;
    }
    
    /**
     * ev[gt@CURL擾܂B
     * 
     * @return ev[gt@CURL
     */
    public URL getTemplateFileURL() {
        return templateFileURL;
    }

    /**
     * ev[gt@CURLݒ肵܂B
     * 
     * @param templateFileName ev[gt@C
     */
    public void setTemplateFileURL( URL templateFileURL) {
        this.templateFileURL = templateFileURL;
    }

}
