/*
 * Decompiled with CFR 0.152.
 */
package org.artofsolving.jodconverter.office;

import com.sun.star.beans.PropertyValue;
import com.sun.star.uno.UnoRuntime;
import java.io.File;
import java.util.Map;
import org.artofsolving.jodconverter.util.PlatformUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OfficeUtils {
    public static final String SERVICE_DESKTOP = "com.sun.star.frame.Desktop";

    private OfficeUtils() {
        throw new AssertionError((Object)"utility class must not be instantiated");
    }

    public static <T> T cast(Class<T> type, Object object) {
        return (T)UnoRuntime.queryInterface(type, (Object)object);
    }

    public static PropertyValue property(String name, Object value) {
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.Name = name;
        propertyValue.Value = value;
        return propertyValue;
    }

    public static PropertyValue[] toUnoProperties(Map<String, ?> properties) {
        PropertyValue[] propertyValues = new PropertyValue[properties.size()];
        int i = 0;
        for (Map.Entry<String, ?> entry : properties.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Map) {
                Map subProperties = (Map)value;
                value = OfficeUtils.toUnoProperties(subProperties);
            }
            propertyValues[i++] = OfficeUtils.property(entry.getKey(), value);
        }
        return propertyValues;
    }

    public static String toUrl(File file) {
        String url = "file://" + file.toURI().getRawPath();
        if (url.endsWith("/")) {
            return url.substring(0, url.length() - 1);
        }
        return url;
    }

    public static File getDefaultOfficeHome() {
        if (System.getProperty("office.home") != null) {
            return new File(System.getProperty("office.home"));
        }
        if (PlatformUtils.isWindows()) {
            return new File(System.getenv("ProgramFiles"), "OpenOffice.org 3");
        }
        if (PlatformUtils.isMac()) {
            return new File("/Applications/OpenOffice.org.app/Contents");
        }
        return new File("/opt/openoffice.org3");
    }

    public static File getDefaultProfileDir() {
        if (System.getProperty("office.profile") != null) {
            return new File(System.getProperty("office.profile"));
        }
        if (PlatformUtils.isWindows()) {
            return new File(System.getenv("APPDATA"), "OpenOffice.org/3");
        }
        if (PlatformUtils.isMac()) {
            return new File(System.getProperty("user.home"), "Library/Application Support/OpenOffice.org/3");
        }
        return new File(System.getProperty("user.home"), ".openoffice.org/3");
    }

    public static File getOfficeExecutable(File officeHome) {
        if (PlatformUtils.isMac()) {
            return new File(officeHome, "MacOS/soffice.bin");
        }
        return new File(officeHome, "program/soffice.bin");
    }
}

