/*
 * Decompiled with CFR 0.152.
 */
package org.artofsolving.jodconverter.process;

import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.artofsolving.jodconverter.process.ProcessManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnixProcessManager
implements ProcessManager {
    private static final Pattern PS_OUTPUT_LINE = Pattern.compile("^\\s*(\\d+)\\s+(.*)$");

    protected String[] psCommand() {
        return new String[]{"/bin/ps", "-e", "-o", "pid,args"};
    }

    @Override
    public String findPid(String regex) throws IOException {
        Pattern commandPattern = Pattern.compile(regex);
        for (String line : this.execute(this.psCommand())) {
            String command;
            Matcher commandMatcher;
            Matcher lineMatcher = PS_OUTPUT_LINE.matcher(line);
            if (!lineMatcher.matches() || !(commandMatcher = commandPattern.matcher(command = lineMatcher.group(2))).find()) continue;
            return lineMatcher.group(1);
        }
        return null;
    }

    @Override
    public void kill(Process process, String pid) throws IOException {
        this.execute("/bin/kill", "-KILL", pid);
    }

    private List<String> execute(String ... command) throws IOException {
        Process process = new ProcessBuilder(command).start();
        List lines = IOUtils.readLines(process.getInputStream());
        return lines;
    }
}

