/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import java.net.URI;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTHyperlink;

public class XSSFHyperlink
implements Hyperlink {
    private int type;
    private PackageRelationship externalRel;
    private CTHyperlink ctHyperlink;
    private String location;

    protected XSSFHyperlink(int type) {
        this.type = type;
        this.ctHyperlink = CTHyperlink.Factory.newInstance();
    }

    protected XSSFHyperlink(CTHyperlink ctHyperlink, PackageRelationship hyperlinkRel) {
        this.ctHyperlink = ctHyperlink;
        this.externalRel = hyperlinkRel;
        if (ctHyperlink.getLocation() != null) {
            this.type = 2;
            this.location = ctHyperlink.getLocation();
        } else {
            if (this.externalRel == null) {
                if (ctHyperlink.getId() != null) {
                    throw new IllegalStateException("The hyperlink for cell " + ctHyperlink.getRef() + " references relation " + ctHyperlink.getId() + ", but that didn't exist!");
                }
                throw new IllegalStateException("A sheet hyperlink must either have a location, or a relationship. Found:\n" + ctHyperlink);
            }
            URI target = this.externalRel.getTargetURI();
            this.location = target.toString();
            this.type = this.location.startsWith("http://") || this.location.startsWith("https://") || this.location.startsWith("ftp://") ? 1 : (this.location.startsWith("mailto:") ? 3 : 4);
        }
    }

    protected CTHyperlink getCTHyperlink() {
        return this.ctHyperlink;
    }

    public boolean needsRelationToo() {
        return this.type != 2;
    }

    protected void generateRelationIfNeeded(PackagePart sheetPart) {
        if (this.needsRelationToo()) {
            PackageRelationship rel = sheetPart.addExternalRelationship(this.location, XSSFRelation.SHEET_HYPERLINKS.getRelation());
            this.ctHyperlink.setId(rel.getId());
        }
    }

    public int getType() {
        return this.type;
    }

    public String getCellRef() {
        return this.ctHyperlink.getRef();
    }

    public String getAddress() {
        return this.location;
    }

    public String getLabel() {
        return this.ctHyperlink.getDisplay();
    }

    public String getLocation() {
        return this.ctHyperlink.getLocation();
    }

    public void setLabel(String label) {
        this.ctHyperlink.setDisplay(label);
    }

    public void setLocation(String location) {
        this.ctHyperlink.setLocation(location);
    }

    public void setAddress(String address) {
        this.location = address;
        if (this.type == 2) {
            this.setLocation(address);
        }
    }

    protected void setCellReference(String ref) {
        this.ctHyperlink.setRef(ref);
    }

    private CellReference buildCellReference() {
        return new CellReference(this.ctHyperlink.getRef());
    }

    public int getFirstColumn() {
        return this.buildCellReference().getCol();
    }

    public int getLastColumn() {
        return this.buildCellReference().getCol();
    }

    public int getFirstRow() {
        return this.buildCellReference().getRow();
    }

    public int getLastRow() {
        return this.buildCellReference().getRow();
    }

    public void setFirstColumn(int col) {
        this.ctHyperlink.setRef(new CellReference(this.getFirstRow(), col).formatAsString());
    }

    public void setLastColumn(int col) {
        this.setFirstColumn(col);
    }

    public void setFirstRow(int row) {
        this.ctHyperlink.setRef(new CellReference(row, this.getFirstColumn()).formatAsString());
    }

    public void setLastRow(int row) {
        this.setFirstRow(row);
    }
}

