/*
 * Decompiled with CFR 0.152.
 */
package org.bbreak.excella.reports.listener;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.bbreak.excella.core.SheetData;
import org.bbreak.excella.core.SheetParser;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.tag.TagParser;
import org.bbreak.excella.reports.listener.ReportProcessAdaptor;
import org.bbreak.excella.reports.tag.ReportsTagParser;

public class RemoveControlRowAdapter
extends ReportProcessAdaptor {
    public void postParse(Sheet sheet, SheetParser sheetParser, SheetData sheetData) throws ParseException {
        TreeSet removeRows = new TreeSet(Collections.reverseOrder());
        for (Row row : sheet) {
            if (row == null || !this.isControlRow(sheet, sheetParser, row)) continue;
            removeRows.add(row.getRowNum());
        }
        for (Integer rowIndex : removeRows) {
            if (rowIndex.intValue() == sheet.getLastRowNum()) {
                sheet.removeRow(sheet.getRow(rowIndex.intValue()));
                continue;
            }
            sheet.removeRow(sheet.getRow(rowIndex.intValue()));
            sheet.shiftRows(rowIndex + 1, sheet.getLastRowNum(), -1);
        }
    }

    private boolean isControlRow(Sheet sheet, SheetParser sheetParser, Row row) {
        List parsers = sheetParser.getTagParsers();
        Iterator cellIterator = row.cellIterator();
        while (cellIterator.hasNext()) {
            Cell cell = (Cell)cellIterator.next();
            for (TagParser parser : parsers) {
                try {
                    ReportsTagParser reportsTagParser;
                    if (!parser.isParse(sheet, cell) || !(parser instanceof ReportsTagParser) || !(reportsTagParser = (ReportsTagParser)parser).useControlRow()) continue;
                    return true;
                }
                catch (ParseException e) {
                }
            }
        }
        return false;
    }
}

