/*
 * Decompiled with CFR 0.152.
 */
package cloudsticky.util;

import cloudsticky.util.LocalDtdResolver;
import cloudsticky.util.ValidationErrorHandler;
import com.sun.org.apache.xerces.internal.parsers.DOMParser;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DocumentUtil {
    public static String evn2html(String content) {
        Document evnDoc = DocumentUtil.string2Document(content);
        Document htmlDoc = DocumentUtil.evnDoc2HtmlDoc(evnDoc);
        String str = DocumentUtil.document2String(htmlDoc, true);
        return str;
    }

    public static String evnDoc2HtmlStr(Document evndoc) {
        Document htmlDoc = DocumentUtil.evnDoc2HtmlDoc(evndoc);
        String str = DocumentUtil.document2String(htmlDoc, true);
        return str;
    }

    public static Document evnDoc2HtmlDoc(Document document) {
        Document doc = null;
        try {
            DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbfactory.newDocumentBuilder();
            doc = builder.newDocument();
            Element html = doc.createElement("html");
            Element body = doc.createElement("body");
            doc.appendChild(html);
            html.appendChild(body);
            NodeList list = document.getDocumentElement().getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                Node gchild = list.item(i);
                Node importNode = doc.importNode(gchild, true);
                body.appendChild(importNode);
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return doc;
    }

    public static String document2String(Document document, boolean omitDocType) {
        return DocumentUtil.element2String(document.getDocumentElement(), omitDocType);
    }

    public static String element2String(Element elem, boolean omitDocType) {
        String result = null;
        StringWriter strWtr = new StringWriter();
        StreamResult strResult = new StreamResult(strWtr);
        TransformerFactory tfac = TransformerFactory.newInstance();
        try {
            Transformer trans = tfac.newTransformer();
            trans.setOutputProperty("indent", "yes");
            if (!omitDocType) {
                trans.setOutputProperty("doctype-system", "http://xml.evernote.com/pub/enml2.dtd");
                trans.setOutputProperty("omit-xml-declaration", "no");
            }
            trans.setOutputProperty("encoding", "UTF-8");
            trans.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
            trans.transform(new DOMSource(elem), strResult);
        }
        catch (Exception exception) {
            // empty catch block
        }
        result = strResult.getWriter().toString();
        return result;
    }

    public static String evnDoc2StrWithoutTag(Document doc) {
        StringBuffer sb = new StringBuffer();
        Element root = doc.getDocumentElement();
        DocumentUtil.evnElem2StrWithoutTag(root, sb);
        return sb.toString();
    }

    public static void evnElem2StrWithoutTag(Element elem, StringBuffer sb) {
        NodeList nl = elem.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            if (n.getNodeType() == 1) {
                if (n.getNodeName().equals("div")) {
                    sb.append("\n");
                }
                if (n.getNodeName().equals("br") && !elem.getNodeName().equals("div")) {
                    sb.append("\n");
                }
                DocumentUtil.evnElem2StrWithoutTag((Element)n, sb);
            } else if (n.getNodeType() == 3 && !n.getNodeValue().equals("\n")) {
                sb.append(n.getNodeValue().replaceAll("\n", ""));
            }
            ++i;
        }
    }

    public static Document string2Document(String str) {
        Document doc = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setExpandEntityReferences(false);
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            StringReader strReader = new StringReader(str);
            doc = builder.parse(new InputSource(strReader));
            builder = factory.newDocumentBuilder();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return doc;
    }

    public static Document text2EvnDocument(String text) {
        Document doc = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMImplementation domImpl = builder.getDOMImplementation();
            DocumentType docType = domImpl.createDocumentType("en-note", "", "http://xml.evernote.com/pub/enml2.dtd");
            doc = domImpl.createDocument("", "en-note", docType);
            Element root = doc.getDocumentElement();
            String[] lineArray = text.split("\n");
            int i = 0;
            while (i < lineArray.length) {
                String line = lineArray[i];
                root.appendChild(doc.createTextNode(line));
                if (i != lineArray.length - 1) {
                    Element brElem = doc.createElement("br");
                    root.appendChild(brElem);
                    root.appendChild(doc.createTextNode("\n"));
                }
                ++i;
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        return doc;
    }

    public static String replaceSpaceTag(String str) {
        return str.replaceAll("&nbsp;", " ");
    }

    public static boolean checkDomValidation(String str, ValidationErrorHandler veh) {
        try {
            DOMParser parser = new DOMParser();
            parser.setErrorHandler(veh);
            parser.setFeature("http://xml.org/sax/features/validation", true);
            byte[] aByteArr = str.getBytes();
            ByteArrayInputStream bais = new ByteArrayInputStream(aByteArr, 0, aByteArr.length);
            InputSource inputSource = new InputSource();
            inputSource.setByteStream(bais);
            parser.setEntityResolver(new LocalDtdResolver("enml2.dtd"));
            parser.parse(inputSource);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return veh.isValid;
    }

    public static String appendEvnHeader(String str, boolean local) {
        String header1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        String header2 = "";
        header2 = local ? "<!DOCTYPE en-note PUBLIC \"-//EVERNOTE//DTD EVERNOTE//EN\" \"" + new File("enml2.dtd").toURI() + "\">\n" : "<!DOCTYPE en-note SYSTEM \"http://xml.evernote.com/pub/enml2.dtd\">\n";
        return String.valueOf(header1) + header2 + str;
    }

    public static String appendXmlHeader(String str) {
        String header1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        return String.valueOf(header1) + str;
    }

    public static String removeEvnHeader(String str) {
        if (str.startsWith("<?xml ")) {
            str = str.substring(str.indexOf("\n") + 1);
        }
        if (str.startsWith("<!DOCTYPE ")) {
            str = str.substring(str.indexOf("\n") + 1);
        }
        str = str.replaceAll("<?xml version=\"1.0\" encoding=\"UTF-8\"?>", "");
        str = str.replaceAll("<!DOCTYPE en-note SYSTEM \"http://xml.evernote.com/pub/enml.dtd\">", "");
        str = str.replaceAll("<!DOCTYPE en-note SYSTEM \"http://xml.evernote.com/pub/enml2.dtd\">", "");
        return str;
    }

    public static String substitute(String input, String pattern, String replacement) {
        int index = input.indexOf(pattern);
        if (index == -1) {
            return input;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.valueOf(input.substring(0, index)) + replacement);
        if (index + pattern.length() < input.length()) {
            String rest = input.substring(index + pattern.length(), input.length());
            buffer.append(DocumentUtil.substitute(rest, pattern, replacement));
        }
        return buffer.toString();
    }

    public static String htmlEscape(String input) {
        input = DocumentUtil.substitute(input, "&", "&amp;");
        input = DocumentUtil.substitute(input, "<", "&lt;");
        input = DocumentUtil.substitute(input, ">", "&gt;");
        input = DocumentUtil.substitute(input, "\"", "&quot;");
        return input;
    }
}

