/*
 * Decompiled with CFR 0.152.
 */
package cloudsticky.gui;

import cloudsticky.CloudSticky;
import cloudsticky.gui.CloseIcon;
import cloudsticky.gui.DragWindowListener;
import cloudsticky.util.EncodedProperties;
import com.sun.awt.AWTUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class StickyPanelTemplate
extends JPanel
implements MouseListener {
    private static final long serialVersionUID = -4033571931350469305L;
    public JDialog dialog;
    public JLabel titleLabel;
    public Color frameColor;
    public Color bodyColor;
    public Color tagColor;
    public Color borderColor = new Color(100, 100, 100);
    public Color titleFontColor;
    public Color tagFontColor;
    public Color bodyFontColor;
    public int titleFontSize;
    public int tagFontSize;
    public int bodyFontSize;
    public Font titleFont;
    public Font tagFont;
    public Font bodyFont;
    public float opacity;
    String TAG;
    public String title;
    public JDialog parent;
    public static final int resize_bar_width = 3;
    public JLabel left;
    public JLabel right;
    public JLabel top;
    public JLabel bottom;
    public JLabel topleft;
    public JLabel topright;
    public JLabel bottomleft;
    public JLabel bottomright;
    public JPanel southPanel;
    public JPanel northPanel;
    public JPanel resizePanel = new JPanel(new BorderLayout()){
        private static final long serialVersionUID = 7640578183448472309L;

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g.create();
            int w = this.getWidth();
            int h = this.getHeight();
            g2.setPaint(StickyPanelTemplate.this.frameColor);
            g2.fillRect(0, 0, w, h);
            g2.dispose();
        }
    };
    public JPanel contentPanel = new JPanel(new BorderLayout());
    JButton closeButton = new JButton(new CloseIcon());
    JPanel titlePanel = new JPanel(new BorderLayout());

    public StickyPanelTemplate(String title, JDialog parent) {
        super(new BorderLayout());
        this.title = title;
        this.parent = parent;
        this.initProperties();
        this.titleLabel = new JLabel(title);
        this.titleLabel.setFont(this.titleFont);
        this.titleLabel.setOpaque(true);
        this.titleLabel.setBackground(this.frameColor);
        this.titleLabel.setForeground(this.titleFontColor);
        this.titlePanel.addMouseListener(this);
    }

    public void initProperties() {
        try {
            FileInputStream in = new FileInputStream(new File(CloudSticky.iniFile));
            Properties prop = new Properties();
            prop.load(in);
            this.frameColor = StickyPanelTemplate.getColor(prop.getProperty("FRAME_COLOR", "#FFD700"));
            this.bodyColor = StickyPanelTemplate.getColor(prop.getProperty("BODY_COLOR", "#FFFFE0"));
            this.tagColor = StickyPanelTemplate.getColor(prop.getProperty("TAG_COLOR", "#FFF0E0"));
            this.titleFontColor = StickyPanelTemplate.getColor(prop.getProperty("TITLE_FONT_COLOR", "#040404"));
            this.tagFontColor = StickyPanelTemplate.getColor(prop.getProperty("TAG_FONT_COLOR", "#040404"));
            this.bodyFontColor = StickyPanelTemplate.getColor(prop.getProperty("BODY_FONT_COLOR", "#040404"));
            this.titleFontSize = Integer.parseInt(prop.getProperty("TITLE_FONT_SIZE", "12"));
            this.tagFontSize = Integer.parseInt(prop.getProperty("TAG_FONT_SIZE", "8"));
            this.bodyFontSize = Integer.parseInt(prop.getProperty("BODY_FONT_SIZE", "12"));
            this.opacity = Float.parseFloat(prop.getProperty("OPACITY", "70")) / 100.0f;
            if (this.opacity > 1.0f) {
                this.opacity = 1.0f;
            } else if ((double)this.opacity < 0.1) {
                this.opacity = 0.1f;
            }
            ((InputStream)in).close();
        }
        catch (Exception in) {
            // empty catch block
        }
        try {
            EncodedProperties prop = new EncodedProperties();
            prop.load(CloudSticky.iniFile);
            this.TAG = prop.getProperty("TAG", "!");
            this.titleFont = new Font(prop.getProperty("FONT", "MS\u660e\u671d"), 0, this.titleFontSize);
            this.tagFont = new Font(prop.getProperty("FONT", "MS\u660e\u671d"), 0, this.tagFontSize);
            this.bodyFont = new Font(prop.getProperty("FONT", "MS\u660e\u671d"), 0, this.bodyFontSize);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Color getColor(String color) {
        if (color.startsWith("#")) {
            color = color.substring(1);
        }
        if (!color.matches("[0-9A-F][0-9A-F][0-9A-F][0-9A-F][0-9A-F][0-9A-F]")) {
            return null;
        }
        int c = Integer.parseInt(color, 16);
        return new Color((c & 0xFF0000) >> 16, (c & 0xFF00) >> 8, c & 0xFF);
    }

    public static String getColorString(Color color) {
        String blue;
        String green;
        String red = Integer.toHexString(color.getRed());
        if (red.length() == 1) {
            red = "0" + red;
        }
        if ((green = Integer.toHexString(color.getGreen())).length() == 1) {
            green = "0" + green;
        }
        if ((blue = Integer.toHexString(color.getBlue())).length() == 1) {
            blue = "0" + blue;
        }
        String result = "#" + red + green + blue;
        result = result.toUpperCase();
        return result;
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
        this.closeButton.setVisible(true);
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
        this.closeButton.setVisible(false);
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    public static void setWindowOpacity(Window window, float opacity) {
        AWTUtilities.setWindowOpacity((Window)window, (float)opacity);
    }

    public JDialog makeDialog(JDialog parent, boolean isModal, boolean dispCloseButton, final boolean exitOnClose) {
        this.dialog = parent == null ? new JDialog(){
            private static final long serialVersionUID = -6170408698660528217L;

            @Override
            public Container getContentPane() {
                return StickyPanelTemplate.this.contentPanel;
            }
        } : new JDialog(parent, isModal){
            private static final long serialVersionUID = -6170408698660528217L;

            @Override
            public Container getContentPane() {
                return StickyPanelTemplate.this.contentPanel;
            }
        };
        ImageIcon icon = new ImageIcon("icon.png");
        this.dialog.setIconImage(icon.getImage());
        this.dialog.setUndecorated(true);
        this.closeButton.setContentAreaFilled(false);
        this.closeButton.setFocusPainted(false);
        this.closeButton.setBorder(BorderFactory.createEmptyBorder());
        this.closeButton.setOpaque(true);
        this.closeButton.setBackground(this.frameColor);
        this.closeButton.setVisible(false);
        this.closeButton.addMouseListener(this);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StickyPanelTemplate.this.dialog.getToolkit().getSystemEventQueue().postEvent(new WindowEvent(StickyPanelTemplate.this.dialog, 201));
                if (exitOnClose) {
                    System.exit(0);
                } else {
                    StickyPanelTemplate.this.dialog.dispose();
                }
            }
        });
        DragWindowListener dwl = new DragWindowListener();
        this.titlePanel.addMouseListener(dwl);
        this.titlePanel.addMouseMotionListener(dwl);
        this.titlePanel.setOpaque(false);
        this.titlePanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.titlePanel.add(this.titleLabel);
        if (dispCloseButton) {
            this.titlePanel.add((Component)this.closeButton, "East");
        }
        ResizeWindowListener rwl = new ResizeWindowListener(this.dialog);
        this.left = new JLabel();
        this.right = new JLabel();
        this.top = new JLabel();
        this.bottom = new JLabel();
        this.topleft = new JLabel();
        this.topright = new JLabel();
        this.bottomleft = new JLabel();
        this.bottomright = new JLabel();
        for (JLabel l : Arrays.asList(this.left, this.right, this.top, this.bottom, this.topleft, this.topright, this.bottomleft, this.bottomright)) {
            l.addMouseListener(rwl);
            l.addMouseMotionListener(rwl);
        }
        this.left.setOpaque(true);
        this.left.setBackground(this.bodyColor);
        this.right.setOpaque(true);
        this.right.setBackground(this.bodyColor);
        this.bottom.setOpaque(true);
        this.bottom.setBackground(this.bodyColor);
        this.bottomright.setOpaque(true);
        this.bottomright.setBackground(this.bodyColor);
        this.bottomleft.setOpaque(true);
        this.bottomleft.setBackground(this.bodyColor);
        Dimension d = new Dimension(3, 0);
        this.left.setPreferredSize(d);
        this.left.setMinimumSize(d);
        this.right.setPreferredSize(d);
        this.right.setMinimumSize(d);
        d = new Dimension(0, 3);
        this.top.setPreferredSize(d);
        this.top.setMinimumSize(d);
        this.bottom.setPreferredSize(d);
        this.bottom.setMinimumSize(d);
        d = new Dimension(3, 3);
        this.topleft.setPreferredSize(d);
        this.topleft.setMinimumSize(d);
        this.topright.setPreferredSize(d);
        this.topright.setMinimumSize(d);
        this.bottomleft.setPreferredSize(d);
        this.bottomleft.setMinimumSize(d);
        this.bottomright.setPreferredSize(d);
        this.bottomright.setMinimumSize(d);
        this.left.setCursor(Cursor.getPredefinedCursor(10));
        this.right.setCursor(Cursor.getPredefinedCursor(11));
        this.top.setCursor(Cursor.getPredefinedCursor(8));
        this.bottom.setCursor(Cursor.getPredefinedCursor(9));
        this.topleft.setCursor(Cursor.getPredefinedCursor(6));
        this.topright.setCursor(Cursor.getPredefinedCursor(7));
        this.bottomleft.setCursor(Cursor.getPredefinedCursor(4));
        this.bottomright.setCursor(Cursor.getPredefinedCursor(5));
        this.northPanel = new JPanel(new BorderLayout(0, 0));
        this.northPanel.add((Component)this.topleft, "West");
        this.northPanel.add((Component)this.top, "North");
        this.northPanel.add((Component)this.titlePanel, "Center");
        this.northPanel.add((Component)this.topright, "East");
        this.southPanel = new JPanel(new BorderLayout());
        this.southPanel.add((Component)this.bottomleft, "West");
        this.southPanel.add((Component)this.bottom, "Center");
        this.southPanel.add((Component)this.bottomright, "East");
        this.resizePanel.add((Component)this.left, "West");
        this.resizePanel.add((Component)this.right, "East");
        this.resizePanel.add((Component)this.northPanel, "North");
        this.resizePanel.add((Component)this.southPanel, "South");
        this.resizePanel.add((Component)this.contentPanel, "Center");
        this.titlePanel.setOpaque(false);
        this.northPanel.setOpaque(false);
        this.southPanel.setOpaque(false);
        this.contentPanel.setOpaque(false);
        this.resizePanel.setOpaque(false);
        this.dialog.setContentPane(this.resizePanel);
        return this.dialog;
    }

    class ResizeWindowListener
    extends MouseAdapter {
        private Rectangle startSide = null;
        private final JDialog dialog;

        public ResizeWindowListener(JDialog dialog) {
            this.dialog = dialog;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.startSide = this.dialog.getBounds();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.startSide == null) {
                return;
            }
            Component c = e.getComponent();
            if (c == StickyPanelTemplate.this.topleft) {
                this.startSide.y += e.getY();
                this.startSide.height -= e.getY();
                this.startSide.x += e.getX();
                this.startSide.width -= e.getX();
            } else if (c == StickyPanelTemplate.this.top) {
                this.startSide.y += e.getY();
                this.startSide.height -= e.getY();
            } else if (c == StickyPanelTemplate.this.topright) {
                this.startSide.y += e.getY();
                this.startSide.height -= e.getY();
                this.startSide.width += e.getX();
            } else if (c == StickyPanelTemplate.this.left) {
                this.startSide.x += e.getX();
                this.startSide.width -= e.getX();
            } else if (c == StickyPanelTemplate.this.right) {
                this.startSide.width += e.getX();
            } else if (c == StickyPanelTemplate.this.bottomleft) {
                this.startSide.height += e.getY();
                this.startSide.x += e.getX();
                this.startSide.width -= e.getX();
            } else if (c == StickyPanelTemplate.this.bottom) {
                this.startSide.height += e.getY();
            } else if (c == StickyPanelTemplate.this.bottomright) {
                this.startSide.height += e.getY();
                this.startSide.width += e.getX();
            }
            this.dialog.setBounds(this.startSide);
        }
    }

    public static enum Side {
        NW_SIDE,
        N_SIDE,
        NE_SIDE,
        L_SIDE,
        R_SIDE,
        SW_SIDE,
        S_SIDE,
        SE_SIDE;

    }
}

