/*
 * Decompiled with CFR 0.152.
 */
package cloudsticky.gui;

import cloudsticky.CloudSticky;
import cloudsticky.EVNote;
import cloudsticky.gui.DragWindowListener;
import cloudsticky.gui.NoteEditDialog;
import cloudsticky.gui.StickyColor;
import cloudsticky.gui.StickyPanelTemplate;
import cloudsticky.util.DocumentUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;

public class Sticky
extends StickyPanelTemplate
implements Serializable,
ActionListener,
MouseListener {
    private static final long serialVersionUID = 1655394860464345894L;
    public JLabel label;
    public JLabel tagLabel;
    public EVNote evn;
    public boolean moved = false;
    public boolean hide = false;
    public boolean trans = false;
    public boolean bodyVisibility = true;
    JPopupMenu popup = new JPopupMenu();
    JMenuItem editTextMenu;
    JMenuItem editHtmlMenu;
    JMenuItem addMenu;
    JMenuItem deleteMenu;
    JMenuItem hideMenu;
    JMenu colorMenu;
    JCheckBoxMenuItem transparencyMenu;
    JScrollPane scroll;
    CloudSticky parent = null;

    public Sticky(CloudSticky sm, EVNote evn) {
        super(evn.title, null);
        this.evn = evn;
        this.parent = sm;
        this.titleLabel.addMouseListener(this);
        MyDragWindowListener dwl = new MyDragWindowListener();
        this.titleLabel.addMouseListener(dwl);
        this.titleLabel.addMouseMotionListener(dwl);
        this.label = new JLabel();
        this.label.setFont(this.bodyFont);
        this.label.setOpaque(true);
        this.label.setBackground(this.bodyColor);
        this.label.setForeground(this.bodyFontColor);
        this.label.addMouseListener(this);
        this.tagLabel = new JLabel();
        this.tagLabel.setFont(this.tagFont);
        this.tagLabel.setOpaque(true);
        this.tagLabel.setBackground(this.tagColor);
        this.tagLabel.setForeground(this.tagFontColor);
        this.tagLabel.addMouseListener(this);
        this.add((Component)this.tagLabel, "North");
        this.label.setMinimumSize(new Dimension(0, 0));
        this.scroll = new JScrollPane(this.label);
        this.scroll.setBorder(null);
        this.add(this.scroll);
        this.scroll.setMinimumSize(new Dimension(0, 0));
        this.contentPanel.setMinimumSize(new Dimension(0, 0));
        this.setLabel();
        this.addMenu = new JMenuItem("Add Sticky");
        this.addMenu.addActionListener(this);
        this.editTextMenu = new JMenuItem("Edit(Text)");
        this.editHtmlMenu = new JMenuItem("Edit(XML)");
        this.hideMenu = new JMenuItem("Hide");
        this.deleteMenu = new JMenuItem("Delete");
        this.editTextMenu.addActionListener(this);
        this.editHtmlMenu.addActionListener(this);
        this.hideMenu.addActionListener(this);
        this.deleteMenu.addActionListener(this);
        this.transparencyMenu = new JCheckBoxMenuItem("Translucent", this.trans);
        this.transparencyMenu.addActionListener(this);
        this.colorMenu = new JMenu("Color");
        String[][] colors = StickyColor.colors;
        String[] colorNames = StickyColor.colorNames;
        int i = 0;
        while (i < colorNames.length) {
            String name = colorNames[i];
            String[] list = colors[i];
            StickyColor c = new StickyColor(list);
            JMenuItem item = new JMenuItem(name);
            item.setOpaque(true);
            item.setBackground(c.titleColor);
            item.setForeground(c.titleFontColor);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JMenuItem mi = (JMenuItem)e.getSource();
                    int i = 0;
                    while (i < StickyColor.colorNames.length) {
                        String s = StickyColor.colorNames[i];
                        if (s.equals(mi.getText())) {
                            Sticky.this.changeColor(i);
                            Sticky.this.parent.saveCache();
                        }
                        ++i;
                    }
                }
            });
            this.colorMenu.add(item);
            ++i;
        }
        this.popup.add(this.editTextMenu);
        this.popup.add(this.editHtmlMenu);
        this.popup.addSeparator();
        this.popup.add(this.colorMenu);
        this.popup.add(this.transparencyMenu);
        this.popup.addSeparator();
        this.popup.add(this.hideMenu);
        this.popup.add(this.deleteMenu);
        this.popup.addSeparator();
        this.popup.add(this.addMenu);
        this.contentPanel.addMouseListener(this);
        this.setDefaultVisibility();
    }

    public void changeColor(int index) {
        String[] list = StickyColor.colors[index];
        StickyColor c = new StickyColor(list);
        this.setStickyColor(c);
        this.paintAll();
    }

    public void paintAll() {
        this.titleLabel.setBackground(this.frameColor);
        this.closeButton.setBackground(this.frameColor);
        this.titleLabel.setForeground(this.titleFontColor);
        this.tagLabel.setBackground(this.tagColor);
        this.tagLabel.setForeground(this.tagFontColor);
        this.label.setBackground(this.bodyColor);
        this.label.setForeground(this.bodyFontColor);
        this.resizePanel.repaint();
        this.left.setBackground(this.bodyColor);
        this.right.setBackground(this.bodyColor);
        this.bottom.setBackground(this.bodyColor);
        this.bottomright.setBackground(this.bodyColor);
        this.bottomleft.setBackground(this.bodyColor);
    }

    public void setStickyManager(CloudSticky sm) {
        this.parent = sm;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.addMenu)) {
            this.parent.addSticky();
        } else if (e.getSource().equals(this.editTextMenu)) {
            NoteEditDialog.createNoteEditDialog(this, this.parent, true);
        } else if (e.getSource().equals(this.editHtmlMenu)) {
            NoteEditDialog.createNoteEditDialog(this, this.parent, false);
        } else if (e.getSource().equals(this.hideMenu)) {
            this.hide = true;
            this.dialog.setVisible(false);
        } else if (e.getSource().equals(this.deleteMenu)) {
            if (this.parent.newStickyList.contains(this)) {
                this.parent.newStickyList.remove(this);
                this.dialog.setVisible(true);
                this.dialog.dispose();
            } else {
                List<String> tags = this.evn.note.getTagNames();
                tags.remove(this.TAG);
                this.evn.updateEVNote(this.evn.title, tags, this.evn.doc, this.TAG);
                this.hide = true;
                this.dialog.setVisible(false);
                this.titleLabel.setText("[*]" + this.evn.title);
            }
        } else if (e.getSource().equals(this.transparencyMenu)) {
            this.setTransparencyFlag(this.transparencyMenu.isSelected());
        }
        this.parent.saveCache();
    }

    public void setBodyVisibility(boolean flag) {
        if (flag) {
            this.resizePanel.add((Component)this.contentPanel, "Center");
            this.resizePanel.add((Component)this.southPanel, "South");
        } else {
            this.resizePanel.remove(this.contentPanel);
            this.resizePanel.remove(this.southPanel);
        }
        this.bodyVisibility = flag;
        this.dialog.pack();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            if (e.getSource().equals(this.label)) {
                NoteEditDialog.createNoteEditDialog(this, this.parent, true);
            } else if (e.getSource().equals(this.titleLabel)) {
                this.setBodyVisibility(!this.bodyVisibility);
                this.parent.saveCache();
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (e.getSource().equals(this.titleLabel)) {
            this.closeButton.setVisible(true);
        } else if (e.getSource().equals(this.label) && this.trans) {
            StickyPanelTemplate.setWindowOpacity(this.dialog, 1.0f);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (e.getSource().equals(this.titleLabel)) {
            this.closeButton.setVisible(false);
        } else if (e.getSource().equals(this.label) && this.trans) {
            StickyPanelTemplate.setWindowOpacity(this.dialog, this.opacity);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.popup.show(e.getComponent(), e.getX(), e.getY());
        } else if (e.getSource() instanceof JLabel) {
            this.parent.saveCache();
        }
    }

    @Override
    public JDialog makeDialog(JDialog parent, boolean isModal, boolean dispCloseButton, boolean exitOnClose) {
        super.makeDialog(parent, isModal, dispCloseButton, exitOnClose);
        this.closeButton.removeActionListener(this.closeButton.getActionListeners()[0]);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Sticky.this.hide = true;
                Sticky.this.dialog.getToolkit().getSystemEventQueue().postEvent(new WindowEvent(Sticky.this.dialog, 201));
            }
        });
        this.closeButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent arg0) {
                Sticky.this.closeButton.setVisible(true);
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
                Sticky.this.closeButton.setVisible(false);
            }
        });
        this.left.addMouseListener(this);
        this.right.addMouseListener(this);
        this.top.addMouseListener(this);
        this.bottom.addMouseListener(this);
        this.topleft.addMouseListener(this);
        this.topright.addMouseListener(this);
        this.bottomleft.addMouseListener(this);
        this.bottomright.addMouseListener(this);
        return this.dialog;
    }

    public void setEVNote(EVNote evn) {
        if (evn.note.getUpdated() != this.evn.note.getUpdated()) {
            this.evn = evn;
            this.setLabel();
            this.dialog.pack();
        }
    }

    public boolean tagEquals(List<String> tags) {
        if (this.evn.tags.size() != tags.size()) {
            return false;
        }
        int i = 0;
        while (i < this.evn.tags.size()) {
            if (!this.evn.tags.get(i).equals(tags.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setLabel() {
        if (this.evn.editFlag) {
            this.titleLabel.setText("[*]" + this.evn.title);
        } else {
            this.titleLabel.setText(this.evn.title);
        }
        this.label.setText(this.evn.content_html);
        List<String> tagList = this.evn.tags;
        if (tagList != null && tagList.size() != 0) {
            String tagstr = "<html><body>[ ";
            for (String tag : tagList) {
                tagstr = String.valueOf(tagstr) + tag + " ";
            }
            tagstr = String.valueOf(tagstr) + "]</body></html>";
            this.tagLabel.setText(tagstr);
        } else {
            this.tagLabel.setText("");
        }
    }

    public void setTransparencyFlag(boolean flag) {
        this.trans = flag;
        this.transparencyMenu.setSelected(this.trans);
        if (this.trans) {
            Sticky.setWindowOpacity(this.dialog, this.opacity);
        } else {
            Sticky.setWindowOpacity(this.dialog, 1.0f);
        }
    }

    public void setDefaultVisibility() {
        String bodyText = DocumentUtil.evnDoc2StrWithoutTag(this.evn.doc);
        String titleText = this.evn.title;
        if ("".equals(bodyText) || titleText.equals(bodyText)) {
            this.bodyVisibility = false;
        }
    }

    public void setStickyColor(StickyColor color) {
        this.frameColor = color.titleColor;
        this.tagColor = color.tagColor;
        this.bodyColor = color.bodyColor;
        this.titleFontColor = color.titleFontColor;
        this.tagFontColor = color.tagFontColor;
        this.bodyFontColor = color.bodyFontColor;
    }

    public static Sticky createSticky(CloudSticky sm, EVNote evn) {
        Sticky p = new Sticky(sm, evn);
        JDialog dialog = p.makeDialog(null, false, true, false);
        dialog.getContentPane().add(p);
        dialog.setMinimumSize(new Dimension(50, 15));
        dialog.pack();
        p.setTransparencyFlag(p.trans);
        p.setBodyVisibility(p.bodyVisibility);
        dialog.setVisible(false);
        return p;
    }

    class MyDragWindowListener
    extends DragWindowListener {
        MyDragWindowListener() {
        }

        @Override
        public void mouseDragged(MouseEvent me) {
            super.mouseDragged(me);
            if (!Sticky.this.moved) {
                Sticky.this.moved = true;
            }
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            Sticky.this.parent.saveCache();
        }
    }
}

