/*
 * Decompiled with CFR 0.152.
 */
package cloudsticky.gui;

import cloudsticky.CloudSticky;
import cloudsticky.gui.CloseIcon;
import cloudsticky.gui.ConfirmationDialog;
import cloudsticky.gui.StickyColor;
import cloudsticky.gui.StickyPanelTemplate;
import cloudsticky.util.EncodedProperties;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SettingDialog
extends StickyPanelTemplate {
    private static final long serialVersionUID = -9129249826203027996L;
    JButton okButton;
    JButton cancelButton;
    JButton defaultButton;
    JLabel useridTextLabel;
    JTextField tagField;
    JTextField syncField;
    JTextField portField;
    JSlider opacitySlider;
    JSlider redSlider;
    JSlider blueSlider;
    JSlider greenSlider;
    JComboBox fontBox;
    JTextField titleSizeField;
    JTextField tagSizeField;
    JTextField bodySizeField;
    Vector<StickyColor> colorVec = new Vector();
    Vector<JLabel> colorLabelVec = new Vector();
    int colorIndex = 0;
    JLabel titleFontColorLabel;
    JTextField titleFontColorField;
    JLabel tagFontColorLabel;
    JTextField tagFontColorField;
    JLabel bodyFontColorLabel;
    JTextField bodyFontColorField;
    JLabel titleColorLabel;
    JTextField titleColorField;
    JLabel tagColorLabel;
    JTextField tagColorField;
    JLabel bodyColorLabel;
    JTextField bodyColorField;
    JRadioButton titleFontColorButton;
    JRadioButton tagFontColorButton;
    JRadioButton bodyFontColorButton;
    JRadioButton titleColorButton;
    JRadioButton tagColorButton;
    JRadioButton bodyColorButton;
    ButtonGroup bgroup = new ButtonGroup();
    JTextField maxWidthField;
    JTextField maxHeightField;
    JPanel previewPanel = new JPanel();
    JPanel previewPanel2 = new JPanel();
    JPanel previewTitlePanel = new JPanel();
    JLabel previewTitleLabel = new JLabel(" title \u30bf\u30a4\u30c8\u30eb \u305f\u3044\u3068\u308b");
    JPanel previewTagPanel = new JPanel();
    JLabel previewTagLabel = new JLabel(" tag \u30bf\u30b0 \u305f\u3050");
    JPanel previewBodyPanel = new JPanel();
    JLabel previewBodyLabel = new JLabel(" body\u3000\u672c\u6587\u3000\u307b\u3093\u3076\u3093");
    JButton previewCloseButton;
    TreeSet<String> fontNameSet;
    CloudSticky manager;
    int maxWidth = 100;
    public String username_S;
    public String accessToken_S;
    public String noteStoreUrl_S;
    public String TAG_S = "!";
    public int WIDTH_MAX_S = 400;
    public int HEIGHT_MAX_S = 500;
    public int SLEEP_TIME_S = 900000;
    public int PORT_S = 34566;
    public Color frameColor_S;
    public Color bodyColor_S;
    public Color tagColor_S;
    public Color titleFontColor_S;
    public Color tagFontColor_S;
    public Color bodyFontColor_S;
    public int titleFontSize_S;
    public int tagFontSize_S;
    public int bodyFontSize_S;
    public Font font_S;
    public String fontName_S;
    public float opacity_S;

    public SettingDialog(final CloudSticky manager) {
        super("Setting", null);
        this.manager = manager;
        try {
            this.initPropertiesForSetting();
        }
        catch (Exception e) {
            System.err.println("[ini]Failed to read property file.");
        }
        this.okButton = new JButton(" OK ");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SettingDialog.this.saveIniFile()) {
                    ConfirmationDialog.createConfirmationDialog("Notification", "<html><body><center><b>Several parameters are applied<br/> after restart the proglam.</b></center></body></html>", SettingDialog.this.dialog);
                    manager.redrawSticky();
                    manager.settingFlag = false;
                    manager.updateCount = 0;
                    manager.TAG = SettingDialog.this.tagField.getText();
                    manager.SLEEP_TIME = Integer.parseInt(SettingDialog.this.syncField.getText()) * 1000 * 60;
                    manager.syncEvernote();
                    SettingDialog.this.dialog.getToolkit().getSystemEventQueue().postEvent(new WindowEvent(SettingDialog.this.dialog, 201));
                    SettingDialog.this.dialog.setVisible(false);
                    SettingDialog.this.dialog.dispose();
                }
            }
        });
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                manager.settingFlag = false;
                SettingDialog.this.dialog.getToolkit().getSystemEventQueue().postEvent(new WindowEvent(SettingDialog.this.dialog, 201));
                SettingDialog.this.dialog.setVisible(false);
                SettingDialog.this.dialog.dispose();
            }
        });
        this.defaultButton = new JButton("Default");
        this.defaultButton.setAlignmentX(0.5f);
        this.defaultButton.setMaximumSize(this.defaultButton.getPreferredSize());
        this.defaultButton.setMinimumSize(this.defaultButton.getPreferredSize());
        JPanel tagPanel = new JPanel();
        tagPanel.setBackground(this.bodyColor);
        tagPanel.setForeground(this.bodyFontColor);
        tagPanel.setLayout(new FlowLayout(0));
        JComponent sp = this.createSettingComponent();
        this.setParams();
        this.setListener();
        JPanel aPanel = new JPanel();
        aPanel.setBackground(this.bodyColor);
        aPanel.setForeground(this.bodyFontColor);
        aPanel.add(this.okButton);
        aPanel.add(new JLabel("        "));
        aPanel.add(this.defaultButton);
        aPanel.add(new JLabel("        "));
        aPanel.add(this.cancelButton);
        this.add((Component)this.titlePanel, "North");
        this.add((Component)sp, "Center");
        this.add((Component)aPanel, "South");
        this.changePreview();
    }

    public void initPropertiesForSetting() {
        EncodedProperties prop2;
        try {
            prop2 = new EncodedProperties();
            prop2.load(CloudSticky.iniFile);
            this.username_S = prop2.getProperty("EVERNOTE_USERNAME", "");
            this.accessToken_S = prop2.getProperty("EVERNOTE_ACCESS_TOKEN", "");
            this.noteStoreUrl_S = prop2.getProperty("EVERNOTE_URL", "");
            this.WIDTH_MAX_S = Integer.parseInt(prop2.getProperty("WIDTH_MAX"));
            this.HEIGHT_MAX_S = Integer.parseInt(prop2.getProperty("HEIGHT_MAX"));
            this.SLEEP_TIME_S = Integer.parseInt(prop2.getProperty("SLEEP_TIME")) * 1000 * 60;
            this.PORT_S = Integer.parseInt(prop2.getProperty("PORT", "34566"));
            this.frameColor_S = StickyPanelTemplate.getColor(prop2.getProperty("FRAME_COLOR", "#FFD700"));
            this.bodyColor_S = StickyPanelTemplate.getColor(prop2.getProperty("BODY_COLOR", "#FFFFE0"));
            this.tagColor_S = StickyPanelTemplate.getColor(prop2.getProperty("TAG_COLOR", "#FFF0E0"));
            this.titleFontColor_S = StickyPanelTemplate.getColor(prop2.getProperty("TITLE_FONT_COLOR", "#222222"));
            this.tagFontColor_S = StickyPanelTemplate.getColor(prop2.getProperty("TAG_FONT_COLOR", "#222222"));
            this.bodyFontColor_S = StickyPanelTemplate.getColor(prop2.getProperty("BODY_FONT_COLOR", "#222222"));
            this.titleFontSize_S = Integer.parseInt(prop2.getProperty("TITLE_FONT_SIZE", "12"));
            this.tagFontSize_S = Integer.parseInt(prop2.getProperty("TAG_FONT_SIZE", "8"));
            this.bodyFontSize_S = Integer.parseInt(prop2.getProperty("BODY_FONT_SIZE", "12"));
            this.opacity_S = Float.parseFloat(prop2.getProperty("OPACITY", "70")) / 100.0f;
            if (this.opacity_S > 1.0f) {
                this.opacity_S = 1.0f;
            } else if ((double)this.opacity_S < 0.1) {
                this.opacity_S = 0.1f;
            }
        }
        catch (Exception prop2) {
            // empty catch block
        }
        try {
            prop2 = new EncodedProperties();
            prop2.load(CloudSticky.iniFile);
            this.TAG_S = prop2.getProperty("TAG", "!");
            this.font_S = new Font(prop2.getProperty("FONT", "MS\u660e\u671d"), 0, this.titleFontSize);
            this.fontName_S = prop2.getProperty("FONT", "\uff2d\uff33\u660e\u671d");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public JComponent createSettingComponent() {
        JPanel panel = new JPanel();
        panel.setBackground(this.bodyColor);
        panel.setLayout(new BoxLayout(panel, 3));
        JPanel generalPanel = this.createGeneralPanel();
        generalPanel.setAlignmentX(0.0f);
        JPanel stylePanel = this.createStylePanel();
        stylePanel.setAlignmentX(0.0f);
        JPanel previewPanel = this.createPreviewPanel();
        previewPanel.setAlignmentX(0.0f);
        if (generalPanel.getPreferredSize().width > this.maxWidth) {
            this.maxWidth = generalPanel.getPreferredSize().width;
        }
        if (stylePanel.getPreferredSize().width > this.maxWidth) {
            this.maxWidth = stylePanel.getPreferredSize().width;
        }
        if (previewPanel.getPreferredSize().width > this.maxWidth) {
            this.maxWidth = previewPanel.getPreferredSize().width;
        }
        generalPanel.setPreferredSize(new Dimension(this.maxWidth, generalPanel.getPreferredSize().height));
        generalPanel.setMaximumSize(new Dimension(this.maxWidth, generalPanel.getPreferredSize().height));
        generalPanel.setMinimumSize(new Dimension(this.maxWidth, generalPanel.getPreferredSize().height));
        stylePanel.setPreferredSize(new Dimension(this.maxWidth, stylePanel.getPreferredSize().height));
        stylePanel.setMaximumSize(new Dimension(this.maxWidth, stylePanel.getPreferredSize().height));
        stylePanel.setMinimumSize(new Dimension(this.maxWidth, stylePanel.getPreferredSize().height));
        previewPanel.setPreferredSize(new Dimension(this.maxWidth, 150));
        previewPanel.setMaximumSize(new Dimension(this.maxWidth, 150));
        previewPanel.setMinimumSize(new Dimension(this.maxWidth, 150));
        panel.add(generalPanel);
        panel.add(stylePanel);
        panel.add(previewPanel);
        panel.setMaximumSize(panel.getPreferredSize());
        panel.setMinimumSize(panel.getPreferredSize());
        JScrollPane scrollpane = new JScrollPane(panel);
        scrollpane.setVerticalScrollBarPolicy(20);
        scrollpane.setHorizontalScrollBarPolicy(31);
        scrollpane.setPreferredSize(new Dimension(scrollpane.getPreferredSize().width + 20, 550));
        scrollpane.setBorder(null);
        return panel;
    }

    public JPanel createGeneralPanel() {
        JPanel panel = new JPanel();
        panel.setBackground(this.bodyColor);
        panel.setForeground(this.bodyFontColor);
        TitledBorder border = BorderFactory.createTitledBorder("General");
        border.setTitleColor(this.bodyFontColor);
        panel.setBorder(border);
        GroupLayout layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        JLabel useridLabel = new JLabel("UserID : ");
        useridLabel.setForeground(this.bodyFontColor);
        panel.add(useridLabel);
        JLabel tagLabel = new JLabel("Tag : ");
        tagLabel.setForeground(this.bodyFontColor);
        panel.add(tagLabel);
        JLabel syncLabel = new JLabel("Sync : ");
        syncLabel.setForeground(this.bodyFontColor);
        panel.add(syncLabel);
        JLabel portLabel = new JLabel("Port : ");
        portLabel.setForeground(this.bodyFontColor);
        panel.add(portLabel);
        this.useridTextLabel = new JLabel(this.manager.username);
        panel.add(this.useridTextLabel);
        this.useridTextLabel.setMaximumSize(this.useridTextLabel.getPreferredSize());
        this.useridTextLabel.setMinimumSize(this.useridTextLabel.getPreferredSize());
        this.tagField = new JTextField(10);
        panel.add(this.tagField);
        this.tagField.setMaximumSize(this.tagField.getPreferredSize());
        this.tagField.setMinimumSize(this.tagField.getPreferredSize());
        JPanel syncPanel = new JPanel();
        syncPanel.setBackground(this.bodyColor);
        syncPanel.setLayout(new BoxLayout(syncPanel, 2));
        this.syncField = new JTextField(4);
        this.syncField.setMaximumSize(this.syncField.getPreferredSize());
        this.syncField.setMinimumSize(this.syncField.getPreferredSize());
        syncPanel.add(this.syncField);
        JLabel syncTymeLabel = new JLabel(" minutes (5-3600)");
        syncTymeLabel.setForeground(this.bodyFontColor);
        syncPanel.add(syncTymeLabel);
        panel.add(syncPanel);
        this.portField = new JTextField(5);
        panel.add(this.portField);
        this.portField.setMaximumSize(this.portField.getPreferredSize());
        this.portField.setMinimumSize(this.portField.getPreferredSize());
        GroupLayout.SequentialGroup hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(useridLabel).addComponent(tagLabel).addComponent(syncLabel).addComponent(portLabel));
        hGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.useridTextLabel).addComponent(this.tagField).addComponent(syncPanel).addComponent(this.portField));
        layout.setHorizontalGroup(hGroup);
        GroupLayout.SequentialGroup vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(useridLabel).addComponent(this.useridTextLabel));
        vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(tagLabel).addComponent(this.tagField));
        vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(syncLabel).addComponent(syncPanel));
        vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(portLabel).addComponent(this.portField));
        layout.setVerticalGroup(vGroup);
        return panel;
    }

    public JPanel createStylePanel() {
        Font[] font = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        Vector<String> fontNameVec = new Vector<String>();
        Font[] fontArray = font;
        int n = font.length;
        int n2 = 0;
        while (n2 < n) {
            Font f = fontArray[n2];
            if (!fontNameVec.contains(f.getFamily())) {
                fontNameVec.add(f.getFamily());
            }
            ++n2;
        }
        this.fontNameSet = new TreeSet(fontNameVec);
        JPanel maxPanel = new JPanel();
        maxPanel.setBackground(this.bodyColor);
        maxPanel.setLayout(new BoxLayout(maxPanel, 2));
        this.maxWidthField = new JTextField(3);
        this.maxWidthField.setMaximumSize(this.maxWidthField.getPreferredSize());
        this.maxWidthField.setMinimumSize(this.maxWidthField.getPreferredSize());
        this.maxHeightField = new JTextField(3);
        this.maxHeightField.setMaximumSize(this.maxHeightField.getPreferredSize());
        this.maxHeightField.setMinimumSize(this.maxHeightField.getPreferredSize());
        JLabel widthLabel = new JLabel("Width: ");
        widthLabel.setForeground(this.bodyFontColor);
        maxPanel.add(widthLabel);
        maxPanel.add(this.maxWidthField);
        JLabel heightLabel = new JLabel("  Height: ");
        heightLabel.setForeground(this.bodyFontColor);
        maxPanel.add(heightLabel);
        maxPanel.add(this.maxHeightField);
        JPanel panel = new JPanel();
        panel.setBackground(this.bodyColor);
        panel.setForeground(this.bodyFontColor);
        TitledBorder border = BorderFactory.createTitledBorder("Default Style");
        border.setTitleColor(this.bodyFontColor);
        panel.setBorder(border);
        GroupLayout layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        JLabel opacityLabel = new JLabel("Opacity : ");
        opacityLabel.setForeground(this.bodyFontColor);
        panel.add(opacityLabel);
        JLabel maxLabel = new JLabel("Max Size : ");
        maxLabel.setForeground(this.bodyFontColor);
        panel.add(maxLabel);
        JLabel fontLabel = new JLabel("Font : ");
        fontLabel.setForeground(this.bodyFontColor);
        panel.add(fontLabel);
        JLabel fontSizeLabel = new JLabel("Font Size : ");
        fontSizeLabel.setForeground(this.bodyFontColor);
        panel.add(fontSizeLabel);
        JLabel titleLabel = new JLabel("Title : ");
        panel.add(titleLabel);
        JLabel tagLabel = new JLabel("Tag : ");
        panel.add(tagLabel);
        JLabel bodyLabel = new JLabel("Body : ");
        panel.add(bodyLabel);
        JLabel colorLabel = new JLabel("Color : ");
        colorLabel.setForeground(this.bodyFontColor);
        panel.add(colorLabel);
        this.opacitySlider = new JSlider(20, 100, (int)(this.opacity * 100.0f));
        this.opacitySlider.setBackground(this.bodyColor);
        this.opacitySlider.setForeground(this.bodyFontColor);
        this.opacitySlider.setLabelTable(this.opacitySlider.createStandardLabels(20));
        this.opacitySlider.setPaintLabels(true);
        this.opacitySlider.setPreferredSize(new Dimension(150, 40));
        this.opacitySlider.setMaximumSize(this.opacitySlider.getPreferredSize());
        this.opacitySlider.setMinimumSize(this.opacitySlider.getPreferredSize());
        panel.add(this.opacitySlider);
        this.fontBox = new JComboBox<Object>(this.fontNameSet.toArray());
        this.fontBox.setMaximumSize(this.fontBox.getPreferredSize());
        this.fontBox.setMinimumSize(this.fontBox.getPreferredSize());
        this.titleSizeField = new JTextField(2);
        this.titleSizeField.setMaximumSize(this.titleSizeField.getPreferredSize());
        this.titleSizeField.setMinimumSize(this.titleSizeField.getPreferredSize());
        this.tagSizeField = new JTextField(2);
        this.tagSizeField.setMaximumSize(this.tagSizeField.getPreferredSize());
        this.tagSizeField.setMinimumSize(this.tagSizeField.getPreferredSize());
        this.bodySizeField = new JTextField(2);
        this.bodySizeField.setMaximumSize(this.bodySizeField.getPreferredSize());
        this.bodySizeField.setMinimumSize(this.bodySizeField.getPreferredSize());
        JPanel fontSizePanel = new JPanel();
        fontSizePanel.setBackground(this.bodyColor);
        fontSizePanel.setLayout(new BoxLayout(fontSizePanel, 2));
        JLabel tmpTitleLabel = new JLabel("Title : ");
        tmpTitleLabel.setForeground(this.bodyFontColor);
        JLabel tmpTagLabel = new JLabel("  Tag : ");
        tmpTagLabel.setForeground(this.bodyFontColor);
        JLabel tmpBodyLabel = new JLabel("  Body : ");
        tmpBodyLabel.setForeground(this.bodyFontColor);
        fontSizePanel.add(tmpTitleLabel);
        fontSizePanel.add(this.titleSizeField);
        fontSizePanel.add(tmpTagLabel);
        fontSizePanel.add(this.tagSizeField);
        fontSizePanel.add(tmpBodyLabel);
        fontSizePanel.add(this.bodySizeField);
        this.titleFontColorField = new JTextField(7);
        this.titleFontColorField.setMaximumSize(this.titleFontColorField.getPreferredSize());
        this.titleFontColorField.setMinimumSize(this.titleFontColorField.getPreferredSize());
        this.tagFontColorField = new JTextField(7);
        this.tagFontColorField.setMaximumSize(this.tagFontColorField.getPreferredSize());
        this.tagFontColorField.setMinimumSize(this.tagFontColorField.getPreferredSize());
        this.bodyFontColorField = new JTextField(7);
        this.bodyFontColorField.setMaximumSize(this.bodyFontColorField.getPreferredSize());
        this.bodyFontColorField.setMinimumSize(this.bodyFontColorField.getPreferredSize());
        this.titleColorField = new JTextField(7);
        this.titleColorField.setMaximumSize(this.titleColorField.getPreferredSize());
        this.titleColorField.setMinimumSize(this.titleColorField.getPreferredSize());
        this.tagColorField = new JTextField(7);
        this.tagColorField.setMaximumSize(this.tagColorField.getPreferredSize());
        this.tagColorField.setMinimumSize(this.tagColorField.getPreferredSize());
        this.bodyColorField = new JTextField(7);
        this.bodyColorField.setMaximumSize(this.bodyColorField.getPreferredSize());
        this.bodyColorField.setMinimumSize(this.bodyColorField.getPreferredSize());
        this.titleFontColorButton = new JRadioButton("Font : ");
        this.titleFontColorButton.setBackground(this.bodyColor);
        this.titleFontColorButton.setMaximumSize(this.titleFontColorButton.getPreferredSize());
        this.titleFontColorButton.setMinimumSize(this.titleFontColorButton.getPreferredSize());
        this.tagFontColorButton = new JRadioButton("Font : ");
        this.tagFontColorButton.setBackground(this.bodyColor);
        this.tagFontColorButton.setMaximumSize(this.titleFontColorButton.getPreferredSize());
        this.tagFontColorButton.setMinimumSize(this.titleFontColorButton.getPreferredSize());
        this.bodyFontColorButton = new JRadioButton("Font : ");
        this.bodyFontColorButton.setBackground(this.bodyColor);
        this.bodyFontColorButton.setMaximumSize(this.titleFontColorButton.getPreferredSize());
        this.bodyFontColorButton.setMinimumSize(this.titleFontColorButton.getPreferredSize());
        this.bodyColorButton = new JRadioButton("BG : ");
        this.bodyColorButton.setBackground(this.bodyColor);
        this.bodyColorButton.setMaximumSize(this.titleFontColorButton.getPreferredSize());
        this.bodyColorButton.setMinimumSize(this.titleFontColorButton.getPreferredSize());
        this.tagColorButton = new JRadioButton("BG : ");
        this.tagColorButton.setBackground(this.bodyColor);
        this.tagColorButton.setMaximumSize(this.titleFontColorButton.getPreferredSize());
        this.tagColorButton.setMinimumSize(this.titleFontColorButton.getPreferredSize());
        this.titleColorButton = new JRadioButton("BG : ");
        this.titleColorButton.setBackground(this.bodyColor);
        this.titleColorButton.setMaximumSize(this.titleFontColorButton.getPreferredSize());
        this.titleColorButton.setMinimumSize(this.titleFontColorButton.getPreferredSize());
        this.titleFontColorLabel = new JLabel("    ");
        this.titleFontColorLabel.setBorder(new LineBorder(Color.black, 1));
        this.titleFontColorLabel.setOpaque(true);
        this.tagFontColorLabel = new JLabel("    ");
        this.tagFontColorLabel.setBorder(new LineBorder(Color.black, 1));
        this.tagFontColorLabel.setOpaque(true);
        this.bodyFontColorLabel = new JLabel("    ");
        this.bodyFontColorLabel.setBorder(new LineBorder(Color.black, 1));
        this.bodyFontColorLabel.setOpaque(true);
        this.bgroup.add(this.titleFontColorButton);
        this.bgroup.add(this.tagFontColorButton);
        this.bgroup.add(this.bodyFontColorButton);
        this.bgroup.add(this.titleColorButton);
        this.bgroup.add(this.tagColorButton);
        this.bgroup.add(this.bodyColorButton);
        this.makeColorVec();
        JPanel colorSelectPanel = new JPanel();
        colorSelectPanel.setLayout(new FlowLayout(0));
        colorSelectPanel.setBackground(this.bodyColor);
        for (JLabel l : this.colorLabelVec) {
            colorSelectPanel.add(l);
        }
        this.titleColorLabel = new JLabel("    ");
        this.titleColorLabel.setBorder(new LineBorder(Color.black, 1));
        this.titleColorLabel.setOpaque(true);
        this.tagColorLabel = new JLabel("    ");
        this.tagColorLabel.setBorder(new LineBorder(Color.black, 1));
        this.tagColorLabel.setOpaque(true);
        this.bodyColorLabel = new JLabel("    ");
        this.bodyColorLabel.setBorder(new LineBorder(Color.black, 1));
        this.bodyColorLabel.setOpaque(true);
        JPanel titleColorPanel = new JPanel();
        titleColorPanel.setBackground(this.bodyColor);
        titleColorPanel.setLayout(new BoxLayout(titleColorPanel, 1));
        JPanel titleColorPanelB = new JPanel();
        titleColorPanelB.setBackground(this.bodyColor);
        titleColorPanelB.setLayout(new BoxLayout(titleColorPanelB, 2));
        titleColorPanelB.add(this.titleColorButton);
        titleColorPanelB.add(this.titleColorLabel);
        titleColorPanelB.add(new JLabel("  "));
        titleColorPanelB.add(this.titleColorField);
        JPanel titleColorPanelF = new JPanel();
        titleColorPanelF.setBackground(this.bodyColor);
        titleColorPanelF.setLayout(new BoxLayout(titleColorPanelF, 2));
        titleColorPanelF.add(this.titleFontColorButton);
        titleColorPanelF.add(this.titleFontColorLabel);
        titleColorPanelF.add(new JLabel("  "));
        titleColorPanelF.add(this.titleFontColorField);
        titleColorPanel.add(titleColorPanelB);
        titleColorPanel.add(titleColorPanelF);
        JPanel tagColorPanel = new JPanel();
        tagColorPanel.setBackground(this.bodyColor);
        tagColorPanel.setLayout(new BoxLayout(tagColorPanel, 1));
        JPanel tagColorPanelB = new JPanel();
        tagColorPanelB.setBackground(this.bodyColor);
        tagColorPanelB.setLayout(new BoxLayout(tagColorPanelB, 2));
        tagColorPanelB.add(this.tagColorButton);
        tagColorPanelB.add(this.tagColorLabel);
        tagColorPanelB.add(new JLabel("  "));
        tagColorPanelB.add(this.tagColorField);
        JPanel tagColorPanelF = new JPanel();
        tagColorPanelF.setBackground(this.bodyColor);
        tagColorPanelF.setLayout(new BoxLayout(tagColorPanelF, 2));
        tagColorPanelF.add(this.tagFontColorButton);
        tagColorPanelF.add(this.tagFontColorLabel);
        tagColorPanelF.add(new JLabel("  "));
        tagColorPanelF.add(this.tagFontColorField);
        tagColorPanel.add(tagColorPanelB);
        tagColorPanel.add(tagColorPanelF);
        JPanel bodyColorPanel = new JPanel();
        bodyColorPanel.setBackground(this.bodyColor);
        bodyColorPanel.setLayout(new BoxLayout(bodyColorPanel, 1));
        JPanel bodyColorPanelB = new JPanel();
        bodyColorPanelB.setBackground(this.bodyColor);
        bodyColorPanelB.setLayout(new BoxLayout(bodyColorPanelB, 2));
        bodyColorPanelB.add(this.bodyColorButton);
        bodyColorPanelB.add(this.bodyColorLabel);
        bodyColorPanelB.add(new JLabel("  "));
        bodyColorPanelB.add(this.bodyColorField);
        JPanel bodyColorPanelF = new JPanel();
        bodyColorPanelF.setBackground(this.bodyColor);
        bodyColorPanelF.setLayout(new BoxLayout(bodyColorPanelF, 2));
        bodyColorPanelF.add(this.bodyFontColorButton);
        bodyColorPanelF.add(this.bodyFontColorLabel);
        bodyColorPanelF.add(new JLabel("  "));
        bodyColorPanelF.add(this.bodyFontColorField);
        bodyColorPanel.add(bodyColorPanelB);
        bodyColorPanel.add(bodyColorPanelF);
        GroupLayout.SequentialGroup hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(opacityLabel).addComponent(maxLabel).addComponent(fontLabel).addComponent(fontSizeLabel).addComponent(colorLabel));
        hGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.opacitySlider).addComponent(maxPanel).addComponent(this.fontBox).addComponent(fontSizePanel).addComponent(colorSelectPanel));
        layout.setHorizontalGroup(hGroup);
        GroupLayout.SequentialGroup vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(maxLabel).addComponent(maxPanel));
        vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(opacityLabel).addComponent(this.opacitySlider));
        vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(fontLabel).addComponent(this.fontBox));
        vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(fontSizeLabel).addComponent(fontSizePanel));
        vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(colorLabel).addComponent(colorSelectPanel));
        layout.setVerticalGroup(vGroup);
        return panel;
    }

    public void makeColorVec() {
        String[][] colors = StickyColor.colors;
        int i = 0;
        while (i < colors.length) {
            String[] a = colors[i];
            StickyColor c = new StickyColor(a[0], a[1], a[2], a[3], a[4], a[5]);
            this.colorVec.add(c);
            ++i;
        }
        for (StickyColor c : this.colorVec) {
            JLabel l = new JLabel("  ");
            l.setOpaque(true);
            l.setBackground(c.titleColor);
            l.setBorder(new LineBorder(l.getBackground(), 4));
            this.colorLabelVec.add(l);
            l.addMouseListener(new MouseListener(){

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    JLabel label = (JLabel)e.getSource();
                    int i = 0;
                    while (i < SettingDialog.this.colorLabelVec.size()) {
                        JLabel cl = SettingDialog.this.colorLabelVec.elementAt(i);
                        if (cl.equals(label)) {
                            if (cl.getBackground().equals(Color.black)) {
                                cl.setBorder(new LineBorder(new Color(230, 230, 230), 4));
                            } else {
                                cl.setBorder(new LineBorder(new Color(30, 30, 30), 4));
                            }
                            SettingDialog.this.colorIndex = i;
                        } else {
                            cl.setBorder(new LineBorder(cl.getBackground(), 4));
                        }
                        ++i;
                    }
                    SettingDialog.this.changePreview();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                }
            });
        }
        i = 0;
        while (i < this.colorVec.size()) {
            StickyColor c = this.colorVec.elementAt(i);
            if (c.titleColor.equals(this.frameColor_S)) {
                JLabel cl = this.colorLabelVec.elementAt(i);
                if (cl.getBackground().equals(Color.black)) {
                    cl.setBorder(new LineBorder(new Color(230, 230, 230), 4));
                } else {
                    cl.setBorder(new LineBorder(new Color(30, 30, 30), 4));
                }
                this.colorIndex = i;
            }
            ++i;
        }
    }

    public JPanel createPreviewPanel() {
        JPanel panel = new JPanel();
        panel.setBackground(this.bodyColor);
        panel.setForeground(this.bodyFontColor);
        TitledBorder border = BorderFactory.createTitledBorder("Preview");
        border.setTitleColor(this.bodyFontColor);
        panel.setBorder(border);
        panel.setLayout(new BoxLayout(panel, 3));
        panel.setAlignmentX(0.5f);
        this.previewPanel2.setBorder(new LineBorder(new Color(200, 200, 200), 1));
        this.previewPanel2.setAlignmentX(0.5f);
        this.previewPanel2.setLayout(new BoxLayout(this.previewPanel2, 3));
        this.previewTitlePanel.setLayout(new BorderLayout());
        this.previewTitlePanel.setBackground(this.frameColor);
        this.previewTitlePanel.add((Component)this.previewTitleLabel, "West");
        this.previewTitleLabel.setFont(this.titleFont);
        this.previewTitleLabel.setOpaque(true);
        this.previewTitleLabel.setBackground(this.frameColor);
        this.previewCloseButton = new JButton(new CloseIcon());
        this.previewCloseButton.setContentAreaFilled(false);
        this.previewCloseButton.setFocusPainted(false);
        this.previewCloseButton.setBorder(BorderFactory.createEmptyBorder());
        this.previewCloseButton.setOpaque(true);
        this.previewCloseButton.setBackground(this.frameColor);
        this.previewTitlePanel.add((Component)this.previewCloseButton, "East");
        this.previewTagPanel.setLayout(new BorderLayout());
        this.previewTagPanel.setBackground(this.tagColor);
        this.previewTagPanel.add((Component)this.previewTagLabel, "West");
        this.previewTagLabel.setFont(this.tagFont);
        this.previewTagLabel.setOpaque(true);
        this.previewTagLabel.setBackground(this.tagColor);
        this.previewBodyPanel.setLayout(new BorderLayout());
        this.previewBodyPanel.setBackground(this.bodyColor);
        this.previewBodyPanel.add((Component)this.previewBodyLabel, "West");
        this.previewBodyLabel.setFont(this.bodyFont);
        this.previewBodyLabel.setOpaque(true);
        this.previewBodyLabel.setBackground(this.bodyColor);
        this.previewPanel2.add(this.previewTitlePanel);
        this.previewPanel2.add(this.previewTagPanel);
        this.previewPanel2.add(this.previewBodyPanel);
        this.previewPanel2.setMaximumSize(new Dimension(230, 100));
        this.previewPanel2.setMinimumSize(new Dimension(150, this.previewPanel2.getPreferredSize().height));
        panel.add(this.previewPanel2);
        return panel;
    }

    public void setDefaultParams() {
        this.username_S = "";
        this.accessToken_S = "";
        this.noteStoreUrl_S = "";
        this.useridTextLabel.setText("");
        this.tagField.setText("!");
        this.portField.setText(Integer.toString(34566));
        this.syncField.setText(Integer.toString(15));
        this.maxWidthField.setText(Integer.toString(400));
        this.maxHeightField.setText(Integer.toString(500));
        String fontname = "\u30e1\u30a4\u30ea\u30aa";
        this.fontBox.setSelectedItem(fontname);
        this.titleSizeField.setText(Integer.toString(12));
        this.tagSizeField.setText(Integer.toString(9));
        this.bodySizeField.setText(Integer.toString(12));
        this.opacitySlider.setValue(70);
        this.colorIndex = 0;
        int i = 0;
        while (i < this.colorLabelVec.size()) {
            JLabel cl = this.colorLabelVec.elementAt(i);
            if (i == this.colorIndex) {
                if (cl.getBackground().equals(Color.black)) {
                    cl.setBorder(new LineBorder(new Color(230, 230, 230), 4));
                } else {
                    cl.setBorder(new LineBorder(new Color(30, 30, 30), 4));
                }
            } else {
                cl.setBorder(new LineBorder(cl.getBackground(), 4));
            }
            ++i;
        }
        this.changePreview();
    }

    public boolean generalValidation() {
        if (!this.isInteger(this.portField.getText())) {
            return false;
        }
        int pnum = Integer.parseInt(this.portField.getText());
        if (pnum < 0 || pnum > 65535) {
            return false;
        }
        if (!this.isInteger(this.syncField.getText())) {
            return false;
        }
        int snum = Integer.parseInt(this.syncField.getText());
        return snum >= 5 && snum <= 3600;
    }

    public boolean styleValidation() {
        if (!this.isInteger(this.titleSizeField.getText())) {
            return false;
        }
        if (!this.isInteger(this.tagSizeField.getText())) {
            return false;
        }
        if (!this.isInteger(this.bodySizeField.getText())) {
            return false;
        }
        if (StickyPanelTemplate.getColor(this.titleColorField.getText()) == null) {
            return false;
        }
        if (StickyPanelTemplate.getColor(this.tagColorField.getText()) == null) {
            return false;
        }
        if (StickyPanelTemplate.getColor(this.bodyColorField.getText()) == null) {
            return false;
        }
        if (StickyPanelTemplate.getColor(this.titleFontColorField.getText()) == null) {
            return false;
        }
        if (StickyPanelTemplate.getColor(this.tagFontColorField.getText()) == null) {
            return false;
        }
        return StickyPanelTemplate.getColor(this.bodyFontColorField.getText()) != null;
    }

    public void changePreview() {
        if (!this.styleValidation()) {
            return;
        }
        this.previewTitleLabel.setFont(new Font((String)this.fontBox.getSelectedItem(), 0, Integer.parseInt(this.titleSizeField.getText())));
        this.previewTagLabel.setFont(new Font((String)this.fontBox.getSelectedItem(), 0, Integer.parseInt(this.tagSizeField.getText())));
        this.previewBodyLabel.setFont(new Font((String)this.fontBox.getSelectedItem(), 0, Integer.parseInt(this.bodySizeField.getText())));
        StickyColor c = this.colorVec.elementAt(this.colorIndex);
        this.previewTitleLabel.setBackground(c.titleColor);
        this.previewTitleLabel.setForeground(c.titleFontColor);
        this.previewTitlePanel.setBackground(c.titleColor);
        this.previewCloseButton.setBackground(c.titleColor);
        this.previewTagLabel.setBackground(c.tagColor);
        this.previewTagLabel.setForeground(c.tagFontColor);
        this.previewTagPanel.setBackground(c.tagColor);
        this.previewBodyLabel.setBackground(c.bodyColor);
        this.previewBodyLabel.setForeground(c.bodyFontColor);
        this.previewBodyPanel.setBackground(c.bodyColor);
    }

    public void setListener() {
        this.titleSizeField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                SettingDialog.this.changePreview();
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                SettingDialog.this.changePreview();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                SettingDialog.this.changePreview();
            }
        });
        this.tagSizeField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                SettingDialog.this.changePreview();
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                SettingDialog.this.changePreview();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                SettingDialog.this.changePreview();
            }
        });
        this.bodySizeField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                SettingDialog.this.changePreview();
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                SettingDialog.this.changePreview();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                SettingDialog.this.changePreview();
            }
        });
        this.titleColorField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                SettingDialog.this.changePreview();
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                SettingDialog.this.changePreview();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                SettingDialog.this.changePreview();
            }
        });
        this.tagColorField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                SettingDialog.this.changePreview();
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                SettingDialog.this.changePreview();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                SettingDialog.this.changePreview();
            }
        });
        this.bodyColorField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                SettingDialog.this.changePreview();
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                SettingDialog.this.changePreview();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                SettingDialog.this.changePreview();
            }
        });
        this.titleFontColorField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                SettingDialog.this.changePreview();
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                SettingDialog.this.changePreview();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                SettingDialog.this.changePreview();
            }
        });
        this.tagFontColorField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                SettingDialog.this.changePreview();
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                SettingDialog.this.changePreview();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                SettingDialog.this.changePreview();
            }
        });
        this.bodyFontColorField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                SettingDialog.this.changePreview();
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                SettingDialog.this.changePreview();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                SettingDialog.this.changePreview();
            }
        });
        this.fontBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingDialog.this.changePreview();
            }
        });
        this.titleColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingDialog.this.setColorSlider(SettingDialog.this.titleColorField.getText());
            }
        });
        this.tagColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingDialog.this.setColorSlider(SettingDialog.this.tagColorField.getText());
            }
        });
        this.bodyColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingDialog.this.setColorSlider(SettingDialog.this.bodyColorField.getText());
            }
        });
        this.titleFontColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingDialog.this.setColorSlider(SettingDialog.this.titleFontColorField.getText());
            }
        });
        this.tagFontColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingDialog.this.setColorSlider(SettingDialog.this.tagFontColorField.getText());
            }
        });
        this.bodyFontColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingDialog.this.setColorSlider(SettingDialog.this.bodyFontColorField.getText());
            }
        });
        this.defaultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingDialog.this.setDefaultParams();
            }
        });
    }

    public void addSliderListener() {
        this.redSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SettingDialog.this.setColor();
            }
        });
        this.greenSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SettingDialog.this.setColor();
            }
        });
        this.blueSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SettingDialog.this.setColor();
            }
        });
    }

    public void changeColor(String str) {
        String ti = "#FFF090";
        String ta = "#FFFFC0";
        String bo = "#FFFFE0";
        String tif = "#222222";
        String taf = "#222222";
        String bof = "#222222";
        if ("yellow".equals(str)) {
            ti = "#FFF090";
            ta = "#FFFFC0";
            bo = "#FFFFE0";
            tif = "#222222";
            taf = "#222222";
            bof = "#222222";
        } else if ("blue".equals(str)) {
            ti = "#3B56FF";
            ta = "#B8D3FF";
            bo = "#E9EFFF";
            tif = "#FFFFFF";
            taf = "#222222";
            bof = "#222222";
        } else if ("green".equals(str)) {
            ti = "#77DD77";
            ta = "#D3FF8E";
            bo = "#F6FFD1";
            tif = "#222222";
            taf = "#222222";
            bof = "#222222";
        } else if ("red".equals(str)) {
            ti = "#FF3333";
            ta = "#FFE0E0";
            bo = "#FFF0F4";
            tif = "#FFFFFF";
            taf = "#222222";
            bof = "#222222";
        } else if ("purple".equals(str)) {
            ti = "#920783";
            ta = "#DBBEDA";
            bo = "#EFE0F8";
            tif = "#FFFFFF";
            taf = "#222222";
            bof = "#222222";
        } else if ("gray".equals(str)) {
            ti = "#C0C0C0";
            ta = "#D0D0D0";
            bo = "#F0F0F0";
            tif = "#222222";
            taf = "#222222";
            bof = "#222222";
        } else {
            return;
        }
        this.titleColorField.setText(ti);
        this.tagColorField.setText(ta);
        this.bodyColorField.setText(bo);
        this.titleFontColorField.setText(tif);
        this.tagFontColorField.setText(taf);
        this.bodyFontColorField.setText(bof);
    }

    public void setColorSlider(String str) {
        Color color = StickyPanelTemplate.getColor(str);
        if (color == null) {
            return;
        }
        this.redSlider.removeChangeListener(null);
        this.greenSlider.removeChangeListener(null);
        this.blueSlider.removeChangeListener(null);
        this.redSlider.setValue(color.getRed());
        this.greenSlider.setValue(color.getGreen());
        this.blueSlider.setValue(color.getBlue());
        this.addSliderListener();
    }

    public void setColor() {
        String blue;
        String green;
        String red = Integer.toHexString(this.redSlider.getValue()).toUpperCase();
        if (red.length() == 1) {
            red = "0" + red;
        }
        if ((green = Integer.toHexString(this.greenSlider.getValue()).toUpperCase()).length() == 1) {
            green = "0" + green;
        }
        if ((blue = Integer.toHexString(this.blueSlider.getValue()).toUpperCase()).length() == 1) {
            blue = "0" + blue;
        }
        String colorString = "#" + red + green + blue;
        if (this.titleColorButton.isSelected()) {
            this.titleColorField.setText(colorString);
        }
        if (this.tagColorButton.isSelected()) {
            this.tagColorField.setText(colorString);
        }
        if (this.bodyColorButton.isSelected()) {
            this.bodyColorField.setText(colorString);
        }
        if (this.titleFontColorButton.isSelected()) {
            this.titleFontColorField.setText(colorString);
        }
        if (this.tagFontColorButton.isSelected()) {
            this.tagFontColorField.setText(colorString);
        }
        if (this.bodyFontColorButton.isSelected()) {
            this.bodyFontColorField.setText(colorString);
        }
    }

    public void setParams() {
        this.useridTextLabel.setText(this.username_S);
        this.tagField.setText(this.TAG_S);
        this.portField.setText(Integer.toString(this.PORT_S));
        this.syncField.setText(Integer.toString(this.SLEEP_TIME_S / 60 / 1000));
        this.maxWidthField.setText(Integer.toString(this.WIDTH_MAX_S));
        this.maxHeightField.setText(Integer.toString(this.HEIGHT_MAX_S));
        this.fontBox.setSelectedItem(this.fontName_S);
        this.titleSizeField.setText(Integer.toString(this.titleFontSize_S));
        this.tagSizeField.setText(Integer.toString(this.tagFontSize_S));
        this.bodySizeField.setText(Integer.toString(this.bodyFontSize_S));
        this.opacitySlider.setValue((int)(this.opacity_S * 100.0f));
        this.titleColorField.setText(StickyPanelTemplate.getColorString(this.frameColor_S).toUpperCase());
        this.tagColorField.setText(StickyPanelTemplate.getColorString(this.tagColor_S).toUpperCase());
        this.bodyColorField.setText(StickyPanelTemplate.getColorString(this.bodyColor_S).toUpperCase());
        this.titleFontColorField.setText(StickyPanelTemplate.getColorString(this.titleFontColor_S).toUpperCase());
        this.tagFontColorField.setText(StickyPanelTemplate.getColorString(this.tagFontColor_S).toUpperCase());
        this.bodyFontColorField.setText(StickyPanelTemplate.getColorString(this.bodyFontColor_S).toUpperCase());
        this.titleColorLabel.setBackground(this.frameColor_S);
        this.tagColorLabel.setBackground(this.tagColor_S);
        this.bodyColorLabel.setBackground(this.bodyColor_S);
        this.titleFontColorLabel.setBackground(this.titleFontColor_S);
        this.tagFontColorLabel.setBackground(this.tagFontColor_S);
        this.bodyFontColorLabel.setBackground(this.bodyFontColor_S);
    }

    public boolean isInteger(String str) {
        try {
            Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public boolean saveIniFile() {
        if (!this.generalValidation() || !this.styleValidation()) {
            ConfirmationDialog.createConfirmationDialog("Error", "There are invalid properties.", this.dialog);
            return false;
        }
        File file = new File(CloudSticky.iniFile);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                System.err.println("CloudSticky.ini is open.");
                return false;
            }
        }
        try {
            StickyColor c = this.colorVec.elementAt(this.colorIndex);
            PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            out.println("#Evernote Sticky \u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb");
            out.println("#!!!!!!!!!!!!!!!!!!!\u672c\u30d5\u30a1\u30a4\u30eb\u3092\u76f4\u63a5\u7de8\u96c6\u3057\u306a\u3044\u3067\u304f\u3060\u3055\u3044!!!!!!!!!!!!!!!!!!!");
            out.println("#\u8a2d\u5b9a\u5909\u66f4\u306f\u30bf\u30b9\u30af\u30c8\u30ec\u30a4\u30a2\u30a4\u30b3\u30f3\u306e\u53f3\u30af\u30ea\u30c3\u30af\u304b\u3089[Setting]\u3092\u9078\u3093\u3067\u304f\u3060\u3055\u3044\uff0e");
            out.println();
            out.println();
            out.println("#General");
            out.println();
            out.println("EVERNOTE_USERNAME=" + this.username_S);
            out.println("EVERNOTE_ACCESS_TOKEN=" + this.accessToken_S);
            out.println("EVERNOTE_URL=" + this.noteStoreUrl_S);
            out.println("TAG=" + this.tagField.getText());
            out.println("PORT=" + this.portField.getText());
            out.println("SLEEP_TIME=" + this.syncField.getText());
            out.println();
            out.println();
            out.println("#Style");
            out.println();
            out.println("WIDTH_MAX=" + this.maxWidthField.getText());
            out.println("HEIGHT_MAX=" + this.maxHeightField.getText());
            out.println();
            out.println("OPACITY=" + this.opacitySlider.getValue());
            out.println();
            out.println("FONT=" + this.fontBox.getSelectedItem());
            out.println();
            out.println("FRAME_COLOR=" + StickyPanelTemplate.getColorString(c.titleColor));
            out.println("TAG_COLOR=" + StickyPanelTemplate.getColorString(c.tagColor));
            out.println("BODY_COLOR=" + StickyPanelTemplate.getColorString(c.bodyColor));
            out.println();
            out.println("TITLE_FONT_COLOR=" + StickyPanelTemplate.getColorString(c.titleFontColor));
            out.println("TAG_FONT_COLOR=" + StickyPanelTemplate.getColorString(c.tagFontColor));
            out.println("BODY_FONT_COLOR=" + StickyPanelTemplate.getColorString(c.bodyFontColor));
            out.println();
            out.println("TITLE_FONT_SIZE=" + this.titleSizeField.getText());
            out.println("TAG_FONT_SIZE=" + this.tagSizeField.getText());
            out.println("BODY_FONT_SIZE=" + this.bodySizeField.getText());
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public static SettingDialog createSettingDialog(CloudSticky manager, boolean visible) {
        SettingDialog newDialog = new SettingDialog(manager);
        JDialog dialog = null;
        dialog = newDialog.makeDialog(null, true, true, false);
        dialog.getContentPane().add(newDialog);
        dialog.pack();
        dialog.setMinimumSize(dialog.getPreferredSize());
        dialog.setMaximumSize(dialog.getPreferredSize());
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        DisplayMode displayMode = env.getDefaultScreenDevice().getDisplayMode();
        int displayWidth = displayMode.getWidth();
        dialog.setBounds(new Rectangle(displayWidth - dialog.getWidth() - 50, 50, dialog.getWidth(), dialog.getHeight()));
        dialog.setVisible(visible);
        return newDialog;
    }
}

