/*
 * Decompiled with CFR 0.152.
 */
package cloudsticky.gui;

import cloudsticky.CloudSticky;
import cloudsticky.EVNote;
import cloudsticky.gui.ConfirmationDialog;
import cloudsticky.gui.Sticky;
import cloudsticky.gui.StickyColor;
import cloudsticky.gui.StickyPanelTemplate;
import cloudsticky.util.DocumentUtil;
import cloudsticky.util.ValidationErrorHandler;
import com.evernote.edam.type.Note;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.FlowLayout;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.w3c.dom.Document;

public class NoteEditDialog
extends StickyPanelTemplate {
    private static final long serialVersionUID = -9129249826203027996L;
    JTextField titleField;
    ArrayList<JTextField> tagList = new ArrayList();
    JTextArea bodyArea;
    JButton okButton;
    JButton cancelButton;
    Sticky sticky;
    boolean isTextEdit;
    JPanel aPanel = new JPanel();
    JPanel tagPanel = new JPanel();

    public NoteEditDialog(JDialog parent, final Sticky sticky, final CloudSticky manager, final boolean isTextEdit) {
        super("Note Editor", parent);
        this.sticky = sticky;
        this.isTextEdit = isTextEdit;
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String title = NoteEditDialog.this.titleField.getText();
                String content = NoteEditDialog.this.bodyArea.getText();
                if ("".equals(title) && "".equals(content)) {
                    ConfirmationDialog.createConfirmationDialog("Error", "Please input Title or Body.", NoteEditDialog.this.dialog);
                    return;
                }
                if ("".equals(title)) {
                    StringTokenizer st = new StringTokenizer(content, "\n");
                    title = st.nextToken();
                }
                if (sticky == null) {
                    Note note = new Note();
                    note.setTitle(title);
                    note.setCreated(System.currentTimeMillis());
                    note.setUpdated(System.currentTimeMillis());
                    note.setActive(true);
                    note.setContent(content);
                    DocumentUtil.htmlEscape(content);
                    Document doc = DocumentUtil.text2EvnDocument(content);
                    List<String> tags = NoteEditDialog.this.getTags();
                    String content_html = DocumentUtil.evnDoc2HtmlStr(doc);
                    EVNote evn = new EVNote(title, tags, doc, content_html, note, NoteEditDialog.this.TAG, true);
                    evn.editFlag = true;
                    Sticky sticky2 = Sticky.createSticky(manager, evn);
                    manager.newStickyList.add(0, sticky2);
                    manager.arrangeSticky();
                    String escapedString = NoteEditDialog.this.bodyArea.getText();
                    DocumentUtil.htmlEscape(escapedString);
                    sticky2.evn.updateEVNote(title, tags, doc, NoteEditDialog.this.TAG);
                    sticky2.setLabel();
                    sticky2.dialog.pack();
                    NoteEditDialog.this.dialog.getToolkit().getSystemEventQueue().postEvent(new WindowEvent(NoteEditDialog.this.dialog, 201));
                    NoteEditDialog.this.dialog.setVisible(false);
                    NoteEditDialog.this.dialog.dispose();
                    if (!NoteEditDialog.this.getTags().contains(NoteEditDialog.this.TAG)) {
                        sticky2.dialog.setVisible(false);
                        sticky2.hide = true;
                        sticky2.titleLabel.setText("[*]" + sticky2.evn.title);
                    }
                    sticky2.parent.saveCache();
                } else if (isTextEdit) {
                    String escapedString = NoteEditDialog.this.bodyArea.getText();
                    DocumentUtil.htmlEscape(escapedString);
                    Document doc = DocumentUtil.text2EvnDocument(escapedString);
                    List<String> tags = NoteEditDialog.this.getTags();
                    sticky.evn.updateEVNote(title, tags, doc, NoteEditDialog.this.TAG);
                    sticky.setLabel();
                    sticky.dialog.pack();
                    NoteEditDialog.this.dialog.getToolkit().getSystemEventQueue().postEvent(new WindowEvent(NoteEditDialog.this.dialog, 201));
                    NoteEditDialog.this.dialog.setVisible(false);
                    NoteEditDialog.this.dialog.dispose();
                    if (!NoteEditDialog.this.getTags().contains(NoteEditDialog.this.TAG)) {
                        sticky.dialog.setVisible(false);
                        sticky.hide = true;
                        sticky.titleLabel.setText("[*]" + sticky.evn.title);
                    }
                    sticky.parent.saveCache();
                } else {
                    ValidationErrorHandler veh;
                    String docstr = DocumentUtil.appendEvnHeader(NoteEditDialog.this.bodyArea.getText(), false);
                    if (DocumentUtil.checkDomValidation(docstr, veh = new ValidationErrorHandler())) {
                        docstr = DocumentUtil.removeEvnHeader(docstr);
                        Document doc = DocumentUtil.string2Document(docstr);
                        List<String> tags = NoteEditDialog.this.getTags();
                        sticky.evn.updateEVNote(title, tags, doc, NoteEditDialog.this.TAG);
                        sticky.setLabel();
                        sticky.dialog.pack();
                        NoteEditDialog.this.dialog.getToolkit().getSystemEventQueue().postEvent(new WindowEvent(NoteEditDialog.this.dialog, 201));
                        NoteEditDialog.this.dialog.setVisible(false);
                        NoteEditDialog.this.dialog.dispose();
                        if (!NoteEditDialog.this.getTags().contains(NoteEditDialog.this.TAG)) {
                            sticky.dialog.setVisible(false);
                            sticky.hide = true;
                        }
                    } else {
                        String message = "<html><body>Line number: " + veh.lineNumber + "<br/>" + veh.message.replaceAll("<", "&lt;").replaceAll(">", "&gt;") + "</body></html>";
                        ConfirmationDialog.createConfirmationDialog("Format Error", message, NoteEditDialog.this.dialog);
                    }
                    sticky.parent.saveCache();
                }
            }
        });
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NoteEditDialog.this.dialog.getToolkit().getSystemEventQueue().postEvent(new WindowEvent(NoteEditDialog.this.dialog, 201));
                NoteEditDialog.this.dialog.setVisible(false);
                NoteEditDialog.this.dialog.dispose();
            }
        });
        this.titleField = new JTextField(10);
        if (sticky != null) {
            this.titleField.setText(sticky.evn.title);
        }
        this.tagPanel.setBackground(this.bodyColor);
        this.tagPanel.setForeground(this.bodyFontColor);
        this.tagPanel.setLayout(new FlowLayout(0));
        JTextField tagField = new JTextField(this.TAG, 6);
        this.tagPanel.add(tagField);
        this.tagList.add(tagField);
        if (sticky != null) {
            List<String> tagStrList = sticky.evn.tags;
            for (String tag : tagStrList) {
                JTextField tagField2 = new JTextField(tag, 6);
                this.tagPanel.add(tagField2);
                this.tagList.add(tagField2);
            }
        }
        tagField = new JTextField(6);
        this.tagPanel.add(tagField);
        this.tagList.add(tagField);
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BorderLayout());
        titlePanel.add(this.titleField);
        titlePanel.add((Component)this.tagPanel, "South");
        this.bodyArea = new JTextArea(15, 30);
        this.bodyArea.setFont(this.bodyFont);
        if (isTextEdit && sticky != null) {
            this.bodyArea.setText(DocumentUtil.evnDoc2StrWithoutTag(sticky.evn.doc));
        } else if (!isTextEdit && sticky != null) {
            String docstr = DocumentUtil.element2String(sticky.evn.doc.getDocumentElement(), true);
            docstr = DocumentUtil.removeEvnHeader(docstr);
            this.bodyArea.setText(docstr);
        }
        JScrollPane scrollpane = new JScrollPane(this.bodyArea);
        this.add((Component)scrollpane, "Center");
        this.bodyArea.setCaretPosition(0);
        this.aPanel.setBackground(this.bodyColor);
        this.aPanel.setForeground(this.bodyFontColor);
        this.aPanel.setLayout(new BorderLayout());
        this.aPanel.add((Component)this.okButton, "West");
        this.aPanel.add((Component)this.cancelButton, "East");
        this.add((Component)titlePanel, "North");
        this.add((Component)this.aPanel, "South");
    }

    public void setStickyColor(Sticky s) {
        StickyColor c = new StickyColor(s.frameColor, s.tagColor, s.bodyColor, s.titleFontColor, s.tagFontColor, s.bodyFontColor);
        this.setStickyColor(c);
    }

    public void setStickyColor(StickyColor color) {
        this.frameColor = color.titleColor;
        this.tagColor = color.tagColor;
        this.bodyColor = color.bodyColor;
        this.titleFontColor = color.titleFontColor;
        this.tagFontColor = color.tagFontColor;
        this.bodyFontColor = color.bodyFontColor;
    }

    public void paintAll() {
        this.titleLabel.setBackground(this.frameColor);
        this.closeButton.setBackground(this.frameColor);
        this.titleLabel.setForeground(this.titleFontColor);
        this.resizePanel.repaint();
        this.left.setBackground(this.bodyColor);
        this.right.setBackground(this.bodyColor);
        this.bottom.setBackground(this.bodyColor);
        this.bottomright.setBackground(this.bodyColor);
        this.bottomleft.setBackground(this.bodyColor);
        this.tagPanel.setBackground(this.sticky.bodyColor);
        this.tagPanel.setForeground(this.sticky.bodyFontColor);
        this.aPanel.setBackground(this.sticky.bodyColor);
        this.aPanel.setForeground(this.sticky.bodyFontColor);
    }

    public static NoteEditDialog createNoteEditDialog(Sticky sticky, CloudSticky manager, boolean isTextEdit) {
        NoteEditDialog newDialog = null;
        newDialog = sticky == null ? new NoteEditDialog(null, null, manager, isTextEdit) : new NoteEditDialog(sticky.dialog, sticky, manager, isTextEdit);
        JDialog dialog = null;
        dialog = sticky == null ? newDialog.makeDialog(null, true, true, false) : newDialog.makeDialog(sticky.dialog, true, true, false);
        dialog.getContentPane().add(newDialog);
        dialog.setMinimumSize(new Dimension(10, 10));
        dialog.setMaximumSize(new Dimension(200, 150));
        dialog.pack();
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        DisplayMode displayMode = env.getDefaultScreenDevice().getDisplayMode();
        int displayWidth = displayMode.getWidth();
        int displayHeight = displayMode.getHeight();
        if (sticky == null) {
            dialog.setBounds(new Rectangle(displayWidth - dialog.getWidth() - 50, 50, dialog.getWidth(), dialog.getHeight()));
        } else {
            int x = sticky.dialog.getBounds().x + 30;
            int y = sticky.dialog.getBounds().y + 30;
            if (x + dialog.getWidth() + 30 > displayWidth) {
                x = displayWidth - dialog.getWidth() - 30;
            }
            if (x < 50) {
                x = 50;
            }
            if (y + dialog.getHeight() + 30 > displayHeight) {
                y = displayHeight - dialog.getHeight() - 30;
            }
            dialog.setBounds(new Rectangle(x, y, dialog.getWidth(), dialog.getHeight()));
        }
        if (sticky != null) {
            newDialog.setStickyColor(sticky);
            newDialog.paintAll();
        }
        dialog.setVisible(true);
        return newDialog;
    }

    public List<String> getTags() {
        ArrayList<String> tagStrList = new ArrayList<String>();
        for (JTextField tagField : this.tagList) {
            if (tagField.getText().equals("")) continue;
            tagStrList.add(tagField.getText());
        }
        return tagStrList;
    }
}

