/*
 * Decompiled with CFR 0.152.
 */
package cloudsticky.gui;

import cloudsticky.CloudSticky;
import cloudsticky.gui.PopupMenuAppender;
import cloudsticky.gui.StickyPanelTemplate;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class NewAccessTokenDialog
extends StickyPanelTemplate {
    private static final long serialVersionUID = -9129249826203027996L;
    CloudSticky manager;
    JLabel atLabel;
    JTextField atField;
    JButton getButton;
    JButton loginButton;

    public NewAccessTokenDialog(CloudSticky manager) {
        super("CloudSticky", null);
        this.manager = manager;
        this.atLabel = new JLabel("AccessToken\uff1a");
        this.atLabel.setFont(this.bodyFont);
        this.atLabel.setOpaque(true);
        this.atLabel.setBackground(this.bodyColor);
        this.atLabel.setForeground(this.bodyFontColor);
        this.atField = new JTextField("", 30);
        this.atField.addMouseListener(new PopupMenuAppender(this.atField));
        this.atField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewAccessTokenDialog.this.startStickyManager();
            }
        });
        this.getButton = new JButton("Get AccessToken");
        this.getButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Desktop desktop = Desktop.getDesktop();
                try {
                    desktop.browse(new URI(CloudSticky.oauthUrl));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
        });
        this.loginButton = new JButton("Login");
        this.loginButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (NewAccessTokenDialog.this.checkLine()) {
                    NewAccessTokenDialog.this.startStickyManager();
                }
            }
        });
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new GridLayout(1, 1));
        labelPanel.add(this.atLabel);
        JPanel textPanel = new JPanel();
        textPanel.setLayout(new GridLayout(1, 1));
        textPanel.add(this.atField);
        this.add((Component)labelPanel, "West");
        this.add((Component)textPanel, "East");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 2));
        buttonPanel.add(this.getButton);
        buttonPanel.add(this.loginButton);
        this.add((Component)buttonPanel, "South");
    }

    public boolean checkLine() {
        String line = this.atField.getText();
        return line != null && !line.equals("") && line.indexOf("null") == -1;
    }

    public void startStickyManager() {
        String line = this.atField.getText();
        String accessToken = line.substring(0, line.indexOf(":URL="));
        String noteStoreUrl = line.substring(line.indexOf(":URL=") + 5);
        this.dialog.setVisible(false);
        if (this.manager != null) {
            this.manager.init(accessToken, noteStoreUrl);
        }
        this.dialog.dispose();
    }

    public static NewAccessTokenDialog createNewAccessTokenDialog(CloudSticky manager) {
        NewAccessTokenDialog newDialog = new NewAccessTokenDialog(manager);
        JDialog dialog = newDialog.makeDialog(null, false, true, true);
        dialog.getContentPane().add(newDialog);
        dialog.setMinimumSize(new Dimension(100, 100));
        dialog.pack();
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        DisplayMode displayMode = env.getDefaultScreenDevice().getDisplayMode();
        int displayWidth = displayMode.getWidth();
        dialog.setBounds(new Rectangle(displayWidth - dialog.getWidth() - 50, 50, dialog.getWidth(), dialog.getHeight()));
        dialog.setVisible(true);
        return newDialog;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        NewAccessTokenDialog.createNewAccessTokenDialog(null);
    }
}

