/*
 * Decompiled with CFR 0.152.
 */
package cloudsticky.gui;

import cloudsticky.CloudSticky;
import cloudsticky.gui.ChangeButtonActionListener;
import cloudsticky.gui.StickyPanelTemplate;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class LoginDialog
extends StickyPanelTemplate {
    private static final long serialVersionUID = -9129249826203027996L;
    CloudSticky manager;
    JLabel useridLabel;
    JTextField useridField;
    JButton changeButton;
    JButton loginButton;

    public LoginDialog(CloudSticky manager) {
        super("CloudSticky", null);
        this.manager = manager;
        this.useridLabel = new JLabel("UserID\uff1a");
        this.useridLabel.setFont(this.bodyFont);
        this.useridLabel.setOpaque(true);
        this.useridLabel.setBackground(this.bodyColor);
        this.useridLabel.setForeground(this.bodyFontColor);
        this.useridField = new JTextField(manager.username, 18);
        this.useridField.setEnabled(false);
        this.changeButton = new JButton("Change User");
        this.changeButton.addActionListener(new ChangeButtonActionListener(this));
        this.loginButton = new JButton("Login");
        this.loginButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LoginDialog.this.startStickyManager();
            }
        });
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new GridLayout(1, 1));
        labelPanel.add(this.useridLabel);
        JPanel textPanel = new JPanel();
        textPanel.setLayout(new GridLayout(1, 1));
        textPanel.add(this.useridField);
        this.add((Component)labelPanel, "West");
        this.add((Component)textPanel, "East");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 2));
        buttonPanel.add(this.loginButton);
        buttonPanel.add(this.changeButton);
        this.add((Component)buttonPanel, "South");
    }

    public void startStickyManager() {
        try {
            FileInputStream in = new FileInputStream(new File(CloudSticky.iniFile));
            Properties prop = new Properties();
            prop.load(in);
            String accessToken = prop.getProperty("EVERNOTE_ACCESS_TOKEN", "");
            String noteStoreUrl = prop.getProperty("EVERNOTE_URL", "");
            ((InputStream)in).close();
            this.dialog.setVisible(false);
            if (this.manager != null) {
                this.manager.init(accessToken, noteStoreUrl);
            }
            this.dialog.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static LoginDialog createLoginDialog(CloudSticky manager) {
        LoginDialog newDialog = new LoginDialog(manager);
        JDialog dialog = newDialog.makeDialog(null, false, true, true);
        dialog.getContentPane().add(newDialog);
        dialog.setMinimumSize(new Dimension(100, 100));
        dialog.pack();
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        DisplayMode displayMode = env.getDefaultScreenDevice().getDisplayMode();
        int displayWidth = displayMode.getWidth();
        dialog.setBounds(new Rectangle(displayWidth - dialog.getWidth() - 50, 50, dialog.getWidth(), dialog.getHeight()));
        dialog.setVisible(true);
        return newDialog;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LoginDialog.createLoginDialog(null);
    }
}

