/*
 * Decompiled with CFR 0.152.
 */
package cloudsticky.gui;

import cloudsticky.gui.Sticky;
import cloudsticky.gui.StickyPanelTemplate;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class ConflictDialog
extends StickyPanelTemplate {
    private static final long serialVersionUID = 2720232230481942615L;
    public Sticky sticky;
    public JLabel message;
    public JButton serverSide = new JButton("Cloud (Evernote Server)");
    public JButton stickySide = new JButton("Local (Evernote Sticky)");

    public ConflictDialog(Sticky sticky) {
        super("Conflict", null);
        this.sticky = sticky;
        this.message = sticky != null ? new JLabel("<html><body>title: " + sticky.evn.title + "<br/>Please select which to remain.</body></html>") : new JLabel("<html><body>title: null<br/>Please select which to remain.</body></html>");
        this.message.setFont(this.bodyFont);
        this.message.setOpaque(true);
        this.message.setBackground(this.bodyColor);
        this.message.setForeground(this.bodyFontColor);
        JPanel parentPanel = new JPanel();
        parentPanel.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(2, 1));
        panel.setBackground(this.bodyColor);
        panel.setForeground(this.bodyFontColor);
        panel.add(this.serverSide);
        panel.add(this.stickySide);
        parentPanel.add((Component)this.message, "North");
        parentPanel.add(panel);
        this.add(parentPanel);
    }

    public static ConflictDialog createConflictDialog(Sticky sticky) {
        ConflictDialog newDialog = new ConflictDialog(sticky);
        JDialog dialog = newDialog.makeDialog(null, true, true, false);
        dialog.getContentPane().add(newDialog);
        dialog.setMinimumSize(new Dimension(10, 10));
        dialog.setMaximumSize(new Dimension(300, 300));
        dialog.pack();
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        DisplayMode displayMode = env.getDefaultScreenDevice().getDisplayMode();
        int displayWidth = displayMode.getWidth();
        int displayHeight = displayMode.getHeight();
        if (sticky == null) {
            dialog.setBounds(new Rectangle(displayWidth - dialog.getWidth() - 50, 50, dialog.getWidth(), dialog.getHeight()));
        } else {
            int x = sticky.dialog.getBounds().x + 30;
            int y = sticky.dialog.getBounds().y + 30;
            if (x + dialog.getWidth() + 30 > displayWidth) {
                x = displayWidth - dialog.getWidth() - 30;
            }
            if (x < 50) {
                x = 50;
            }
            if (y + dialog.getHeight() + 30 > displayHeight) {
                y = displayHeight - dialog.getHeight() - 30;
            }
            dialog.setBounds(new Rectangle(x, y, dialog.getWidth(), dialog.getHeight()));
        }
        dialog.setVisible(true);
        return newDialog;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ConflictDialog.createConflictDialog(null);
    }
}

