/*
 * Decompiled with CFR 0.152.
 */
package cloudsticky.gui;

import cloudsticky.gui.StickyPanelTemplate;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class ConfirmationDialog
extends StickyPanelTemplate {
    private static final long serialVersionUID = -9129249826203027996L;
    JLabel messageLabel;
    JButton okButton;
    String message;

    public ConfirmationDialog(String title, String message, JDialog parent) {
        super(title, parent);
        this.message = message;
        this.messageLabel = new JLabel(message);
        this.messageLabel.setFont(this.bodyFont);
        this.messageLabel.setOpaque(true);
        this.messageLabel.setBackground(this.bodyColor);
        this.messageLabel.setForeground(this.bodyFontColor);
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfirmationDialog.this.dialog.getToolkit().getSystemEventQueue().postEvent(new WindowEvent(ConfirmationDialog.this.dialog, 201));
                ConfirmationDialog.this.dialog.dispose();
            }
        });
        this.add((Component)this.messageLabel, "Center");
        JPanel aPanel = new JPanel();
        aPanel.setLayout(new BorderLayout());
        aPanel.add(this.okButton);
        this.add((Component)aPanel, "South");
    }

    public static ConfirmationDialog createConfirmationDialog(String title, String message, JDialog parent) {
        ConfirmationDialog newDialog = new ConfirmationDialog(title, message, parent);
        JDialog dialog = newDialog.makeDialog(parent, true, false, false);
        dialog.getContentPane().add(newDialog);
        dialog.setMinimumSize(new Dimension(10, 10));
        dialog.pack();
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        DisplayMode displayMode = env.getDefaultScreenDevice().getDisplayMode();
        int displayWidth = displayMode.getWidth();
        int displayHeight = displayMode.getHeight();
        if (parent != null) {
            int x = parent.getBounds().x + parent.getWidth() / 2 - dialog.getWidth() / 2;
            int y = parent.getBounds().y + parent.getHeight() / 2 - dialog.getHeight() / 2;
            if (x < 30) {
                x = 30;
            }
            if (x + dialog.getWidth() + 30 > displayWidth) {
                x = displayWidth - dialog.getWidth() - 30;
            }
            if (y < 30) {
                y = 30;
            }
            if (y + dialog.getHeight() + 30 > displayHeight) {
                x = displayHeight - dialog.getHeight() - 30;
            }
            dialog.setBounds(new Rectangle(x, y, dialog.getWidth(), dialog.getHeight()));
        }
        dialog.setVisible(true);
        return newDialog;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ConfirmationDialog.createConfirmationDialog("Evernote Login Error", "Please confirm your account.", null);
    }
}

