/*
 * Decompiled with CFR 0.152.
 */
package cloudsticky;

import cloudsticky.CloudSticky;
import cloudsticky.EVNote;
import cloudsticky.gui.Sticky;
import cloudsticky.util.DocumentUtil;
import com.evernote.edam.notestore.NoteFilter;
import com.evernote.edam.notestore.NoteList;
import com.evernote.edam.notestore.SyncState;
import com.evernote.edam.type.Note;
import com.evernote.edam.type.NoteSortOrder;
import com.evernote.edam.type.Notebook;
import com.evernote.edam.type.Tag;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;

public class EvernoteThread
extends Thread {
    public static String SEARCH = "search";
    public static String UPLOAD = "upload";
    CloudSticky manager = null;
    String method = "";

    public EvernoteThread(CloudSticky manager, String method) {
        this.manager = manager;
        this.method = method;
    }

    @Override
    public void run() {
        if (SEARCH.equals(this.method)) {
            try {
                System.out.println("[manager] sync");
                this.searchEvernote();
                this.manager.updateSticky();
                System.out.println("[manager] sync ok.");
            }
            catch (Exception e) {
                System.err.println("[manager] sync failure");
                this.manager.searchFailed();
                e.printStackTrace();
            }
        } else if (UPLOAD.equals(this.method)) {
            try {
                System.out.println("[manager] upload");
                this.uploadNotes();
                System.out.println("[manager] upload ok.");
                this.manager.uploadFinished();
            }
            catch (Exception e) {
                System.err.println("[manager] upload failure");
                this.manager.uploadFailed();
            }
        }
    }

    public void uploadNotes() {
        int currentCount;
        SyncState state;
        List<String> tags;
        Note note;
        ArrayList<Sticky> successList = new ArrayList<Sticky>();
        for (Sticky sticky : this.manager.uploadStickyList) {
            try {
                this.setTagGuids(sticky.evn.note, this.manager.remoteTags);
                note = this.manager.noteStore.updateNote(this.manager.accessToken, sticky.evn.note);
                tags = this.manager.noteStore.getNoteTagNames(this.manager.accessToken, note.getGuid());
                sticky.evn.editFlag = false;
                sticky.titleLabel.setText(sticky.evn.title);
                sticky.evn.note = note;
                sticky.evn.note.setTagNames(tags);
                sticky.evn.tags = new ArrayList<String>(sticky.evn.note.getTagNames());
                sticky.evn.tags.remove(this.manager.TAG);
                sticky.evn.prevEditTime = sticky.evn.note.getUpdated();
                successList.add(sticky);
                System.out.println("[manager] upload ok. title: " + sticky.evn.title);
                state = this.manager.noteStore.getSyncState(this.manager.accessToken);
                this.manager.updateCount = currentCount = state.getUpdateCount();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("[manager] upload failure. title:" + sticky.evn.title);
            }
        }
        for (Sticky sticky : successList) {
            this.manager.uploadStickyList.remove(sticky);
        }
        successList.clear();
        for (Sticky sticky : this.manager.newStickyList) {
            try {
                this.setTagGuids(sticky.evn.note, this.manager.remoteTags);
                note = this.manager.noteStore.createNote(this.manager.accessToken, sticky.evn.note);
                tags = this.manager.noteStore.getNoteTagNames(this.manager.accessToken, note.getGuid());
                sticky.evn.editFlag = false;
                sticky.titleLabel.setText(sticky.evn.title);
                sticky.evn.note = note;
                sticky.evn.note.setTagNames(tags);
                sticky.evn.tags = new ArrayList<String>(sticky.evn.note.getTagNames());
                sticky.evn.tags.remove(this.manager.TAG);
                sticky.evn.prevEditTime = sticky.evn.note.getUpdated();
                successList.add(0, sticky);
                System.out.println("[manager] upload ok. title: " + sticky.evn.title);
                state = this.manager.noteStore.getSyncState(this.manager.accessToken);
                this.manager.updateCount = currentCount = state.getUpdateCount();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("[manager] upload failure. title:" + sticky.evn.title);
            }
        }
        for (Sticky sticky : successList) {
            this.manager.newStickyList.remove(sticky);
            this.manager.stickyList.add(0, sticky);
        }
        this.manager.evnoteList.clear();
        for (Sticky sticky : this.manager.stickyList) {
            this.manager.evnoteList.add(sticky.evn);
        }
    }

    public void searchEvernote() throws Exception {
        SyncState state = this.manager.noteStore.getSyncState(this.manager.accessToken);
        int currentCount = state.getUpdateCount();
        if (this.manager.updateCount < currentCount) {
            this.manager.updateCount = currentCount;
            System.out.println("[manager] Server-side updates are found.");
            this.manager.remoteTags = this.manager.noteStore.listTags(this.manager.accessToken);
            ArrayList<EVNote> newnotes = new ArrayList<EVNote>();
            for (Notebook notebook : this.manager.notebooks) {
                NoteFilter filter = new NoteFilter();
                filter.setOrder(NoteSortOrder.CREATED.getValue());
                filter.setAscending(false);
                filter.setNotebookGuid(notebook.getGuid());
                filter.setWords("tag:" + this.manager.TAG);
                System.out.println("[manager] TAG:" + this.manager.TAG);
                NoteList noteList = this.manager.noteStore.findNotes(this.manager.accessToken, filter, 0, 50);
                List<Note> notes = noteList.getNotes();
                for (Note note : notes) {
                    String guid = note.getGuid();
                    long updateTime = note.getUpdated();
                    EVNote oldNote = this.manager.getEVNoteFromEvnoteList(guid);
                    if (oldNote == null || oldNote.note.getUpdated() < updateTime) {
                        System.out.println("[manager] Found new note:" + note.getTitle());
                        String content = this.manager.noteStore.getNoteContent(this.manager.accessToken, note.getGuid());
                        List<String> tags = this.manager.noteStore.getNoteTagNames(this.manager.accessToken, note.getGuid());
                        Document evndoc = DocumentUtil.string2Document(DocumentUtil.replaceSpaceTag(DocumentUtil.removeEvnHeader(content)));
                        String content_html = DocumentUtil.evnDoc2HtmlStr(evndoc);
                        EVNote evn = new EVNote(note.getTitle(), tags, evndoc, content_html, note, this.manager.TAG, false);
                        newnotes.add(evn);
                        continue;
                    }
                    newnotes.add(oldNote);
                }
            }
            this.manager.evnoteList = newnotes;
        } else {
            System.out.println("[manager] There is no server-side updates.");
        }
    }

    public String getTagGuid(String tagName, List<Tag> tagList) {
        for (Tag tag : tagList) {
            if (!tagName.equals(tag.getName())) continue;
            return tag.getGuid();
        }
        return null;
    }

    public void setTagGuids(Note note, List<Tag> tagList) {
        note.setTagGuids(new ArrayList<String>());
        for (String tagName : note.getTagNames()) {
            String guid = this.getTagGuid(tagName, tagList);
            if (guid == null) continue;
            note.getTagGuids().add(guid);
        }
    }
}

