/*
 * Decompiled with CFR 0.152.
 */
package cloudsticky;

import cloudsticky.DispSwitchThread;
import cloudsticky.EVNote;
import cloudsticky.EvernoteThread;
import cloudsticky.gui.ConfirmationDialog;
import cloudsticky.gui.LoginDialog;
import cloudsticky.gui.NewAccessTokenDialog;
import cloudsticky.gui.NoteEditDialog;
import cloudsticky.gui.SettingDialog;
import cloudsticky.gui.Sticky;
import cloudsticky.util.EncodedProperties;
import cloudsticky.util.StickyProperty;
import cloudsticky.util.SyncMenuActionListener;
import com.evernote.edam.error.EDAMSystemException;
import com.evernote.edam.error.EDAMUserException;
import com.evernote.edam.notestore.NoteStore;
import com.evernote.edam.type.Notebook;
import com.evernote.edam.type.Tag;
import com.evernote.edam.type.User;
import com.evernote.edam.userstore.UserStore;
import java.awt.AWTException;
import java.awt.DisplayMode;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.THttpClient;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class CloudSticky
extends Thread {
    public static String iniFile = "CloudSticky.ini";
    public String TAG = "!";
    public int WIDTH_MAX = 400;
    public int HEIGHT_MAX = 500;
    public int SLEEP_TIME = 900000;
    public int PORT = 34566;
    String userStoreUrl = "https://www.evernote.com/edam/user";
    static final String consumerKey = "kaji66-5169";
    static final String consumerSecret = "aef29e1072475578";
    public static String oauthUrl = "http://cloudstickyauth.appspot.com/index";
    public int updateCount = 0;
    String cacheDirName = "cache";
    public String username;
    boolean toFront = false;
    List<Notebook> notebooks;
    NoteStore.Client noteStore;
    int displayWidth;
    int displayHeight;
    public ArrayList<Sticky> stickyList = new ArrayList();
    public ArrayList<EVNote> evnoteList = new ArrayList();
    public ArrayList<Sticky> uploadStickyList = new ArrayList();
    public ArrayList<Sticky> newStickyList = new ArrayList();
    public static Pattern pattern = Pattern.compile("<.+?>", 32);
    DispSwitchThread socketThread;
    public EvernoteThread evnThread = null;
    public boolean evnInitFlag = false;
    public List<Tag> remoteTags;
    public boolean settingFlag = false;
    public String accessToken;
    public String noteStoreUrl;

    public CloudSticky() {
    }

    public CloudSticky(String username, String password) {
        this.init(username, password);
    }

    public void init(String accessToken, String noteStoreUrl) {
        this.initAWT();
        this.accessToken = accessToken;
        this.noteStoreUrl = noteStoreUrl;
        try {
            this.initProperties();
        }
        catch (Exception e) {
            System.err.println("[ini]Failed to read property file.");
        }
        this.loadCache();
        this.start();
    }

    public void initProperties() {
        EncodedProperties prop2;
        try {
            prop2 = new EncodedProperties();
            prop2.load(iniFile);
            this.WIDTH_MAX = Integer.parseInt(prop2.getProperty("WIDTH_MAX"));
            this.HEIGHT_MAX = Integer.parseInt(prop2.getProperty("HEIGHT_MAX"));
            this.SLEEP_TIME = Integer.parseInt(prop2.getProperty("SLEEP_TIME")) * 1000 * 60;
            this.PORT = Integer.parseInt(prop2.getProperty("PORT", "34566"));
        }
        catch (Exception prop2) {
            // empty catch block
        }
        try {
            prop2 = new EncodedProperties();
            prop2.load(iniFile);
            this.TAG = prop2.getProperty("TAG", "!");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initAWT() {
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        DisplayMode displayMode = env.getDefaultScreenDevice().getDisplayMode();
        this.displayWidth = displayMode.getWidth();
        this.displayHeight = displayMode.getHeight();
        final SystemTray tray = SystemTray.getSystemTray();
        Image image = Toolkit.getDefaultToolkit().getImage("icon.png");
        PopupMenu popup = new PopupMenu();
        final TrayIcon icon = new TrayIcon(image, "CloudSticky", popup);
        icon.setImageAutoSize(true);
        icon.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    CloudSticky.this.addSticky();
                } else if (SwingUtilities.isLeftMouseButton(e)) {
                    CloudSticky.this.switchShowing();
                }
            }
        });
        MenuItem addMenu = new MenuItem("Add Sticky");
        addMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CloudSticky.this.addSticky();
            }
        });
        MenuItem resetMenu = new MenuItem("Reset");
        resetMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CloudSticky.this.resetSticky();
            }
        });
        MenuItem openMenu = new MenuItem("Show All");
        openMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CloudSticky.this.openAllSticky();
            }
        });
        MenuItem hideMenu = new MenuItem("Hide All");
        hideMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CloudSticky.this.hideSticky();
            }
        });
        MenuItem frontMenu = new MenuItem("Switch");
        frontMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CloudSticky.this.switchShowing();
            }
        });
        MenuItem syncMenu = new MenuItem("Sync");
        syncMenu.addActionListener(new SyncMenuActionListener(this));
        MenuItem settingMenu = new MenuItem("Setting");
        settingMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!CloudSticky.this.settingFlag) {
                    CloudSticky.this.settingFlag = true;
                    CloudSticky.this.setting();
                }
            }
        });
        MenuItem exitMenu = new MenuItem("Exit");
        exitMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                tray.remove(icon);
                System.exit(0);
            }
        });
        popup.add(addMenu);
        popup.addSeparator();
        popup.add(openMenu);
        popup.add(hideMenu);
        popup.add(frontMenu);
        popup.add(syncMenu);
        popup.add(resetMenu);
        popup.addSeparator();
        popup.add(settingMenu);
        popup.addSeparator();
        popup.add(exitMenu);
        try {
            tray.add(icon);
        }
        catch (AWTException aWTException) {
            // empty catch block
        }
    }

    public void initEvernote() {
        this.evnInitFlag = false;
        try {
            THttpClient userStoreTrans = new THttpClient(this.userStoreUrl);
            TBinaryProtocol userStoreProt = new TBinaryProtocol((TTransport)userStoreTrans);
            UserStore.Client userStore = new UserStore.Client((TProtocol)userStoreProt, (TProtocol)userStoreProt);
            boolean versionOk = userStore.checkVersion("CloudSticky", (short)1, (short)19);
            if (!versionOk) {
                System.err.println("Incomatible EDAM client protocol version");
                this.evnInitFlag = false;
                return;
            }
            User user = userStore.getUser(this.accessToken);
            this.username = user.getUsername();
            THttpClient noteStoreTrans = new THttpClient(this.noteStoreUrl);
            TBinaryProtocol noteStoreProt = new TBinaryProtocol((TTransport)noteStoreTrans);
            this.noteStore = new NoteStore.Client((TProtocol)noteStoreProt, (TProtocol)noteStoreProt);
            this.notebooks = this.noteStore.listNotebooks(this.accessToken);
            SettingDialog sd = SettingDialog.createSettingDialog(this, false);
            sd.username_S = this.username;
            sd.accessToken_S = this.accessToken;
            sd.noteStoreUrl_S = this.noteStoreUrl;
            sd.saveIniFile();
            sd.dialog.dispose();
            System.out.println("[manager] save user info.");
            this.evnInitFlag = true;
        }
        catch (TTransportException e) {
            e.printStackTrace();
        }
        catch (TException e) {
            e.printStackTrace();
        }
        catch (EDAMUserException e) {
            NewAccessTokenDialog d = NewAccessTokenDialog.createNewAccessTokenDialog(this);
            ConfirmationDialog.createConfirmationDialog("Evernote Login Error!", "<html><body><center><b>Please confirm your Evernote account.</b></center></body></html>", d.dialog);
            e.printStackTrace();
        }
        catch (EDAMSystemException e) {
            e.printStackTrace();
        }
    }

    public void updateDesktopResolution() {
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        DisplayMode displayMode = env.getDefaultScreenDevice().getDisplayMode();
        this.displayWidth = displayMode.getWidth();
        this.displayHeight = displayMode.getHeight();
    }

    @Override
    public void run() {
        while (true) {
            this.syncEvernote();
            try {
                CloudSticky.sleep(this.SLEEP_TIME);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public void updateSticky() {
        int currentHeight = 20;
        int totalNum = 0;
        ArrayList<Sticky> aStickyList = new ArrayList<Sticky>();
        for (Sticky sticky : this.newStickyList) {
            if (sticky.moved) continue;
            int w = sticky.dialog.getBounds().width;
            int h = sticky.dialog.getBounds().height;
            if (sticky.dialog.getBounds().width > this.WIDTH_MAX) {
                w = this.WIDTH_MAX;
            }
            if (sticky.dialog.getBounds().height > this.HEIGHT_MAX) {
                h = this.HEIGHT_MAX;
            }
            sticky.dialog.setBounds(new Rectangle(this.displayWidth - sticky.dialog.getBounds().width - 10, currentHeight, w, h));
            currentHeight = sticky.dialog.getLocation().y + sticky.dialog.getBounds().height + 10;
            sticky.dialog.setVisible(true);
            ++totalNum;
            if (currentHeight <= this.displayHeight) continue;
            currentHeight -= this.displayHeight;
        }
        int i = 0;
        while (i < this.evnoteList.size()) {
            EVNote evn = this.evnoteList.get(i);
            Sticky sticky = this.getSticky(evn);
            if (sticky == null) {
                sticky = Sticky.createSticky(this, evn);
            } else if (sticky.evn.editFlag) {
                this.uploadStickyList.add(sticky);
            } else {
                sticky.setEVNote(evn);
            }
            aStickyList.add(sticky);
            if (!sticky.moved) {
                int w = sticky.dialog.getBounds().width;
                int h = sticky.dialog.getBounds().height;
                if (sticky.dialog.getBounds().width > this.WIDTH_MAX) {
                    w = this.WIDTH_MAX;
                }
                if (sticky.dialog.getBounds().width > this.HEIGHT_MAX) {
                    h = this.HEIGHT_MAX;
                }
                sticky.dialog.setBounds(new Rectangle(this.displayWidth - sticky.dialog.getBounds().width - 10, currentHeight, w, h));
                currentHeight = sticky.dialog.getLocation().y + sticky.dialog.getBounds().height + 10;
                if (!this.stickyList.contains(sticky)) {
                    sticky.dialog.setVisible(true);
                }
            }
            ++totalNum;
            if (currentHeight > this.displayHeight) {
                currentHeight -= this.displayHeight;
            }
            ++i;
        }
        for (Sticky sticky : this.stickyList) {
            if (aStickyList.contains(sticky)) continue;
            sticky.dialog.dispose();
        }
        this.stickyList = aStickyList;
        this.saveCache();
        this.evnThread = null;
        if (this.evnThread == null) {
            this.evnThread = new EvernoteThread(this, EvernoteThread.UPLOAD);
            this.evnThread.start();
        } else {
            System.err.println("[manager] Another thread is running.");
        }
    }

    public Sticky getSticky(EVNote evn) {
        String guid = evn.note.getGuid();
        for (Sticky sticky : this.stickyList) {
            if (!sticky.evn.note.getGuid().equals(guid)) continue;
            return sticky;
        }
        return null;
    }

    public void searchFailed() {
        this.evnThread = null;
        this.evnInitFlag = false;
    }

    public void uploadFailed() {
        this.evnThread = null;
    }

    public void uploadFinished() {
        this.saveCache();
        this.evnThread = null;
    }

    public void openSticky() {
        for (Sticky sticky : this.stickyList) {
            if (sticky.hide) continue;
            sticky.dialog.setVisible(true);
        }
        for (Sticky sticky : this.newStickyList) {
            if (sticky.hide) continue;
            sticky.dialog.setVisible(true);
        }
        this.toFront();
    }

    public void openAllSticky() {
        for (Sticky sticky : this.stickyList) {
            sticky.hide = false;
            sticky.dialog.setVisible(true);
        }
        for (Sticky sticky : this.newStickyList) {
            sticky.hide = false;
            sticky.dialog.setVisible(true);
        }
        this.toFront();
    }

    public void hideSticky() {
        for (Sticky sticky : this.stickyList) {
            sticky.dialog.setVisible(false);
        }
        for (Sticky sticky : this.newStickyList) {
            sticky.dialog.setVisible(false);
        }
    }

    public void toFront() {
        for (Sticky sticky : this.stickyList) {
            sticky.dialog.setAlwaysOnTop(true);
            sticky.dialog.setAlwaysOnTop(false);
        }
        for (Sticky sticky : this.newStickyList) {
            sticky.dialog.setAlwaysOnTop(true);
            sticky.dialog.setAlwaysOnTop(false);
        }
    }

    public void toBackground() {
        for (Sticky sticky : this.stickyList) {
            sticky.dialog.toBack();
        }
        for (Sticky sticky : this.newStickyList) {
            sticky.dialog.toBack();
        }
    }

    public void switchShowing() {
        if (!this.toFront) {
            this.toBackground();
            this.toFront = true;
        } else {
            this.toFront();
            this.toFront = false;
        }
    }

    public void arrangeSticky() {
        int h;
        int w;
        int currentHeight = 20;
        int totalNum = 0;
        for (Sticky sticky : this.newStickyList) {
            if (sticky.moved) continue;
            w = sticky.dialog.getBounds().width;
            h = sticky.dialog.getBounds().height;
            if (sticky.dialog.getBounds().width > this.WIDTH_MAX) {
                w = this.WIDTH_MAX;
            }
            if (sticky.dialog.getBounds().height > this.HEIGHT_MAX) {
                h = this.HEIGHT_MAX;
            }
            sticky.dialog.setBounds(new Rectangle(this.displayWidth - sticky.dialog.getBounds().width - 10, currentHeight, w, h));
            currentHeight = sticky.dialog.getLocation().y + sticky.dialog.getBounds().height + 10;
            sticky.dialog.setVisible(true);
            ++totalNum;
            if (currentHeight <= this.displayHeight) continue;
            currentHeight -= this.displayHeight;
        }
        for (Sticky sticky : this.stickyList) {
            if (sticky.moved) continue;
            w = sticky.dialog.getBounds().width;
            h = sticky.dialog.getBounds().height;
            if (sticky.dialog.getBounds().width > this.WIDTH_MAX) {
                w = this.WIDTH_MAX;
            }
            if (sticky.dialog.getBounds().height > this.HEIGHT_MAX) {
                h = this.HEIGHT_MAX;
            }
            sticky.dialog.setBounds(new Rectangle(this.displayWidth - sticky.dialog.getBounds().width - 10, currentHeight, w, h));
            currentHeight = sticky.dialog.getLocation().y + sticky.dialog.getBounds().height + 10;
            sticky.dialog.setVisible(true);
            ++totalNum;
            if (currentHeight <= this.displayHeight) continue;
            currentHeight -= this.displayHeight;
        }
    }

    public void saveCache() {
        StickyProperty sp;
        ArrayList<StickyProperty> stickyPropertyList = new ArrayList<StickyProperty>();
        for (Sticky sticky : this.stickyList) {
            sp = new StickyProperty(sticky);
            stickyPropertyList.add(sp);
        }
        for (Sticky sticky : this.newStickyList) {
            sp = new StickyProperty(sticky);
            stickyPropertyList.add(sp);
        }
        File cacheDir = new File(this.cacheDirName);
        if (!cacheDir.exists()) {
            cacheDir.mkdir();
        }
        String cacheFileName = String.valueOf(this.username) + ".bin";
        try {
            File cacheFile = new File(cacheDir, cacheFileName);
            FileOutputStream out = new FileOutputStream(cacheFile);
            ObjectOutputStream oout = new ObjectOutputStream(out);
            oout.writeObject(stickyPropertyList);
            oout.close();
            out.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void loadCache() {
        File cacheDir = new File(this.cacheDirName);
        if (!cacheDir.exists()) {
            return;
        }
        String cacheFileName = String.valueOf(this.username) + ".bin";
        try {
            File cacheFile = new File(cacheDir, cacheFileName);
            if (cacheFile.exists()) {
                FileInputStream in = new FileInputStream(cacheFile);
                ObjectInputStream oin = new ObjectInputStream(in);
                ArrayList stickyPropertyList = (ArrayList)oin.readObject();
                oin.close();
                in.close();
                for (StickyProperty stickyProperty : stickyPropertyList) {
                    Sticky newSticky = Sticky.createSticky(this, stickyProperty.evn);
                    if (newSticky.evn.note.getGuid() == null) {
                        this.newStickyList.add(newSticky);
                    } else {
                        this.stickyList.add(newSticky);
                    }
                    newSticky.dialog.setBounds(stickyProperty.bounds);
                    newSticky.dialog.setVisible(!stickyProperty.hide);
                    newSticky.moved = stickyProperty.moved;
                    newSticky.hide = stickyProperty.hide;
                    newSticky.setTransparencyFlag(stickyProperty.trans);
                    newSticky.bodyVisibility = stickyProperty.bodyVisibility;
                    newSticky.setBodyVisibility(newSticky.bodyVisibility);
                    newSticky.setStickyColor(stickyProperty.color);
                    newSticky.paintAll();
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        System.out.println("[manager] cache load");
    }

    public void setting() {
        SettingDialog.createSettingDialog(this, true);
    }

    public static void main(String[] args) throws Exception {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        FileOutputStream fs = null;
        try {
            CloudSticky sm;
            File lockFile = new File("lock");
            lockFile.deleteOnExit();
            fs = new FileOutputStream(lockFile);
            FileChannel fc = fs.getChannel();
            FileLock lock = fc.tryLock();
            if (lock == null) {
                return;
            }
            String accessToken = "";
            String username = "";
            String noteStoreUrl = "";
            try {
                FileInputStream in = new FileInputStream(new File(iniFile));
                Properties prop = new Properties();
                prop.load(in);
                username = prop.getProperty("EVERNOTE_USERNAME", "");
                accessToken = prop.getProperty("EVERNOTE_ACCESS_TOKEN", "");
                noteStoreUrl = prop.getProperty("EVERNOTE_URL", "");
                ((InputStream)in).close();
            }
            catch (Exception in) {
                // empty catch block
            }
            if (accessToken.equals("")) {
                sm = new CloudSticky();
                NewAccessTokenDialog.createNewAccessTokenDialog(sm);
                new DispSwitchThread(sm);
            } else {
                sm = new CloudSticky();
                sm.username = username;
                sm.accessToken = accessToken;
                sm.noteStoreUrl = noteStoreUrl;
                LoginDialog.createLoginDialog(sm);
                new DispSwitchThread(sm);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addSticky() {
        NoteEditDialog.createNoteEditDialog(null, this, true);
    }

    public void resetSticky() {
        this.updateCount = 0;
        System.out.println("[manager] remove cache");
        this.removeCache();
        System.out.println("[manager] clear sticky array");
        this.clearStickyArray();
        this.syncEvernote();
    }

    public void removeCache() {
        File cacheDir = new File(this.cacheDirName);
        if (cacheDir.exists()) {
            File[] files = cacheDir.listFiles();
            int i = 0;
            while (i < files.length) {
                files[i].delete();
                ++i;
            }
        }
    }

    public void redrawSticky() {
        this.clearStickyArray();
        this.loadCache();
    }

    public void clearStickyArray() {
        for (Sticky sticky : this.stickyList) {
            sticky.dialog.dispose();
        }
        for (Sticky sticky : this.newStickyList) {
            sticky.dialog.dispose();
        }
        this.stickyList.clear();
        this.evnoteList.clear();
        this.uploadStickyList.clear();
        this.newStickyList.clear();
    }

    public void syncEvernote() {
        this.updateDesktopResolution();
        try {
            if (!this.evnInitFlag) {
                System.out.println("[manager] Connecting to Evernote server.");
                this.initEvernote();
                if (this.evnInitFlag) {
                    System.out.println("[manager] Connected to Evernote server.");
                } else {
                    System.out.println("[manager] Failed to connecting to Evernote server.");
                }
            }
            if (this.evnInitFlag) {
                if (this.evnThread == null) {
                    this.evnThread = new EvernoteThread(this, EvernoteThread.SEARCH);
                    this.evnThread.start();
                } else {
                    System.out.println("[manager] Another thread is running.");
                }
            }
        }
        catch (Exception ex) {
            System.err.println("[manager] Sync failure");
            ex.printStackTrace();
        }
    }

    public EVNote getEVNoteFromEvnoteList(String guid) {
        if (this.evnoteList == null) {
            return null;
        }
        for (EVNote note : this.evnoteList) {
            String cguid = note.note.getGuid();
            if (!cguid.equals(guid)) continue;
            return note;
        }
        return null;
    }
}

