<?php
// vim: foldmethod=marker
/**
 *	Ethna_Controller.php
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@license	http://www.opensource.org/licenses/bsd-license.php The BSD License
 *	@package	Ethna
 *	@version	$Id: Ethna_Controller.php,v 1.27 2005/01/06 17:44:23 fujimoto Exp $
 */

// {{{ Ethna_Controller
/**
 *	ȥ饯饹
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@access		public
 *	@package	Ethna
 */
class Ethna_Controller
{
	/**#@+
	 *	@access	private
	 */

	/**	@var	string		ץꥱID */
	var $appid = 'ETHNA';

	/**	@var	string		ץꥱ١ǥ쥯ȥ */
	var $base = '';

	/**	@var	string		ץꥱ١URL */
	var	$url = '';

	/**	@var	string		ץꥱDSN(Data Source Name) */
	var $dsn;

	/**	@var	array		ץꥱǥ쥯ȥ */
	var $directory = array(
		'action'		=> 'app/action',
		'etc'			=> 'etc',
		'filter'		=> 'app/filter',
		'locale'		=> 'locale',
		'log'			=> 'log',
		'plugins'		=> array(),
		'template'		=> 'template',
		'template_c'	=> 'tmp',
		'tmp'			=> 'tmp',
		'view'			=> 'app/view',
	);

	/**	@var	array		DB */
	var	$db = array(
		''				=> DB_TYPE_RW,
	);

	/**	@var	array		ĥ */
	var $ext = array(
		'php'			=> 'php',
		'tpl'			=> 'tpl',
	);

	/**	@var	array		饹 */
	var $class = array(
		'class'			=> 'Ethna_ClassFactory',
		'backend'		=> 'Ethna_Backend',
		'config'		=> 'Ethna_Config',
		'db'			=> 'Ethna_DB',
		'error'			=> 'Ethna_ActionError',
		'form'			=> 'Ethna_ActionForm',
		'i18n'			=> 'Ethna_I18N',
		'logger'		=> 'Ethna_Logger',
		'session'		=> 'Ethna_Session',
		'sql'			=> 'Ethna_AppSQL',
		'view'			=> 'Ethna_ViewClass',
	);

	/**	@var	array		ե륿 */
	var $filter = array(
	);

	/**	@var	string		Ѹ */
	var $language;

	/**	@var	string		ƥ¦󥳡ǥ */
	var	$system_encoding;

	/**	@var	string		饤¦󥳡ǥ */
	var	$client_encoding;

	/**	@var	string		饤ȥ */
	var $client_type;

	/**	@var	string	߼¹Υ̾ */
	var	$action_name;

	/**	@var	array	forward */
	var $forward = array();

	/**	@var	array	action */
	var $action = array();

	/**	@var	array	soap action */
	var $soap_action = array();

	/**	@var	array	ץꥱޥ͡ */
	var	$manager = array();

	/**	@var	array	smarty modifier */
	var $smarty_modifier_plugin = array();

	/**	@var	array	smarty function */
	var $smarty_function_plugin = array();

	/**	@var	array	smarty prefilter */
	var $smarty_prefilter_plugin = array();

	/**	@var	array	smarty postfilter */
	var $smarty_postfilter_plugin = array();

	/**	@var	array	smarty outputfilter */
	var $smarty_outputfilter_plugin = array();

	/**	@var	array	ե륿(Ethna_Filter֥Ȥ) */
	var	$filter_chain = array();

	/**	@var	object	Ethna_ClassFactory	饹եȥꥪ֥ */
	var	$class_factory = null;

	/**	@var	object	Ethna_ActionForm	ե४֥ */
	var	$action_form = null;

	/**	@var	object	Ethna_Config		ꥪ֥ */
	var	$config = null;

	/**	@var	object	Ethna_Logger		֥ */
	var	$logger = null;

	/**#@-*/


	/**
	 *	Ethna_Controller饹Υ󥹥ȥ饯
	 *
	 *	@access		public
	 */
	function Ethna_Controller()
	{
		$GLOBALS['controller'] =& $this;
		$this->base = BASE;

		// 饹եȥꥪ֥Ȥ
		$class_factory = $this->class['class'];
		$this->class_factory =& new $class_factory($this, $this->class);

		// 顼ϥɥ
		Ethna::setErrorCallback(array(&$this, 'handleError'));

		// ǥ쥯ȥ̾(Хѥ->Хѥ)
		foreach ($this->directory as $key => $value) {
			if ($key == 'plugins') {
				// Smartyץ饰ǥ쥯ȥǻꤹ
				$tmp = array(SMARTY_DIR . 'plugins');
				foreach (to_array($value) as $elt) {
					if (Ethna_Util::isAbsolute($elt) == false) {
						$tmp[] = $this->base . (empty($this->base) ? '' : '/') . $elt;
					}
				}
				$this->directory[$key] = $tmp;
			} else {
				if (Ethna_Util::isAbsolute($value) == false) {
					$this->directory[$key] = $this->base . (empty($this->base) ? '' : '/') . $value;
				}
			}
		}

		// 
		list($this->language, $this->system_encoding, $this->client_encoding) = $this->_getDefaultLanguage();
		$this->client_type = $this->_getDefaultClientType();

		$this->config =& $this->getConfig();
		$this->dsn = $this->_prepareDSN();
		$this->url = $this->config->get('url');

		// ϳ
		$this->logger =& $this->getLogger();
		$this->logger->begin();

		// Ethnaޥ͡
		$this->_activateEthnaManager();
	}

	/**
	 *	(ߥƥ֤)ȥΥ󥹥󥹤֤
	 *
	 *	@access	public
	 *	@return	object	Ethna_Controller	ȥΥ󥹥
	 *	@static
	 */
	function &getInstance()
	{
		if (isset($GLOBALS['controller'])) {
			return $GLOBALS['controller'];
		} else {
			return null;
		}
	}

	/**
	 *	ץꥱID֤
	 *
	 *	@access	public
	 *	@return	string	ץꥱID
	 */
	function getAppId()
	{
		return ucfirst(strtolower($this->appid));
	}

	/**
	 *	DSN֤
	 *
	 *	@access	public
	 *	@param	string	$type	DB
	 *	@return	string	DSN
	 */
	function getDSN($type = "")
	{
		if (isset($this->dsn[$type]) == false) {
			return null;
		}
		return $this->dsn[$type];
	}

	/**
	 *	DSNλ³³֤
	 *
	 *	@access	public
	 *	@param	string	$type	DB
	 *	@return	bool	true:persistent false:non-persistent(뤤̵)
	 */
	function getDSN_persistent($type = "")
	{
		$key = sprintf("dsn%s_persistent", $type == "" ? "" : "_$type");

		$dsn_persistent = $this->config->get($key);
		if (is_null($dsn_persistent)) {
			return false;
		}
		return $dsn_persistent;
	}

	/**
	 *	ץꥱ١URL֤
	 *
	 *	@access	public
	 *	@return	string	ץꥱ١URL
	 */
	function getURL()
	{
		return $this->url;
	}

	/**
	 *	ץꥱ١ǥ쥯ȥ֤
	 *
	 *	@access	public
	 *	@return	string	ץꥱ١ǥ쥯ȥ
	 */
	function getBasedir()
	{
		return $this->base;
	}

	/**
	 *	饤ȥ/줫ƥץ졼ȥǥ쥯ȥ̾ꤹ
	 *
	 *	@access	public
	 *	@return	string	ƥץ졼ȥǥ쥯ȥ
	 */
	function getTemplatedir()
	{
		$template = $this->getDirectory('template');

		// ̥ǥ쥯ȥ
		if (file_exists($template . '/' . $this->language)) {
			$template .= '/' . $this->language;
		}

		// 饤̥ǥ쥯ȥ(if we need)
		if ($this->client_type == CLIENT_TYPE_MOBILE_AU && file_exists($template . '/au')) {
			$template .= '/au';
		}

		return $template;
	}

	/**
	 *	ǥ쥯ȥ̾ꤹ
	 *
	 *	@access	public
	 *	@return	string	ǥ쥯ȥ
	 */
	function getActiondir()
	{
		return (empty($this->directory['action']) ? ($this->base . (empty($this->base) ? '' : '/')) : ($this->directory['action'] . "/"));
	}

	/**
	 *	ӥ塼ǥ쥯ȥ̾ꤹ
	 *
	 *	@access	public
	 *	@return	string	ǥ쥯ȥ
	 */
	function getViewdir()
	{
		return (empty($this->directory['view']) ? ($this->base . (empty($this->base) ? '' : '/')) : ($this->directory['view'] . "/"));
	}

	/**
	 *	ץꥱǥ쥯ȥ֤
	 *
	 *	@access	public
	 *	@param	string	$key	ǥ쥯ȥ꥿("tmp", "template"...)
	 *	@return	string	$keyбץꥱǥ쥯ȥ(̵꤬null)
	 */
	function getDirectory($key)
	{
		if (isset($this->directory[$key]) == false) {
			return null;
		}
		return $this->directory[$key];
	}

	/**
	 *	DB֤
	 *
	 *	@access	public
	 *	@param	string	$key	DB("r", ...)
	 *	@return	string	$keyбDB(̵꤬null)
	 */
	function getDB($key)
	{
		if (isset($this->db[$key]) == false) {
			return null;
		}
		return $this->db[$key];
	}

	/**
	 *	ץꥱĥ֤
	 *
	 *	@access	public
	 *	@param	string	$key	ĥҥ("php", "tpl"...)
	 *	@return	string	$keyбĥ(̵꤬null)
	 */
	function getExt($key)
	{
		if (isset($this->ext[$key]) == false) {
			return null;
		}
		return $this->ext[$key];
	}

	/**
	 *	饹եȥꥪ֥ȤΥ(R)
	 *
	 *	@access	public
	 *	@return	object	Ethna_ClassFactory	饹եȥꥪ֥
	 */
	function &getClassFactory()
	{
		return $this->class_factory;
	}

	/**
	 *	󥨥顼֥ȤΥ
	 *
	 *	@access	public
	 *	@return	object	Ethna_ActionError	󥨥顼֥
	 */
	function &getActionError()
	{
		return $this->class_factory->getObject('error');
	}

	/**
	 *	եform֥ȤΥ
	 *
	 *	@access	public
	 *	@return	object	Ethna_ActionForm	եform֥
	 */
	function &getActionForm()
	{
		// Ū˥饹եȥѤƤʤ
		return $this->action_form;
	}

	/**
	 *	backend֥ȤΥ
	 *
	 *	@access	public
	 *	@return	object	Ethna_Backend	backend֥
	 */
	function &getBackend()
	{
		return $this->class_factory->getObject('backend');
	}

	/**
	 *	ꥪ֥ȤΥ
	 *
	 *	@access	public
	 *	@return	object	Ethna_Config	ꥪ֥
	 */
	function &getConfig()
	{
		return $this->class_factory->getObject('config');
	}

	/**
	 *	i18n֥ȤΥ(R)
	 *
	 *	@access	public
	 *	@return	object	Ethna_I18N	i18n֥
	 */
	function &getI18N()
	{
		return $this->class_factory->getObject('i18n');
	}

	/**
	 *	֥ȤΥ
	 *
	 *	@access	public
	 *	@return	object	Ethna_Logger		֥
	 */
	function &getLogger()
	{
		return $this->class_factory->getObject('logger');
	}

	/**
	 *	å󥪥֥ȤΥ
	 *
	 *	@access	public
	 *	@return	object	Ethna_Session		å󥪥֥
	 */
	function &getSession()
	{
		return $this->class_factory->getObject('session');
	}

	/**
	 *	SQL֥ȤΥ
	 *
	 *	@access	public
	 *	@return	object	Ethna_AppSQL	SQL֥
	 */
	function &getSQL()
	{
		return $this->class_factory->getObject('sql');
	}

	/**
	 *	ޥ֤͡
	 *
	 *	@access	public
	 *	@return	array	ޥ͡
	 */
	function getManagerList()
	{
		return $this->manager;
	}

	/**
	 *	¹Υ֤̾
	 *
	 *	@access	public
	 *	@return	string	¹Υ̾
	 */
	function getCurrentActionName()
	{
		return $this->action_name;
	}

	/**
	 *	Ѹ
	 *
	 *	@access	public
	 *	@return	array	Ѹ,ƥ२󥳡ǥ̾,饤ȥ󥳡ǥ̾
	 */
	function getLanguage()
	{
		return array($this->language, $this->system_encoding, $this->client_encoding);
	}

	/**
	 *	饤ȥפ
	 *
	 *	@access	public
	 *	@return	int		饤ȥ(CLIENT_TYPE_WWW...)
	 */
	function getClientType()
	{
		return $this->client_type;
	}

	/**
	 *	饤ȥפꤹ
	 *
	 *	@access	public
	 *	@param	int		$client_type	饤ȥ(CLIENT_TYPE_WWW...)
	 */
	function setClientType($client_type)
	{
		$this->client_type = $client_type;
	}

	/**
	 *	ץꥱΥȥݥ
	 *
	 *	@access	public
	 *	@param	string	$class_name		ץꥱ󥳥ȥΥ饹̾
	 *	@param	mixed	$action_name	Υ̾(ά)
	 *	@param	mixed	$fallback_action_name	󤬷Ǥʤä˼¹Ԥ륢̾(ά)
	 *	@static
	 */
	function main($class_name, $action_name = "", $fallback_action_name = "")
	{
		$c =& new $class_name;
		$c->trigger('www', $action_name, $fallback_action_name);
	}

	/**
	 *	ޥɥ饤󥢥ץꥱΥȥݥ
	 *
	 *	@access	public
	 *	@param	string	$class_name		ץꥱ󥳥ȥΥ饹̾
	 *	@param	string	$action_name	¹Ԥ륢̾
	 *	@static
	 */
	function main_CLI($class_name, $action_name)
	{
		$c =& new $class_name;
		$c->action[$action_name] = array();
		$c->trigger('www', $action_name);
	}

	/**
	 *	SOAPץꥱΥȥݥ
	 *
	 *	@access	public
	 *	@param	string	$class_name	ץꥱ󥳥ȥΥ饹̾
	 *	@static
	 */
	function main_SOAP($class_name)
	{
		$c =& new $class_name;
		$c->setClientType(CLIENT_TYPE_SOAP);
		$c->trigger('soap');
	}

	/**
	 *	AMF(Flash Remoting)ץꥱΥȥݥ
	 *
	 *	@access	public
	 *	@param	string	$class_name	ץꥱ󥳥ȥΥ饹̾
	 *	@static
	 */
	function main_AMF($class_name)
	{
		$c =& new $class_name;
		$c->setClientType(CLIENT_TYPE_AMF);
		$c->trigger('amf');
	}

	/**
	 *	ե졼ν򳫻Ϥ
	 *
	 *	@access	public
	 *	@param	strint	$type					(WWW/SOAP/AMF)
	 *	@param	mixed	$default_action_name	Υ̾
	 *	@param	mixed	$fallback_action_name	̾Ǥʤä˼¹Ԥ륢̾
	 *	@return	mixed	0:ｪλ Ethna_Error:顼
	 */
	function trigger($type, $default_action_name = "", $fallback_action_name = "")
	{
		// ե륿
		$this->_createFilterChain();

		// ¹ե륿
		for ($i = 0; $i < count($this->filter_chain); $i++) {
			$this->filter_chain[$i]->preFilter();
		}

		// trigger
		if ($type == 'www') {
			$this->_trigger($default_action_name, $fallback_action_name);
		} else if ($type == 'soap') {
			$this->_trigger_SOAP();
		} else if ($type == 'amf') {
			$this->_trigger_AMF();
		}

		// ¹Ըե륿
		for ($i = count($this->filter_chain) - 1; $i >= 0; $i--) {
			$this->filter_chain[$i]->postFilter();
		}
	}

	/**
	 *	ե졼ν¹Ԥ(WWW)
	 *
	 *	$default_action_name󤬻ꤵ줿硢ǻꤵ줿
	 *	ʳϼդʤ(ʳΥ󤬻ꤵ줿硢
	 *	Ƭǻꤵ줿󤬼¹Ԥ)
	 *
	 *	@access	private
	 *	@param	mixed	$default_action_name	Υ̾
	 *	@param	mixed	$fallback_action_name	̾Ǥʤä˼¹Ԥ륢̾
	 *	@return	mixed	0:ｪλ Ethna_Error:顼
	 */
	function _trigger($default_action_name = "", $fallback_action_name = "")
	{
		// ̾μ
		$action_name = $this->_getActionName($default_action_name, $fallback_action_name);

		// μ
		$action_obj =& $this->_getAction($action_name);
		if (is_null($action_obj)) {
			if ($fallback_action_name != "") {
				$this->logger->log(LOG_DEBUG, 'undefined action [%s] -> try fallback action [%s]', $action_name, $fallback_action_name);
				$action_obj =& $this->_getAction($fallback_action_name);
			}
			if ($action_obj == null) {
				return Ethna::raiseError(E_APP_UNDEFINED_ACTION, "undefined action [%s]", $action_name);
			} else {
				$action_name = $fallback_action_name;
			}
		}

		// ¹ե륿
		for ($i = 0; $i < count($this->filter_chain); $i++) {
			$r = $this->filter_chain[$i]->preActionFilter($action_name);
			if ($r != null) {
				$this->logger->log(LOG_DEBUG, 'action [%s] -> [%s] by %s', $action_name, $r, get_class($this->filter_chain[$i]));
				$action_name = $r;
			}
		}
		$this->action_name = $action_name;

		// 
		$this->_setLanguage($this->language, $this->system_encoding, $this->client_encoding);

		// ֥
		$form_name = $this->getActionFormName($action_name);
		$this->action_form =& new $form_name($this);

		// Хåɽ¹
		$backend =& $this->getBackend();
		$forward_name = $backend->perform($action_name);

		// ¹Ըե륿
		for ($i = count($this->filter_chain) - 1; $i >= 0; $i--) {
			$r = $this->filter_chain[$i]->postActionFilter($action_name, $forward_name);
			if ($r != null) {
				$this->logger->log(LOG_DEBUG, 'forward [%s] -> [%s] by %s', $forward_name, $r, get_class($this->filter_chain[$i]));
				$forward_name = $r;
			}
		}

		// ȥꤹ(ץ)
		$forward_name = $this->_sortForward($action_name, $forward_name);

		if ($forward_name != null) {
			$view_class_name = $this->getViewClassName($forward_name);
			$view_class =& new $view_class_name($backend, $forward_name, $this->_getForwardPath($forward_name));
			$view_class->preforward();

			// ߴ:(
			$view_class_name = $this->class_factory->getObjectName('view');
			if (is_subclass_of($view_class, $view_class_name) == false) {
				$view_class =& new $view_class_name($backend, $forward_name, $this->_getForwardPath($forward_name));
			}
			$view_class->forward();
		}

		return 0;
	}

	/**
	 *  SOAPե졼ν¹Ԥ
	 *
	 *	(experimental)
 	 *
	 *  @access private
	 */
	function _trigger_SOAP()
	{
		// 󥹥ץȤ򥤥󥯥롼
		$this->_includeActionScript();

		// SOAPȥꥯ饹
		$gg =& new Ethna_SoapGatewayGenerator();
		$script = $gg->generate();
		eval($script);

		// SOAPꥯȽ
		$server =& new SoapServer(null, array('uri' => $this->config->get('url')));
		$server->setClass($gg->getClassName());
		$server->handle();
	}

	/**
	 *	AMF(Flash Remoting)ե졼ν¹Ԥ
	 *
	 *	(experimental)
	 *
	 *	@access	public
	 */
	function _trigger_AMF()
	{
		include_once('Ethna/contrib/amfphp/app/Gateway.php');

		// CredentialإåǥåΤǤǤnull
		$this->session = null;

		$this->_setLanguage($this->language, $this->system_encoding, $this->client_encoding);

		// backend֥
		$backend =& $this->getBackend();

		// 󥹥ץȤ򥤥󥯥롼
		$this->_includeActionScript();

		// amfphp˽Ѿ
		$gateway =& new Gateway();
		$gateway->setBaseClassPath('');
		$gateway->service();
	}

	/**
	 *	顼ϥɥ
	 *
	 *	顼ȯɲýԤϤΥ᥽åɤ򥪡С饤ɤ
	 *	(顼ȥ᡼ݥǥեȤǤϥϻ˥顼ȥ᡼
	 *	뤬顼ȯ̤˥顼ȥ᡼򤳤
	 *	뤳Ȥǽ)
	 *
	 *	@access	public
	 *	@param	object	Ethna_Error		顼֥
	 */
	function handleError(&$error)
	{
		// 
		list ($log_level, $dummy) = $this->logger->errorLevelToLogLevel($error->getLevel());
		$message = $error->getMessage();
		$this->logger->log($log_level, sprintf("[APP(%d)] %s", $error->getCode(), $message));
	}

	/**
	 *	顼å
	 *
	 *	@access	public
	 *	@param	int		$code		顼
	 *	@return	string	顼å
	 */
	function getErrorMessage($code)
	{
		$message_list =& $GLOBALS['_Ethna_error_message_list'];
		for ($i = count($message_list)-1; $i >= 0; $i--) {
			if (array_key_exists($code, $message_list[$i])) {
				return $message_list[$i][$code];
			}
		}
		return null;
	}

	/**
	 *	¹Ԥ륢֤̾
	 *
	 *	@access	private
	 *	@param	mixed	$default_action_name	Υ̾
	 *	@return	string	¹Ԥ륢̾
	 */
	function _getActionName($default_action_name, $fallback_action_name)
	{
		// եफ׵ᤵ줿̾
		$form_action_name = $this->_getActionName_Form();
		$form_action_name = preg_replace('/[^a-z0-9\-_]+/i', '', $form_action_name);
		$this->logger->log(LOG_DEBUG, 'form_action_name[%s]', $form_action_name);

		// Ethnaޥ͡ؤΥեफΥꥯȤϵ
		if ($form_action_name == "__ethna_info__") {
			$form_action_name = "";
		}

		// եफλ̵꤬ϥȥݥȤ˻ꤵ줿ǥեͤѤ
		if ($form_action_name == "" && count($default_action_name) > 0) {
			$tmp = is_array($default_action_name) ? $default_action_name[0] : $default_action_name;
			if ($tmp{strlen($tmp)-1} == '*') {
				$tmp = substr($tmp, 0, -1);
			}
			$this->logger->log(LOG_DEBUG, '-> default_action_name[%s]', $tmp);
			$action_name = $tmp;
		} else {
			$action_name = $form_action_name;
		}

		// ȥݥȤ󤬻ꤵƤϻʳΥ̾ϵݤ
		if (is_array($default_action_name)) {
			if ($this->_isAcceptableActionName($action_name, $default_action_name) == false) {
				// ʳΥ̾ǹä$fallback_action_name(or ǥե)
				$tmp = $fallback_action_name != "" ? $fallback_action_name : $default_action_name[0];
				if ($tmp{strlen($tmp)-1} == '*') {
					$tmp = substr($tmp, 0, -1);
				}
				$this->logger->log(LOG_DEBUG, '-> fallback_action_name[%s]', $tmp);
				$action_name = $tmp;
			}
		}

		$this->logger->log(LOG_DEBUG, '<<< action_name[%s] >>>', $action_name);

		return $action_name;
	}

	/**
	 *	եˤ׵ᤵ줿֤̾
	 *
	 *	ץꥱ˱ƤΥ᥽åɤ򥪡С饤ɤƲ
	 *	ǥեȤǤ"action_"ǻϤޤեͤ"action_"ʬ
	 *	("action_sample"ʤ"sample")̾Ȥưޤ
	 *
	 *	@access	protected
	 *	@return	string	եˤ׵ᤵ줿̾
	 */
	function _getActionName_Form()
	{
		if (isset($_SERVER['REQUEST_METHOD']) == false) {
			return null;
		}

		if (strcasecmp($_SERVER['REQUEST_METHOD'], 'post') == 0) {
			$http_vars =& $_POST;
		} else {
			$http_vars =& $_GET;
		}

		// եͤꥯȤ줿̾
		$action_name = $sub_action_name = null;
		foreach ($http_vars as $name => $value) {
			if ($value == "" || strncmp($name, 'action_', 7) != 0) {
				continue;
			}

			$tmp = substr($name, 7);

			// type="image"б
			if (preg_match('/_x$/', $name) || preg_match('/_y$/', $name)) {
				$tmp = substr($tmp, 0, strlen($tmp)-2);
			}

			// value="dummy"ȤʤäƤΤͥ٤򲼤
			if ($value == "dummy") {
				$sub_action_name = $tmp;
			} else {
				$action_name = $tmp;
			}
		}
		if ($action_name == null) {
			$action_name = $sub_action_name;
		}

		return $action_name;
	}

	/**
	 *	եˤ׵ᤵ줿̾б֤
	 *
	 *	@access	private
	 *	@param	string	$action_name	̾
	 *	@return	array	
	 */
	function &_getAction($action_name)
	{
		if ($this->client_type == CLIENT_TYPE_SOAP) {
			$action =& $this->soap_action;
		} else {
			$action =& $this->action;
		}

		$action_obj = array();
		if (isset($action[$action_name])) {
			$action_obj = $action[$action_name];
			if (isset($action_obj['inspect']) && $action_obj['inspect']) {
				return $action_obj;
			}
		} else {
			$this->logger->log(LOG_DEBUG, "action [%s] is not defined -> try default", $action_name);
		}

		// 󥹥ץȤΥ󥯥롼
		$this->_includeActionScript($action_obj, $action_name);

		// άͤ
		if (isset($action_obj['class_name']) == false) {
			$action_obj['class_name'] = $this->getDefaultActionClass($action_name);
		}

		if (isset($action_obj['form_name']) == false) {
			$action_obj['form_name'] = $this->getDefaultFormClass($action_name);
		} else if (class_exists($action_obj['form_name']) == false) {
			// ꤵ줿ե९饹ƤʤϷٹ
			$this->logger->log(LOG_WARNING, 'stated form class is not defined [%s]', $action_obj['form_name']);
		}

		// ɬ׾γǧ
		if (class_exists($action_obj['class_name']) == false) {
			$this->logger->log(LOG_WARNING, 'action class is not defined [%s]', $action_obj['class_name']);
			return null;
		}
		if (class_exists($action_obj['form_name']) == false) {
			// ե९饹̤Ǥɤ
			$class_name = $this->class_factory->getObjectName('form');
			$this->logger->log(LOG_DEBUG, 'form class is not defined [%s] -> falling back to default [%s]', $action_obj['form_name'], $class_name);
			$action_obj['form_name'] = $class_name;
		}

		$action_obj['inspect'] = true;
		$action[$action_name] = $action_obj;
		return $action[$action_name];
	}

	/**
	 *	̾ȥ󥯥饹ͤ˴Ťꤹ
	 *
	 *	@access	protected
	 *	@param	string	$action_name	̾
	 *	@param	string	$retval			󥯥饹
	 *	@return	string	
	 */
	function _sortForward($action_name, $retval)
	{
		return $retval;
	}

	/**
	 *	ե륿
	 *
	 *	@access	private
	 */
	function _createFilterChain()
	{
		$this->filter_chain = array();
		foreach ($this->filter as $filter) {
			$file = sprintf("%s/%s.%s", $this->getDirectory('filter'), $filter, $this->getExt('php'));
			if (file_exists($file)) {
				include_once($file);
			}
			if (class_exists($filter)) {
				$this->filter_chain[] =& new $filter($this);
			}
		}
	}

	/**
	 *	̾¹ԵĤƤΤɤ֤
	 *
	 *	@access	private
	 *	@param	string	$action_name			ꥯȤ줿̾
	 *	@param	array	$default_action_name	ĤƤ륢̾
	 *	@return	bool	true: false:Ե
	 */
	function _isAcceptableActionName($action_name, $default_action_name)
	{
		foreach (to_array($default_action_name) as $name) {
			if ($action_name == $name) {
				return true;
			} else if ($name{strlen($name)-1} == '*') {
				if (strncmp($action_name, substr($name, 0, -1), strlen($name)-1) == 0) {
					return true;
				}
			}
		}
		return false;
	}

	/**
	 *	ꤵ줿Υե९饹֤̾(֥ȤϹԤʤ)
	 *
	 *	@access	public
	 *	@param	string	$action_name	̾
	 *	@return	string	Υե९饹̾
	 */
	function getActionFormName($action_name)
	{
		$action_obj =& $this->_getAction($action_name);
		if (is_null($action_obj)) {
			return null;
		}

		return $action_obj['form_name'];
	}

	/**
	 *	бե९饹̾ά줿Υǥեȥ饹֤̾
	 *
	 *	ǥեȤǤ[ץID]_Form_[̾]ȤʤΤǹ߱ƥХ饤ɤ
	 *
	 *	@access	public
	 *	@param	string	$action_name	̾
	 *	@param	bool	$fallback		饤ȼ̤ˤfallback on/off
	 *	@return	string	ե̾
	 */
	function getDefaultFormClass($action_name, $fallback = true)
	{
		$postfix = preg_replace('/_(.)/e', "strtoupper('\$1')", ucfirst($action_name));

		$r = null;
		if ($this->getClientType() == CLIENT_TYPE_SOAP) {
			$r = sprintf("%s_SOAPForm_%s", $this->getAppId(), $postfix);
		} else if ($this->getClientType() == CLIENT_TYPE_MOBILE_AU) {
			$tmp = sprintf("%s_MobileAUForm_%s", $this->getAppId(), $postfix);
			if ($fallback == false || class_exists($tmp)) {
				$r = $tmp;
			}
		}

		if ($r == null) {
			$r = sprintf("%s_Form_%s", $this->getAppId(), $postfix);
		}
		$this->logger->log(LOG_DEBUG, "default action class [%s]", $r);
		return $r;
	}

	/**
	 *	getDefaultFormClass()Ǽ饹̾饢̾
	 *
	 *	getDefaultFormClass()򥪡С饤ɤ硢碌ƥС饤
	 *	뤳Ȥ侩(ɬܤǤϤʤ)
	 *
	 *	@access	public
	 *	@param	string	$class_name		ե९饹̾
	 *	@return	string	̾
	 */
	function actionFormToName($class_name)
	{
		$prefix = sprintf("%s_Form_", $this->getAppId());
		if (preg_match("/$prefix(.*)/", $class_name, $match) == 0) {
			// ʥ饹̾
			return null;
		}
		$target = $match[1];

		$action_name = substr(preg_replace('/([A-Z])/e', "'_' . strtolower('\$1')", $target), 1);

		return $action_name;
	}

	/**
	 *	бեѥ̾ά줿Υǥեȥѥ֤̾
	 *
	 *	ǥեȤǤ_getDefaultActionPath()Ʊ̤֤(1ե
	 *	󥯥饹ȥե९饹Ҥ)Τǡߤ˱
	 *	С饤ɤ
	 *
	 *	@access	public
	 *	@param	string	$action_name	̾
	 *	@param	bool	$fallback		饤ȼ̤ˤfallback on/off
	 *	@return	string	form class륹ץȤΥѥ̾
	 */
	function getDefaultFormPath($action_name, $fallback = true)
	{
		return $this->getDefaultActionPath($action_name, $fallback);
	}

	/**
	 *	ꤵ줿Υ饹֤̾(֥ȤϹԤʤ)
	 *
	 *	@access	public
	 *	@param	string	$action_name	̾
	 *	@return	string	Υ饹̾
	 */
	function getActionClassName($action_name)
	{
		$action_obj =& $this->_getAction($action_name);
		if ($action_obj == null) {
			return null;
		}

		return $action_obj['class_name'];
	}

	/**
	 *	б륢󥯥饹̾ά줿Υǥեȥ饹֤̾
	 *
	 *	ǥեȤǤ[ץID]_Action_[̾]ȤʤΤǹ߱ƥХ饤ɤ
	 *
	 *	@access	public
	 *	@param	string	$action_name	̾
	 *	@param	bool	$fallback		饤ȼ̤ˤfallback on/off
	 *	@return	string	󥯥饹̾
	 */
	function getDefaultActionClass($action_name, $fallback = true)
	{
		$postfix = preg_replace('/_(.)/e', "strtoupper('\$1')", ucfirst($action_name));

		$r = null;
		if ($this->getClientType() == CLIENT_TYPE_SOAP) {
			$r = sprintf("%s_SOAPAction_%s", $this->getAppId(), $postfix);
		} else if ($this->getClientType() == CLIENT_TYPE_MOBILE_AU) {
			$tmp = sprintf("%s_MobileAUAction_%s", $this->getAppId(), $postfix);
			if ($fallback == false || class_exists($tmp)) {
				$r = $tmp;
			}
		}

		if ($r == null) {
			$r = sprintf("%s_Action_%s", $this->getAppId(), $postfix);
		}
		$this->logger->log(LOG_DEBUG, "default action class [%s]", $r);
		return $r;
	}

	/**
	 *	getDefaultActionClass()Ǽ饹̾饢̾
	 *
	 *	getDefaultActionClass()򥪡С饤ɤ硢碌ƥС饤
	 *	뤳Ȥ侩(ɬܤǤϤʤ)
	 *
	 *	@access	public
	 *	@param	string	$class_name		󥯥饹̾
	 *	@return	string	̾
	 */
	function actionClassToName($class_name)
	{
		$prefix = sprintf("%s_Action_", $this->getAppId());
		if (preg_match("/$prefix(.*)/", $class_name, $match) == 0) {
			// ʥ饹̾
			return null;
		}
		$target = $match[1];

		$action_name = substr(preg_replace('/([A-Z])/e', "'_' . strtolower('\$1')", $target), 1);

		return $action_name;
	}

	/**
	 *	б륢ѥ̾ά줿Υǥեȥѥ֤̾
	 *
	 *	ǥեȤǤ"foo_bar" -> "/Foo/Bar.php"ȤʤΤǹ߱ƥС饤ɤ
	 *
	 *	@access	public
	 *	@param	string	$action_name	̾
	 *	@param	bool	$fallback		饤ȼ̤ˤfallback on/off
	 *	@return	string	󥯥饹륹ץȤΥѥ̾
	 */
	function getDefaultActionPath($action_name, $fallback = true)
	{
		$default_path = preg_replace('/_(.)/e', "'/' . strtoupper('\$1')", ucfirst($action_name)) . '.' . $this->getExt('php');
		$action_dir = $this->getActiondir();

		if ($this->getClientType() == CLIENT_TYPE_SOAP) {
			$r = 'SOAP/' . $default_path;
		} else if ($this->getClientType() == CLIENT_TYPE_MOBILE_AU) {
			$r = 'MobileAU/' . $default_path;
		} else {
			$r = $default_path;
		}

		if ($fallback && file_exists($action_dir . $r) == false && $r != $default_path) {
			$this->logger->log(LOG_DEBUG, 'client_type specific file not found [%s] -> try defualt', $r);
			$r = $default_path;
		}

		$this->logger->log(LOG_DEBUG, "default action path [%s]", $r);
		return $r;
	}

	/**
	 *	ꤵ줿̾бӥ塼饹֤̾(֥ȤϹԤʤ)
	 *
	 *	@access	public
	 *	@param	string	$forward_name	̾
	 *	@return	string	view classΥ饹̾
	 */
	function getViewClassName($forward_name)
	{
		if ($forward_name == null) {
			return null;
		}

		if (isset($this->forward[$forward_name])) {
			$forward_obj = $this->forward[$forward_name];
		} else {
			$forward_obj = array();
		}

		if (isset($forward_obj['view_name'])) {
			$class_name = $forward_obj['view_name'];
			if (class_exists($class_name)) {
				return $class_name;
			}
		} else {
			$class_name = null;
		}

		// viewΥ󥯥롼
		$this->_includeViewScript($forward_obj, $forward_name);

		if (is_null($class_name) == false && class_exists($class_name)) {
			return $class_name;
		} else if (is_null($class_name) == false) {
			$this->logger->log(LOG_WARNING, 'stated view class is not defined [%s] -> try default', $class_name);
		}

		$class_name = $this->getDefaultViewClass($forward_name);
		if (class_exists($class_name)) {
			return $class_name;
		} else {
			$class_name = $this->class_factory->getObjectName('view');
			$this->logger->log(LOG_DEBUG, 'view class is not defined for [%s] -> use default [%s]', $forward_name, $class_name);
			return $class_name;
		}
	}

	/**
	 *	̾бӥ塼饹̾ά줿Υǥեȥ饹֤̾
	 *
	 *	ǥեȤǤ[ץID]_View_[̾]ȤʤΤǹ߱ƥХ饤ɤ
	 *
	 *	@access	public
	 *	@param	string	$forward_name	forward̾
	 *	@param	bool	$fallback		饤ȼ̤ˤfallback on/off
	 *	@return	string	view class饹̾
	 */
	function getDefaultViewClass($forward_name, $fallback = true)
	{
		$postfix = preg_replace('/_(.)/e', "strtoupper('\$1')", ucfirst($forward_name));

		$r = null;
		if ($this->getClientType() == CLIENT_TYPE_MOBILE_AU) {
			$tmp = sprintf("%s_MobileAUView_%s", $this->getAppId(), $postfix);
			if ($fallback == false || class_exists($tmp)) {
				$r = $tmp;
			}
		}

		if ($r == null) {
			$r = sprintf("%s_View_%s", $this->getAppId(), $postfix);
		}
		$this->logger->log(LOG_DEBUG, "default view class [%s]", $r);
		return $r;
	}

	/**
	 *	̾бӥ塼ѥ̾ά줿Υǥեȥѥ֤̾
	 *
	 *	ǥեȤǤ"foo_bar" -> "/Foo/Bar.php"ȤʤΤǹ߱ƥС饤ɤ
	 *
	 *	@access	public
	 *	@param	string	$forward_name	forward̾
	 *	@param	bool	$fallback		饤ȼ̤ˤfallback on/off
	 *	@return	string	view class륹ץȤΥѥ̾
	 */
	function getDefaultViewPath($forward_name, $fallback = true)
	{
		$default_path = preg_replace('/_(.)/e', "'/' . strtoupper('\$1')", ucfirst($forward_name)) . '.' . $this->getExt('php');
		$view_dir = $this->getViewdir();

		if ($this->getClientType() == CLIENT_TYPE_MOBILE_AU) {
			$r = 'MobileAU/' . $r;
		} else {
			$r = $default_path;
		}

		if ($fallback && file_exists($view_dir . $r) == false && $r != $default_path) {
			$this->logger->log(LOG_DEBUG, 'client_type specific file not found [%s] -> try defualt', $r);
			$r = $default_path;
		}

		$this->logger->log(LOG_DEBUG, "default view path [%s]", $r);
		return $r;
	}

	/**
	 *	̾бƥץ졼ȥѥ̾ά줿Υǥեȥѥ֤̾
	 *
	 *	ǥեȤǤ"foo_bar"Ȥforward̾"foo/bar" + ƥץ졼ȳĥҤȤʤ
	 *	Τǹ߱ƥХ饤ɤ
	 *
	 *	@access	public
	 *	@param	string	$forward_name	forward̾
	 *	@return	string	forwardѥ̾
	 */
	function getDefaultForwardPath($forward_name)
	{
		return str_replace('_', '/', $forward_name) . '.' . $this->ext['tpl'];
	}
	
	/**
	 *	ƥץ졼ȥѥ̾̾
	 *
	 *	getDefaultForwardPath()򥪡С饤ɤ硢碌ƥС饤
	 *	뤳Ȥ侩(ɬܤǤϤʤ)
	 *
	 *	@access	public
	 *	@param	string	$forward_path	ƥץ졼ȥѥ̾
	 *	@return	string	̾
	 */
	function forwardPathToName($forward_path)
	{
		$forward_path = preg_replace('/^\/+/', '', $forward_path);
		$forward_path = preg_replace(sprintf('/\.%s$/', $this->getExt('tpl')), '', $forward_path);

		return str_replace('/', '_', $forward_path);
	}

	/**
	 *	̾ƥץ졼ȥեΥѥ̾
	 *
	 *	@access	private
	 *	@param	string	$forward_name	forward̾
	 *	@return	string	ƥץ졼ȥեΥѥ̾
	 */
	function _getForwardPath($forward_name)
	{
		$forward_obj = null;

		if (isset($this->forward[$forward_name]) == false) {
			// try default
			$this->forward[$forward_name] = array();
		}
		$forward_obj =& $this->forward[$forward_name];
		if (isset($forward_obj['forward_path']) == false) {
			// ά
			$forward_obj['forward_path'] = $this->getDefaultForwardPath($forward_name);
		}

		return $forward_obj['forward_path'];
	}

	/**
	 *	ƥץ졼ȥ󥸥(ߤsmartyΤб)
	 *
	 *	@access	public
	 *	@return	object	Smarty	ƥץ졼ȥ󥸥󥪥֥
	 *	@todo	֥åؿץ饰(etc)б
	 */
	function &getTemplateEngine()
	{
		$smarty =& new Smarty();
		$smarty->template_dir = $this->getTemplatedir();
		$smarty->compile_dir = $this->getDirectory('template_c') . '/tpl_' . md5($smarty->template_dir);
		if (@is_dir($smarty->compile_dir) == false) {
			mkdir($smarty->compile_dir, 0755);
		}
		$smarty->plugins_dir = $this->getDirectory('plugins');

		// default modifiers
		$smarty->register_modifier('number_format', 'smarty_modifier_number_format');
		$smarty->register_modifier('strftime', 'smarty_modifier_strftime');
		$smarty->register_modifier('count', 'smarty_modifier_count');
		$smarty->register_modifier('join', 'smarty_modifier_join');
		$smarty->register_modifier('filter', 'smarty_modifier_filter');
		$smarty->register_modifier('unique', 'smarty_modifier_unique');
		$smarty->register_modifier('wordwrap_i18n', 'smarty_modifier_wordwrap_i18n');
		$smarty->register_modifier('i18n', 'smarty_modifier_i18n');
		$smarty->register_modifier('checkbox', 'smarty_modifier_checkbox');
		$smarty->register_modifier('select', 'smarty_modifier_select');
		$smarty->register_modifier('form_value', 'smarty_modifier_form_value');

		// user defined modifiers
		foreach ($this->smarty_modifier_plugin as $modifier) {
			$name = str_replace('smarty_modifier_', '', $modifier);
			$smarty->register_modifier($name, $modifier);
		}

		// default functions
		$smarty->register_function('is_error', 'smarty_function_is_error');
		$smarty->register_function('message', 'smarty_function_message');
		$smarty->register_function('uniqid', 'smarty_function_uniqid');
		$smarty->register_function('select', 'smarty_function_select');
		$smarty->register_function('checkbox_list', 'smarty_function_checkbox_list');

		// user defined functions
		foreach ($this->smarty_function_plugin as $function) {
			$name = str_replace('smarty_function_', '', $function);
			$smarty->register_function($name, $function);
		}

		// user defined prefilters
		foreach ($this->smarty_prefilter_plugin as $prefilter) {
			$smarty->register_prefilter($prefilter);
		}

		// user defined postfilters
		foreach ($this->smarty_postfilter_plugin as $postfilter) {
			$smarty->register_postfilter($postfilter);
		}

		// user defined outputfilters
		foreach ($this->smarty_outputfilter_plugin as $outputfilter) {
			$smarty->register_outputfilter($outputfilter);
		}

		$this->_setDefaultTemplateEngine($smarty);

		return $smarty;
	}

	/**
	 *  ƥץ졼ȥ󥸥ΥǥեȾ֤ꤹ
	 *
	 *  @access protected
	 *  @param  object  Smarty  $smarty ƥץ졼ȥ󥸥󥪥֥
	 */
	function _setDefaultTemplateEngine(&$smarty)
	{
	}

	/**
	 *	Ѹꤹ
	 *
	 *	ؤγĥΤΤߤ¸ߤƤޤߤä˥С饤ɤɬפϤޤ
	 *
	 *	@access	protected
	 *	@param	string	$language			(LANG_JA, LANG_EN...)
	 *	@param	string	$system_encoding	ƥ२󥳡ǥ̾
	 *	@param	string	$client_encoding	饤ȥ󥳡ǥ
	 */
	function _setLanguage($language, $system_encoding = null, $client_encoding = null)
	{
		$this->language = $language;
		$this->system_encoding = $system_encoding;
		$this->client_encoding = $client_encoding;

		$i18n =& $this->getI18N();
		$i18n->setLanguage($language, $system_encoding, $client_encoding);
	}

	/**
	 *	ǥեȾ֤ǤλѸ
	 *
	 *	@access	protected
	 *	@return	array	Ѹ,ƥ२󥳡ǥ̾,饤ȥ󥳡ǥ̾
	 */
	function _getDefaultLanguage()
	{
		return array(LANG_JA, null, null);
	}

	/**
	 *	ǥեȾ֤ǤΥ饤ȥפ
	 *
	 *	@access	protected
	 *	@return	int		饤ȥ(CLIENT_TYPE_WWW...)
	 */
	function _getDefaultClientType()
	{
		if (is_null($GLOBALS['_Ethna_client_type']) == false) {
			return $GLOBALS['_Ethna_client_type'];
		}
		return CLIENT_TYPE_WWW;
	}

	/**
	 *	ޥ͡㥯饹̾
	 *
	 *	@access	public
	 *	@param	string	$name	ޥ̾͡
	 *	@return	string	ޥ͡㥯饹̾
	 */
	function getManagerClassName($name)
	{
		return sprintf('%s_%sManager', $this->getAppId(), ucfirst($name));
	}

	/**
	 *	󥹥ץȤ򥤥󥯥롼ɤ
	 *
	 *	󥯥롼ɤե˥饹Ƥ뤫ɤݾڤʤ
	 *
	 *	@access	private
	 *	@param	array	$action_obj		
	 *	@param	string	$action_name	̾
	 */
	function _includeActionScript($action_obj, $action_name)
	{
		$class_path = $form_path = null;

		$action_dir = $this->getActiondir();

		// class_path°å
		if (isset($action_obj['class_path'])) {
			// եѥꥵݡ
			$tmp_path = $action_obj['class_path'];
			if (Ethna_Util::isAbsolute($tmp_path) == false) {
				$tmp_path = $action_dir . $tmp_path;
			}

			if (file_exists($tmp_path) == false) {
				$this->logger->log(LOG_WARNING, 'class_path file not found [%s] -> try default', $tmp_path);
			} else {
				include_once($tmp_path);
				$class_path = $tmp_path;
			}
		}

		// ǥեȥå
		if (is_null($class_path)) {
			$class_path = $this->getDefaultActionPath($action_name);
			if (file_exists($action_dir . $class_path)) {
				include_once($action_dir . $class_path);
			} else {
				$this->logger->log(LOG_DEBUG, 'default action file not found [%s] -> try all files', $class_path);
				$class_path = null;
			}
		}
		
		// ե륤󥯥롼
		if (is_null($class_path)) {
			$this->_includeDirectory($this->getActiondir());
			return;
		}

		// form_path°å
		if (isset($action_obj['form_path'])) {
			// եѥꥵݡ
			$tmp_path = $action_obj['class_path'];
			if (Ethna_Util::isAbsolute($tmp_path) == false) {
				$tmp_path = $action_dir . $tmp_path;
			}

			if ($tmp_path == $class_path) {
				return;
			}
			if (file_exists($tmp_path) == false) {
				$this->logger->log(LOG_WARNING, 'form_path file not found [%s] -> try default', $tmp_path);
			} else {
				include_once($tmp_path);
				$form_path = $tmp_path;
			}
		}

		// ǥեȥå
		if (is_null($form_path)) {
			$form_path = $this->getDefaultFormPath($action_name);
			if ($form_path == $class_path) {
				return;
			}
			if (file_exists($action_dir . $form_path)) {
				include_once($action_dir . $form_path);
			} else {
				$this->logger->log(LOG_DEBUG, 'default form file not found [%s] -> maybe falling back to default form class', $form_path);
			}
		}
	}

	/**
	 *	ӥ塼ץȤ򥤥󥯥롼ɤ
	 *
	 *	󥯥롼ɤե˥饹Ƥ뤫ɤݾڤʤ
	 *
	 *	@access	private
	 *	@param	array	$forward_obj	
	 *	@param	string	$forward_name	̾
	 */
	function _includeViewScript($forward_obj, $forward_name)
	{
		$view_dir = $this->getViewdir();

		// view_path°å
		if (isset($forward_obj['view_path'])) {
			// եѥꥵݡ
			$tmp_path = $forward_obj['view_path'];
			if (Ethna_Util::isAbsolute($tmp_path) == false) {
				$tmp_path = $view_dir . $tmp_path;
			}

			if (file_exists($tmp_path) == false) {
				$this->logger->log(LOG_WARNING, 'view_path file not found [%s] -> try default', $tmp_path);
			} else {
				include_once($tmp_path);
				return;
			}
		}

		// ǥեȥå
		$view_path = $this->getDefaultViewPath($forward_name);
		if (file_exists($view_dir . $view_path)) {
			include_once($view_dir . $view_path);
			return;
		} else {
			$this->logger->log(LOG_DEBUG, 'default view file not found [%s]', $view_path);
			$view_path = null;
		}
	}

	/**
	 *	ǥ쥯ȥʲƤΥץȤ򥤥󥯥롼ɤ
	 *
	 *	@access	private
	 */
	function _includeDirectory($dir)
	{
		$ext = "." . $this->ext['php'];
		$ext_len = strlen($ext);

		if (is_dir($dir) == false) {
			return;
		}

		$dh = opendir($dir);
		if ($dh) {
			while (($file = readdir($dh)) !== false) {
				if ($file != '.' && $file != '..' && is_dir("$dir/$file")) {
					$this->_includeDirectory("$dir/$file");
				}
				if (substr($file, -$ext_len, $ext_len) != $ext) {
					continue;
				}
				include_once("$dir/$file");
			}
		}
		closedir($dh);
	}

	/**
	 *	եDSNѤǡƹۤ(졼֥ʬ)
	 *
	 *	DSNˡ(ǥե:ե)ѤϤ򥪡С饤ɤ
	 *
	 *	@access	protected
	 *	@return	array	DSN
	 */
	function _prepareDSN()
	{
		$r = array();

		foreach ($this->db as $key => $value) {
			$config_key = "dsn";
			if ($key != "") {
				$config_key .= "_$key";
			}
			$dsn = $this->config->get($config_key);
			if (is_array($dsn)) {
				// 1ĤˤĤʣDSNƤϥʬ
				$dsn = $this->_selectDSN($key, $dsn);
			}
			$r[$key] = $dsn;
		}
		return $r;
	}

	/**
	 *	DSNΥʬԤ
	 *	
	 *	졼֥Фؤοʬ(ǥե:)ѹϤΥ᥽åɤ򥪡С饤ɤ
	 *
	 *	@access	protected
	 *	@param	string	$type		DB
	 *	@param	array	$dsn_list	DSN
	 *	@return	string	򤵤줿DSN
	 */
	function _selectDSN($type, $dsn_list)
	{
		// ǥե:
		list($usec, $sec) = explode(' ', microtime());
		mt_srand($sec + ((float) $usec * 100000));
		$n = mt_rand(0, count($dsn_list)-1);
		
		return $dsn_list[$n];
	}

	/**
	 *	Ethnaޥ͡ꤹ
	 *
	 *	פʾ϶Υ᥽åɤȤƥС饤ɤƤ褤
	 *
	 *	@access	protected
	 */
	function _activateEthnaManager()
	{
		if ($this->config->get('debug') == false) {
			return;
		}

		include_once(ETHNA_BASE . '/class/Ethna_InfoManager.php');

		// action
		$this->action['__ethna_info__'] = array(
			'form_name' =>	'Ethna_Form_Info',
			'form_path' =>	sprintf('%s/class/Action/Ethna_Action_Info.php', ETHNA_BASE),
			'class_name' =>	'Ethna_Action_Info',
			'class_path' =>	sprintf('%s/class/Action/Ethna_Action_Info.php', ETHNA_BASE),
		);

		// forward
		$this->forward['__ethna_info__'] = array(
			'forward_path'	=> sprintf('%s/tpl/info.tpl', ETHNA_BASE),
			'view_name'		=> 'Ethna_View_Info',
			'view_path'		=> sprintf('%s/class/View/Ethna_View_Info.php', ETHNA_BASE),
		);
	}
}
// }}}
?>
