<?php
// vim: foldmethod=marker
/**
 *	Ethna_AppManager.php
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@license	http://www.opensource.org/licenses/bsd-license.php The BSD License
 *	@package	Ethna
 *	@version	$Id: Ethna_AppManager.php,v 1.5 2005/01/12 17:10:31 fujimoto Exp $
 */

/** ץꥱ󥪥֥Ⱦ: Ѳǽ */
define('OBJECT_STATE_ACTIVE', 0);
/** ץꥱ󥪥֥Ⱦ: Բ */
define('OBJECT_STATE_INACTIVE', 100);


/** ץꥱ󥪥֥ȥȥե饰:  */
define('OBJECT_SORT_ASC', 0);
/** ץꥱ󥪥֥ȥȥե饰: ߽ */
define('OBJECT_SORT_DESC', 1);


/** ץꥱ󥪥֥ȥݡȥץ: NULLץѥƥ̵Ѵ */
define('OBJECT_IMPORT_IGNORE_NULL', 1);

/** ץꥱ󥪥֥ȥݡȥץ: NULLץѥƥʸѴ */
define('OBJECT_IMPORT_CONVERT_NULL', 2);


// {{{ Ethna_AppManager
/**
 *	ץꥱޥ͡Υ١饹
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@access		public
 *	@package	Ethna
 */
class Ethna_AppManager
{
	/**#@+
	 *	@access	private
	 */

	/**	@var	object	Ethna_Backend		backend֥ */
	var $backend;

	/**	@var	object	Ethna_Config		ꥪ֥ */
	var $config;

	/**  @var    object  Ethna_DB      DB֥ */
	var $db;

	/**	@var	object	Ethna_I18N			i18n֥ */
	var $i18n;

	/**	@var	object	Ethna_ActionForm	ե४֥ */
	var $action_form;

	/**	@var	object	Ethna_ActionForm	ե४֥(ά) */
	var $af;

	/**	@var	object	Ethna_Session		å󥪥֥ */
	var $session;

	/**#@-*/

	/**
	 *	Ethna_AppManagerΥ󥹥ȥ饯
	 *
	 *	@access	public
	 *	@param	object	Ethna_Backend	&$backend	backend֥
	 */
	function Ethna_AppManager(&$backend)
	{
		// ܥ֥Ȥ
		$this->backend =& $backend;
		$this->config = $backend->getConfig();
		$this->i18n =& $backend->getI18N();
		$this->action_form =& $backend->getActionForm();
		$this->af =& $this->action_form;
		$this->session =& $backend->getSession();

		$db_list = $backend->getDBlist();
		if (Ethna::isError($db_list) == false) {
			foreach ($db_list as $elt) {
				$varname = $elt['varname'];
				$this->$varname =& $elt['db'];
			}
		}
	}

	/**
	 *	°ΰ֤
	 *
	 *	@access	public
	 *	@param	string	$attr_name	°̾(ѿ̾)
	 *	@return	array	°Ͱ
	 */
	function getAttrList($attr_name)
	{
		$varname = $attr_name . "_list";
		return $this->$varname;
	}

	/**
	 *	°ɽ֤̾
	 *
	 *	@access	public
	 *	@param	string	$attr_name	°̾(ѿ̾)
	 *	@param	mixed	$id			°ID
	 *	@return	string	°ɽ̾
	 */
	function getAttrName($attr_name, $id)
	{
		$varname = $attr_name . "_list";
		if (is_array($this->$varname) == false) {
			return null;
		}
		$list =& $this->$varname;
		if (isset($list[$id]) == false) {
			return null;
		}
		return $list[$id]['name'];
	}

	/**
	 *	°ɽ̾(ܺ)֤
	 *
	 *	@access	public
	 *	@param	string	$attr_name	°̾(ѿ̾)
	 *	@param	mixed	$id			°ID
	 *	@return	string	°ξܺɽ̾
	 */
	function getAttrLongName($attr_name, $id)
	{
		$varname = $attr_name . "_list";
		if (is_array($this->$varname) == false) {
			return null;
		}
		$list =& $this->$varname;
		if (isset($list[$id]['long_name']) == false) {
			return null;
		}

		return $list[$id]['long_name'];
	}

	/**
	 *	֥Ȥΰ֤
	 *
	 *	@access	public
	 *	@param	string	$class	Ethna_AppObjectηѾ饹̾
	 *	@param	array	$filter		
	 *	@param	array	$order		̥Ⱦ
	 *	@param	int		$offset		̼եå
	 *	@param	int		$count		̼
	 *	@return	mixed	array(0 => ˥ޥå, 1 => $offset, $countˤꤵ줿Υ֥ID) Ethna_Error:顼
	 *	@todo	ѥեޥк(1֥Ȥ꤬ͭ¿)
	 */
	function getObjectList($class, $filter = null, $order = null, $offset = null, $count = null)
	{
		$object_list = array();
		$class_name = sprintf("%s_%s", $this->backend->getAppId(), $class);

		$tmp =& new $class_name($this->backend);
		list($length, $prop_list) = $tmp->searchProp(null, $filter, $order, $offset, $count);

		foreach ($prop_list as $prop) {
			$object =& new $class_name($this->backend, null, null, $prop);
			$object_list[] = $object;
		}

		return array($length, $object_list);
	}

	/**
	 *	֥ȥץѥƥΰ֤
	 *
	 *	getObjectList()᥽åɤϾ˥ޥåID򸵤Ethna_AppObject
	 *	ᥳȤ롣ϥץѥƥΤߤSELECTΤ㥳Ȥǥǡ
	 *	뤳Ȥǽ
	 *
	 *	@access	public
	 *	@param	string	$class		Ethna_AppObjectηѾ饹̾
	 *	@param	array	$keys		ץѥƥ(nullʤ)
	 *	@param	array	$filter		
	 *	@param	array	$order		̥Ⱦ
	 *	@param	int		$offset		̼եå
	 *	@param	int		$count		̼
	 *	@return	mixed	array(0 => ˥ޥå, 1 => $offset, $countˤꤵ줿Υץѥƥ) Ethna_Error:顼
	 */
	function getObjectPropList($class, $keys = null, $filter = null, $order = null, $offset = null, $count = null)
	{
		$prop_list = array();
		$class_name = sprintf("%s_%s", $this->backend->getAppId(), $class);

		$tmp =& new $class_name($this->backend);
		return $tmp->searchProp($keys, $filter, $order, $offset, $count);
	}

	/**
	 *	֥ȥץѥƥ֤
	 *
	 *	getObjectPropList()᥽åɤδʰǤǡ$filterˤ̤1ȥ
	 *	¤(ץ饤ޥꥭǤθ)Ѥ
	 *
	 *	@access	public
	 *	@param	string	$class		Ethna_AppObjectηѾ饹̾
	 *	@param	array	$keys		ץѥƥ
	 *	@param	array	$filter		
	 *	@return	mixed	array:ץѥƥ null:ȥʤ Ethna_Error:顼
	 */
	function getObjectProp($class, $keys = null, $filter = null)
	{
		$prop_list = array();
		$class_name = sprintf("%s_%s", $this->backend->getAppId(), $class);

		$tmp =& new $class_name($this->backend);
		list(, $prop) = $tmp->searchProp($keys, $filter);
		if (count($prop) > 0) {
			return $prop[0];
		} else {
			return null;
		}
	}
}
// }}}
?>
