<?php
// vim: foldmethod=marker
/**
 *	Ethna_ActionError.php
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@license	http://www.opensource.org/licenses/bsd-license.php The BSD License
 *	@package	Ethna
 *	@version	$Id: Ethna_ActionError.php,v 1.6 2005/01/06 17:44:23 fujimoto Exp $
 */

include_once(ETHNA_BASE . '/class/Ethna_Error.php');

// {{{ Ethna_ActionError
/**
 *	ץꥱ󥨥顼饹
 *
 *	@access		public
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@package	Ethna
 */
class Ethna_ActionError
{
	/**#@+
	 *	@access	private
	 */

	/**	@var	array	顼֥Ȥΰ */
	var $error_list = array();

	/**	@var	object	Ethna_ActionForm	ե४֥ */
	var $action_form = null;

	/**	@var	object	Ethna_Logger		֥ */
	var $logger = null;
	/**#@-*/

	/**
	 *	Ethna_ActionError饹Υ󥹥ȥ饯
	 *
	 *	@access	public
	 */
	function Ethna_ActionError()
	{
	}

	/**
	 *	顼֥Ȥ/ɲä
	 *
	 *	@access	public
	 *	@param	string	$name		顼ȯե̾(פʤnull)
	 *	@param	string	$message	顼å
	 *	@param	int		$code		顼
	 */
	function add($name, $message, $code)
	{
		if (func_num_args() > 3) {
			$userinfo = array_slice(func_get_args(), 3);
			$error =& Ethna::raiseNotice($message, $code, $userinfo);
		} else {
			$error =& Ethna::raiseNotice($message, $code);
		}
		$elt = array();
		$elt['name'] = $name;
		$elt['object'] =& $error;
		$this->error_list[] =& $elt;

		// (­)
		$af =& $this->_getActionForm();
		$logger =& $this->_getLogger();
		$logger->log(LOG_NOTICE, '{form} -> [%s]', $this->action_form->getName($name));
	}

	/**
	 *	Ethna_Error֥Ȥɲä
	 *
	 *	@access	public
	 *	@param	string				$name	顼бե̾(פʤnull)
	 *	@param	object	Ethna_Error	$error	顼֥
	 */
	function addObject($name, &$error)
	{
		$elt = array();
		$elt['name'] = $name;
		$elt['object'] =& $error;
		$this->error_list[] =& $elt;
	}

	/**
	 *	顼֥Ȥο֤
	 *
	 *	@access	public
	 *	@return	int		顼֥Ȥο
	 */
	function count()
	{
		return count($this->error_list);
	}

	/**
	 *	顼֥Ȥο֤(count()᥽åɤΥꥢ)
	 *
	 *	@access	public
	 *	@return	int		顼֥Ȥο
	 */
	function length()
	{
		return count($this->error_list);
	}

	/**
	 *	Ͽ줿顼֥Ȥƺ
	 *
	 *	@access	public
	 */
	function clear()
	{
		$this->error_list = array();
	}

	/**
	 *	ꤵ줿եܤ˥顼ȯƤ뤫ɤ֤
	 *
	 *	@access	public
	 *	@param	string	$name	ե̾
	 *	@return	bool	true:顼ȯƤ false:顼ȯƤʤ
	 */
	function isError($name)
	{
		foreach ($this->error_list as $error) {
			if (strcasecmp($error['name'], $name) == 0) {
				return true;
			}
		}
		return false;
	}

	/**
	 *	ꤵ줿եܤб륨顼å֤
	 *
	 *	@access	public
	 *	@param	string	$name	ե̾
	 *	@return	string	顼å(顼̵null)
	 */
	function getMessage($name)
	{
		foreach ($this->error_list as $error) {
			if (strcasecmp($error['name'], $name) == 0) {
				return $this->_getMessage($error);
			}
		}
		return null;
	}

	/**
	 *	顼֥Ȥˤ֤
	 *
	 *	@access	public
	 *	@return	array	顼֥Ȥ
	 */
	function getErrorList()
	{
		return $this->error_list;
	}

	/**
	 *	顼åˤ֤
	 *
	 *	@access	public
	 *	@return	array	顼å
	 */
	function getMessageList()
	{
		$message_list = array();

		foreach ($this->error_list as $error) {
			$message_list[] = $this->_getMessage($error);
		}
		return $message_list;
	}

	/**
	 *	ץꥱ󥨥顼å
	 *
	 *	@access	private
	 *	@param	array	顼ȥ
	 *	@return	string	顼å
	 */
	function _getMessage(&$error)
	{
		$af =& $this->_getActionForm();
		$form_name = $af->getName($error['name']);
		return str_replace("{form}", $form_name, $error['object']->getMessage());
	}

	/**
	 *	Ethna_ActionForm֥Ȥ
	 *
	 *	@access	private
	 *	@return	object	Ethna_ActionForm
	 */
	function &_getActionForm()
	{
		if (is_null($this->action_form)) {
			$controller =& Ethna_Controller::getInstance();
			$this->action_form =& $controller->getActionForm();
		}
		return $this->action_form;
	}

	/**
	 *	Ethna_Logger֥Ȥ
	 *
	 *	@access	private
	 *	@return	object	Ethna_Logger
	 */
	function _getLogger()
	{
		if (is_null($this->logger)) {
			$controller =& Ethna_Controller::getInstance();
			$this->logger =& $controller->getLogger();
		}
		return $this->logger;
	}
}
// }}}
?>
