<?php
// vim: foldmethod=marker
/**
 *	Ethna_MailSender.php
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@license	http://www.opensource.org/licenses/bsd-license.php The BSD License
 *	@package	Ethna
 *	@version	$Id: Ethna_MailSender.php,v 1.2 2005/01/06 17:44:23 fujimoto Exp $
 */

/** ᡼ƥץ졼ȥ: ľ */
define('MAILSENDER_TYPE_DIRECT', 0);


// {{{ Ethna_MailSender
/**
 *	᡼饹
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@access		public
 *	@package	Ethna
 */
class Ethna_MailSender
{
	/**#@+
	 *	@access	private
	 */

	/**	@var	array	᡼ƥץ졼 */
	var	$def = array(
	);

	/**	@var	int		᡼륿 */
	var	$type;

	/**	@var	object	Ethna_Backend	backend֥ */
	var $backend;

	/**	@var	object	Ethna_Config	ꥪ֥ */
	var $config;

	/**#@-*/

	/**
	 *	Ethna_MailSender饹Υ󥹥ȥ饯
	 *
	 *	@access	public
	 *	@param	object	Ethna_Backend	&$backend		backend֥
	 */
	function Ethna_MailSender(&$backend)
	{
		$this->backend =& $backend;
		$this->config =& $this->backend->getConfig();
	}

	/**
	 *	᡼
	 *
	 *	@access	public
	 *	@param	string	$to		᡼襢ɥ쥹
	 *	@param	string	$type	᡼ƥץ졼ȥ
	 *	@param	array	$macro	ƥץ졼ȥޥ($typeMAILSENDER_TYPE_DIRECTξϥ᡼)
	 *	@param	array	$attach	źեե(array('content-type' => ..., 'content' => ...))
	 *	@return	string	$tonullξƥץ졼ȥޥŬѸΥ᡼
	 */
	function send($to, $type, $macro, $attach = null)
	{
		// ƥĺ
		$c =& $this->backend->getController();

		if ($type != MAILSENDER_TYPE_DIRECT) {
			$smarty =& $c->getTemplateEngine();

			// ܾ
			$smarty->assign("env_datetime", strftime('%Yǯ%m%d %H%Mʬ%S'));
			$smarty->assign("env_useragent", $_SERVER["HTTP_USER_AGENT"]);
			$smarty->assign("env_remoteaddr", $_SERVER["REMOTE_ADDR"]);

			// ǥեȥޥ
			$macro = $this->_setDefaultMacro($macro);

			// 桼
			if (is_array($macro)) {
				foreach ($macro as $key => $value) {
					$smarty->assign($key, $value);
				}
			}

			$template = $this->def[$type];
			ob_start();
			$smarty->display("mail/$template");
			$mail = ob_get_contents();
			ob_end_clean();
		} else {
			$mail = $macro;
		}

		if (is_null($to)) {
			return $mail;
		}

		// 
		foreach (to_array($to) as $rcpt) {
			list($header, $body) = $this->_parse($mail);

			// multipartб
			if ($attach != null) {
				$boundary = Ethna_Util::getRandom(); 

				$body = "This is a multi-part message in MIME format.\n\n" .
					"--$boundary\n" .
					"Content-Type: text/plain; charset=ISO-2022-JP\n\n" .
					"$body\n" .
					"--$boundary\n" .
					"Content-Type: " . $attach['content-type'] . "; name=\"" . $attach['name'] . "\"\n" .
					"Content-Transfer-Encoding: base64\n" . 
					"Content-Disposition: attachment; filename=\"" . $attach['name'] . "\"\n\n";
				$body .= chunk_split(base64_encode($attach['content']));
				$body .= "--$boundary--";
			}

			$body = str_replace("\r\n", "\n", $body);

			// ɬפʥإåɲ
			if (array_key_exists('mime-version', $header) == false) {
				$header['mime-version'] = array('Mime-Version', '1.0');
			}
			if (array_key_exists('subject', $header) == false) {
				$header['subject'] = array('Subject', 'no subject in original');
			}
			if (array_key_exists('content-type', $header) == false) {
				if ($attach == null) {
					$header['content-type'] = array('Content-Type', 'text/plain; charset=ISO-2022-JP');
				} else {
					$header['content-type'] = array('Content-Type', "multipart/mixed; boundary=\"$boundary\"");
				}
			}

			$header_line = "";
			foreach ($header as $key => $value) {
				if ($key == 'subject') {
					// should be added by mail()
					continue;
				}
				if ($header_line != "") {
					$header_line = "$header_line\n";
				}
				$header_line .= $value[0] . ": " . $value[1];
			}

			mail($rcpt, $header['subject'][1], $body, $header_line);
		}
	}

	/**
	 *	ץꥱͭΥޥꤹ
	 *
	 *	@access	protected
	 *	@param	array	$macro	桼ޥ
	 *	@return	array	ץꥱͭѤߥޥ
	 */
	function _setDefaultMacro($macro)
	{
		return $macro;
	}

	/**
	 *	ƥץ졼ȥ᡼Υإå
	 *
	 *	@access	private
	 *	@param	string	$mail	᡼ƥץ졼
	 *	@return	array	إå, ʸ
	 */
	function _parse($mail)
	{
		list($header_line, $body) = preg_split('/\r?\n\r?\n/', $mail, 2);
		$header_line .= "\n";

		$header_lines = explode("\n", $header_line);
		$header = array();
		foreach ($header_lines as $h) {
			if (strstr($h, ':') == false) {
				continue;
			}
			list($key, $value) = preg_split('/\s*:\s*/', $h, 2);
			$i = strtolower($key);
			$header[$i] = array();
			$header[$i][] = $key;
			$header[$i][] = preg_replace('/([^\x00-\x7f]+)/e', "mb_encode_mimeheader('$1')", $value);
		}

		$body = mb_convert_encoding($body, "ISO-2022-JP", "EUC-JP");

		return array($header, $body);
	}
}
// }}}
?>
