<?php
// vim: foldmethod=marker
/**
 *	Ethna_ClassFactory.php
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@license	http://www.opensource.org/licenses/bsd-license.php The BSD License
 *	@package	Ethna
 *	@version	$Id: Ethna_ClassFactory.php,v 1.1 2005/01/12 17:09:25 fujimoto Exp $
 */

// {{{ Ethna_ClassFactory
/**
 *	Ethnaե졼Υ֥ȥ
 *
 *	DIƥʤȤȤͤޤEthnaǤϤ٤ñʤΤ
 *	αƤޤץꥱ٥DIϥե륿
 *	ȤäƼ¸뤳Ȥޤ
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@access		public
 *	@package	Ethna
 */
class Ethna_ClassFactory
{
	/**#@+
	 *	@access	private
	 */

	/**	@var	object	Ethna_Controller	controller֥ */
	var	$controller;

	/**	@var	object	Ethna_Controller	controller֥(ά) */
	var	$ctl;
	
	/**	@var	array	饹 */
	var	$class = array();

	/**	@var	array	Ѥߥ֥ȥå */
	var	$object = array();

	/**#@-*/


	/**
	 *	Ethna_ClassFactory饹Υ󥹥ȥ饯
	 *
	 *	@access	public
	 *	@param	object	Ethna_Controller	&$controller	controller֥
	 *	@param	array						$class			饹
	 */
	function Ethna_ClassFactory(&$controller, $class)
	{
		$this->controller =& $controller;
		$this->ctl =& $controller;
		$this->class = $class;
	}

	/**
	 *	饹б륪֥Ȥ֤
	 *
	 *	@access	public
	 *	@param	string	$key	饹
	 *	@param	bool	$weak	֥Ȥ̤ξζե饰(default: false)
	 *	@return	object	줿֥(顼ʤnull)
	 */
	function &getObject($key, $weak = false)
	{
		if (isset($this->class[$key]) == false) {
			return null;
		}
		$class_name = $this->class[$key];
		if (isset($this->object[$key]) && is_object($this->object[$key])) {
			return $this->object[$key];
		}

		$method = sprintf('_getObject_%s', ucfirst($key));
		if (method_exists($this, $method)) {
			$obj =& $this->$method($class_name);
		} else {
			$obj =& new $class_name();
		}
		$this->object[$key] =& $obj;

		return $obj;
	}

	/**
	 *	饹б륯饹֤̾
	 *
	 *	@access	public
	 *	@param	string	$key	饹
	 *	@return	string	饹̾
	 */
	function getObjectName($key)
	{
		if (isset($this->class[$key]) == false) {
			return null;
		}

		return $this->class[$key];
	}

	/**
	 *	֥᥽å(backend)
	 *
	 *	@access	protected
	 *	@param	string	$class_name		饹̾
	 *	@return	object	줿֥(顼ʤnull)
	 */
	function &_getObject_Backend($class_name)
	{
		return new $class_name($this->ctl);
	}

	/**
	 *	֥᥽å(config)
	 *
	 *	@access	protected
	 *	@param	string	$class_name		饹̾
	 *	@return	object	줿֥(顼ʤnull)
	 */
	function &_getObject_Config($class_name)
	{
		return new $class_name($this->ctl);
	}

	/**
	 *	֥᥽å(i18n)
	 *
	 *	@access	protected
	 *	@param	string	$class_name		饹̾
	 *	@return	object	줿֥(顼ʤnull)
	 */
	function &_getObject_I18n($class_name)
	{
		return new $class_name($this->ctl->getDirectory('locale'), $this->ctl->getAppId());
	}

	/**
	 *	֥᥽å(logger)
	 *
	 *	@access	protected
	 *	@param	string	$class_name		饹̾
	 *	@return	object	줿֥(顼ʤnull)
	 */
	function &_getObject_Logger($class_name)
	{
		return new $class_name($this->ctl);
	}

	/**
	 *	֥᥽å(session)
	 *
	 *	@access	protected
	 *	@param	string	$class_name		饹̾
	 *	@return	object	줿֥(顼ʤnull)
	 */
	function &_getObject_Session($class_name)
	{
		return new $class_name($this->ctl->getAppId(), $this->ctl->getDirectory('tmp'), $this->ctl->getLogger());
	}

	/**
	 *	֥᥽å(sql)
	 *
	 *	@access	protected
	 *	@param	string	$class_name		饹̾
	 *	@return	object	줿֥(顼ʤnull)
	 */
	function &_getObject_Sql($class_name)
	{
		return new $class_name($this->ctl);
	}
}
// }}}
?>
