<?php
// vim: foldmethod=marker
/**
 *	Ethna_AppObject.php
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@license	http://www.opensource.org/licenses/bsd-license.php The BSD License
 *	@package	Ethna
 *	@version	$Id: Ethna_AppObject.php,v 1.7 2005/01/12 17:10:31 fujimoto Exp $
 */

// {{{ Ethna_AppObject
/**
 *	ץꥱ󥪥֥ȤΥ١饹
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@access		public
 *	@package	Ethna
 *	@todo		ʣơ֥JOINб
 */
class Ethna_AppObject
{
	/**#@+
	 *	@access	private
	 */

	/**	@var	object	Ethna_Backend		backend֥ */
	var $backend;

	/**	@var	object	Ethna_Config		ꥪ֥ */
	var $config;

	/**  @var    object  Ethna_DB      DB֥ */
	var $db;

	/**	@var	object	Ethna_I18N			i18n֥ */
	var $i18n;

	/**	@var	object	Ethna_ActionForm	ե४֥ */
	var $action_form;

	/**	@var	object	Ethna_ActionForm	ե४֥(ά) */
	var $af;

	/**	@var	object	Ethna_Session		å󥪥֥ */
	var $session;

	/**	@var	array	ơ֥ */
	var	$table_def = array();

	/**	@var	array	ץѥƥ */
	var	$prop_def = array();

	/**	@var	array	ץѥƥ */
	var	$prop = null;
	var $prop_backup = null;

	/** @var	array	ץ饤ޥꥭ */
	var	$id_def = null;

	/**	@var	int		֥ID */
	var	$id = null;

	/**#@-*/


	/**
	 *	Ethna_AppObject饹Υ󥹥ȥ饯
	 *
	 *	@access	public
	 *	@param	object	Ethna_Backend	&$backend	Ethna_Backend֥
	 *	@param	mixed	$key_type	̾
	 *	@param	mixed	$key		
	 *	@param	array	$prop		ץѥƥ
	 *	@return	mixed	0:ｪλ -1:/ץѥƥ̤ Ethna_Error:顼
	 */
	function Ethna_AppObject(&$backend, $key_type = null, $key = null, $prop = null)
	{
		$this->backend =& $backend;
		$this->config =& $backend->getConfig();
		$this->action_form =& $backend->getActionForm();
		$this->af =& $this->action_form;
		$this->session =& $backend->getSession();

		$db_list = $backend->getDBlist();
		if (Ethna::isError($db_list) == false) {
			foreach ($db_list as $elt) {
				$varname = $elt['varname'];
				$this->$varname =& $elt['db'];

				if ($elt['type'] == DB_TYPE_RW) {
					$this->my_db_rw =& $elt['db'];
				} else if ($elt['type'] == DB_TYPE_RO) {
					$this->my_db_ro =& $elt['db'];
				}
			}
		}
		if (isset($this->my_db_ro) == false && $this->my_db_rw) {
			$this->my_db_ro =& $this->my_db_rw;
		}

		$c =& $backend->getController();

		// Ethna_AppManager֥Ȥ
		$manager_list = $c->getManagerList();
		foreach ($manager_list as $k => $v) {
			$this->$k = $backend->getManager($v);
		}

		// ֥ȤΥץ饤ޥꥭ
		foreach ($this->prop_def as $k => $v) {
			if ($v['primary'] == false) {
				continue;
			}
			if (is_null($this->id_def)) {
				$this->id_def = $k;
			} else if (is_array($this->id_def)) {
				$this->id_def[] = $k;
			} else {
				$this->id_def = array($this->id_def, $k);
			}
		}
		
		// DB顼å
		if (is_null($this->my_db_ro)) {
			return Ethna::raiseError("Ethna_AppObjectѤˤϥǡ١꤬ɬפǤ", E_DB_NODSN);
		} else if (Ethna::isError($db_list)) {
			return $db_list;
		}

		// å
		if (is_null($key_type) && is_null($key) && is_null($prop)) {
			// perhaps for adding object
			return 0;
		}

		// ץѥƥ
		if (is_null($prop)) {
			$this->_setPropByDB($key_type, $key);
		} else {
			$this->_setPropByValue($prop);
		}

		$this->prop_backup = $this->prop;

		if (is_array($this->id_def)) {
			$this->id = array();
			foreach ($this->id_def as $k) {
				$this->id[] = $this->prop[$k];
			}
		} else {
			$this->id = $this->prop[$this->id_def];
		}

		return 0;
	}

	/**
	 *	ͭʥ֥Ȥɤ֤
	 *
	 *	@access	public
	 *	@return	bool	true:ͭ false:̵
	 */
	function isValid()
	{
		return is_null($this->id) ? false : true;
	}

	/**
	 *	ƥ֤ʥ֥Ȥɤ֤
	 *
	 *	isValid()᥽åɤϥ֥ȼΤͭɤȽꤹΤФ
	 *	isActive()ϥ֥ȤץꥱȤͭɤ֤
	 *
	 *	@access	public
	 *	@return	bool	true:ƥ false:󥢥ƥ
	 */
	function isActive()
	{
		if ($this->isValid() == false) {
			return false;
		}
		return $this->prop['state'] == OBJECT_STATE_ACTIVE ? true : false;
	}

	/**
	 *	֥ȤΥץѥƥ֤
	 *
	 *	@access	public
	 *	@return	array	֥ȤΥץѥƥ
	 */
	function getDef()
	{
		return $this->prop_def;
	}

	/**
	 *	ץ饤ޥꥭ֤
	 *
	 *	@access	public
	 *	@return	mixed	ץ饤ޥꥭȤʤץѥƥ̾
	 */
	function getIdDef()
	{
		return $this->id_def;
	}

	/**
	 *	֥ID֤
	 *
	 *	@access	public
	 *	@return	mixed	֥ID
	 */
	function getId()
	{
		return $this->id;
	}

	/**
	 *	֥ȥץѥƥؤΥ(R)
	 *
	 *	@access	public
	 *	@param	string	$key	ץѥƥ̾
	 *	@return	mixed	ץѥƥ
	 */
	function get($key)
	{
		if (isset($this->prop_def[$key]) == false) {
			trigger_error(sprintf("Unknown property [%s]", $key), E_USER_ERROR);
			return null;
		}
		if (isset($this->prop[$key])) {
			return $this->prop[$key];
		}
		return null;
	}

	/**
	 *	֥ȥץѥƥɽ̾ؤΥ
	 *
	 *	@access	public
	 *	@param	string	$key	ץѥƥ̾
	 *	@return	string	ץѥƥɽ̾
	 */
	function getName($key)
	{
		return $this->get($key);
	}

	/**
	 *	֥ȥץѥƥɽ̾(ܺ)ؤΥ
	 *
	 *	@access	public
	 *	@param	string	$key	ץѥƥ̾
	 *	@return	string	ץѥƥɽ̾(ܺ)
	 */
	function getLongName($key)
	{
		return $this->get($key);
	}

	/**
	 *	ץѥƥɽ̾ǼϢ
	 *
	 *	@access	public
	 *	@return	array	ץѥƥɽ̾ǼϢ
	 */
	function getNameObject()
	{
		$object = array();

		foreach ($this->prop_def as $key => $elt) {
			$object[$elt['form_name']] = $this->getName($key);
		}

		return $object;
	}

	/**
	 *	֥ȥץѥƥؤΥ(W)
	 *
	 *	@access	public
	 *	@param	string	$key	ץѥƥ̾
	 *	@param	string	$value	ץѥƥ
	 */
	function set($key, $value)
	{
		if (isset($this->prop_def[$key]) == false) {
			trigger_error(sprintf("Unknown property [%s]", $key), E_USER_ERROR);
			return null;
		}
		$this->prop[$key] = $value;
	}

	/**
	 *	֥ȥץѥƥηǥפ(ߤCSVΤߥݡ)
	 *
	 *	@access	public
	 *	@param	string	$type	׷("csv"...)
	 *	@return	string	׷(顼ξnull)
	 */
	function dump($type = "csv")
	{
		$method = "_dump_$type";
		if (method_exists($this, $method) == false) {
			return Ethna::raiseError("᥽å̤[%s]", E_APP_NOMETHOD, $method);
		}

		return $this->$method();
	}

	/**
	 *	եͤ饪֥ȥץѥƥ򥤥ݡȤ
	 *
	 *	@access	public
	 *	@param	int		$option	ݡȥץ(OBJECT_IMPORT_IGNORE_NULL,...)
	 */
	function importForm($option = null)
	{
		foreach ($this->getDef() as $k => $def) {
			$value = $this->af->get($def['form_name']);
			if (is_null($value)) {
				// եफͤƤʤο
				if ($option == OBJECT_IMPORT_IGNORE_NULL) {
					// nullϥå
					continue;
				} else if ($option == OBJECT_IMPORT_CONVERT_NULL) {
					// ʸѴ
					$value = '';
				}
			}
			$this->set($k, $value);
		}
	}

	/**
	 *	֥ȥץѥƥեͤ˥ݡȤ
	 *
	 *	@access	public
	 */
	function exportForm()
	{
		foreach ($this->getDef() as $k => $def) {
			$this->af->set($def['form_name'], $this->get($k));
		}
	}

	/**
	 *	֥Ȥɲä
	 *
	 *	@access	public
	 *	@return	mixed	0:ｪλ Ethna_Error:顼
	 *	@todo	MySQLʳΥ󥹷(Ūʤ)б
	 */
	function add()
	{
		$sql = $this->_getSQL_Add();
		for ($i = 0; $i < 4; $i++) {
			$r =& $this->my_db_rw->query($sql);
			if (Ethna::isError($r)) {
				if ($r->getCode() == E_DB_DUPENT) {
					// ʣ顼Ƚ
					$duplicate_key_list = $this->_getDuplicateKeyList();
					if (Ethna::isError($duplicate_key_list)) {
						return $duplicate_key_list;
					}
					if (is_array($duplicate_key_list) && count($duplicate_key_list) > 0) {
						foreach ($duplicate_key_list as $k) {
							return Ethna::raiseNotice('ʣ顼[%s]', E_APP_DUPENT, $k);
						}
					}
				} else {
					return $r;
				}
			} else {
				break;
			}
		}
		if ($i == 4) {
			// cannot be reached
			return Ethna::raiseError('ʣ顼Ƚ̥顼', E_GENERAL);
		}

		$this->prop_backup = $this->prop;

		// IDμ(MySQLΤб)
		if ($this->my_db_rw->getType() == 'mysql') {
			// MySQLAUTO_INCREMENTϥơ֥1ǳPRIMARY KEY
			foreach (to_array($this->id_def) as $id_def) {
				if ($this->prop_def[$id_def]['seq']) {
					$this->prop[$id_def] = $this->my_db_rw->getInsertId();
					break;
				}
			}
		}

		// ID
		if (is_array($this->id_def)) {
			$this->id = array();
			foreach ($this->id_def as $k) {
				$this->id[] = $this->prop[$k];
			}
		} else {
			$this->id = $this->prop[$this->id_def];
		}

		$this->prop_backup = $this->prop;

		return 0;
	}

	/**
	 *	֥Ȥ򹹿
	 *
	 *	@access	public
	 *	@return	mixed	0:ｪλ Ethna_Error:顼
	 */
	function update()
	{
		$sql = $this->_getSQL_Update();
		for ($i = 0; $i < 4; $i++) {
			$r =& $this->my_db_rw->query($sql);
			if (Ethna::isError($r)) {
				if ($r->getCode() == E_DB_DUPENT) {
					// ʣ顼Ƚ
					$duplicate_key_list = $this->_getDuplicateKeyList();
					if (Ethna::isError($duplicate_key_list)) {
						return $duplicate_key_list;
					}
					if (is_array($duplicate_key_list) && count($duplicate_key_list) > 0) {
						foreach ($duplicate_key_list as $k) {
							return Ethna::raiseNotice('ʣ顼[%s]', E_APP_DUPENT, $k);
						}
					}
				} else {
					return $r;
				}
			} else {
				break;
			}
		}
		if ($i == 4) {
			// cannot be reached
			return Ethna::raiseError('ʣ顼Ƚ̥顼', E_GENERAL);
		}

		$affected_rows = $this->my_db_rw->affectedRows();
		if ($affected_rows <= 0) {
			$this->backend->log(LOG_DEBUG, "update query with 0 updated rows");
		}

		$this->prop_backup = $this->prop;

		return 0;
	}

	/**
	 *	֥Ȥִ
	 *
	 *	MySQLREPLACEʸưԤ(add()ǽʣ顼ȯ
	 *	update()Ԥ)
	 *
	 *	@access	public
	 *	@return	mixed	0:ｪλ >0:֥ID(ɲû) Ethna_Error:顼
	 */
	function replace()
	{
		$sql = $this->_getSQL_Select($this->getIdDef(), $this->getId());

		for ($i = 0; $i < 3; $i++) {
			$r = $this->my_db_rw->query($sql);
			if (Ethna::isError($r)) {
				return $r;
			}
			$n = $r->numRows();

			if ($n > 0) {
				$r = $this->update();
				return $r;
			} else {
				$r = $this->add();
				if (Ethna::isError($r) == false) {
					return $r;
				} else if ($r->getCode() != E_APP_DUPENT) {
					return $r;
				}
			}
		}
		return $r;
	}

	/**
	 *	֥Ȥ
	 *
	 *	@access	public
	 *	@return	mixed	0:ｪλ Ethna_Error:顼
	 */
	function remove()
	{
		$sql = $this->_getSQL_Remove();
		$r =& $this->my_db_rw->query($sql);
		if (Ethna::isError($r)) {
			return $r;
		}

		$this->id = $this->prop = $this->prop_backup = null;

		return 0;
	}

	/**
	 *	֥ID򸡺
	 *
	 *	@access	public
	 *	@param	array	$filter		
	 *	@param	array	$order		̥Ⱦ
	 *	@param	int		$offset		̼եå
	 *	@param	int		$count		̼
	 *	@return	mixed	array(0 => ˥ޥå, 1 => $offset, $countˤꤵ줿Υ֥ID) Ethna_Error:顼
	 */
	function searchId($filter = null, $order = null, $offset = null, $count = null)
	{
		if (is_null($filter) == false) {
			$sql = $this->_getSQL_SearchLength($filter);
			$r =& $this->my_db_ro->query($sql);
			if (Ethna::isError($r)) {
				return $r;
			}
			$row = $r->fetchRow(DB_FETCHMODE_ASSOC);
			$length = $row['id_count'];
		} else {
			$length = null;
		}

		$id_list = array();
		$sql = $this->_getSQL_SearchId($filter, $order, $offset, $count);
		$r =& $this->my_db_ro->query($sql);
		if (Ethna::isError($r)) {
			return $r;
		}
		$n = $r->numRows();
		for ($i = 0; $i < $n; $i++) {
			$row = $r->fetchRow(DB_FETCHMODE_ASSOC);

			// ץ饤ޥꥭ1ʤ饹顼ͤѴ
			if (is_array($this->id_def) == false) {
				$row = $row[$this->id_def];
			}
			$id_list[] = $row;
		}
		if (is_null($length)) {
			$length = count($id_list);
		}

		return array($length, $id_list);
	}

	/**
	 *	֥ȥץѥƥ򸡺
	 *
	 *	@access	public
	 *	@param	array	$keys		ץѥƥ
	 *	@param	array	$filter		
	 *	@param	array	$order		̥Ⱦ
	 *	@param	int		$offset		̼եå
	 *	@param	int		$count		̼
	 *	@return	mixed	array(0 => ˥ޥå, 1 => $offset, $countˤꤵ줿Υ֥ȥץѥƥ) Ethna_Error:顼
	 */
	function searchProp($keys = null, $filter = null, $order = null, $offset = null, $count = null)
	{
		if (is_null($filter) == false) {
			$sql = $this->_getSQL_SearchLength($filter);
			$r =& $this->my_db_ro->query($sql);
			if (Ethna::isError($r)) {
				return $r;
			}
			$row = $r->fetchRow(DB_FETCHMODE_ASSOC);
			$length = $row['id_count'];
		} else {
			$length = null;
		}

		$prop_list = array();
		$sql = $this->_getSQL_SearchProp($keys, $filter, $order, $offset, $count);
		$r =& $this->my_db_ro->query($sql);
		if (Ethna::isError($r)) {
			return $r;
		}
		$n = $r->numRows();
		for ($i = 0; $i < $n; $i++) {
			$row = $r->fetchRow(DB_FETCHMODE_ASSOC);
			$prop_list[] = $row;
		}
		if (is_null($length)) {
			$length = count($prop_list);
		}

		return array($length, $prop_list);
	}

	/**
	 *	֥ȤΥץꥱǥեȥץѥƥꤹ
	 *
	 *	󥹥ȥ饯ˤꤵ줿˥ޥå륨ȥ꤬ʤä
	 *	ǥեȥץѥƥ򤳤ꤹ뤳Ȥ
	 *
	 *	@access	protected
	 *	@param	mixed	$key_type	̾
	 *	@param	mixed	$key		
	 *	@return	int		0:ｪλ
	 */
	function _setDefault($key_type, $key)
	{
		return 0;
	}

	/**
	 *	֥ȥץѥƥDB
	 *
	 *	@access	private
	 *	@param	mixed	$key_type	̾
	 *	@param	mixed	$key		
	 */
	function _setPropByDB($key_type, $key)
	{
		$key_type = to_array($key_type);
		$key = to_array($key);
		if (count($key_type) != count($key)) {
			trigger_error(sprintf("Unmatched key_type & key length [%d-%d]", count($key_type), count($key)), E_USER_ERROR);
			return;
		}
		foreach ($key_type as $elt) {
			if (isset($this->prop_def[$elt]) == false) {
				trigger_error("Invalid key_type [$elt]", E_USER_ERROR);
				return;
			}
		}

		// SQLʸ
		$sql = $this->_getSQL_Select($key_type, $key);

		// ץѥƥ
		$r =& $this->my_db_ro->query($sql);
		if (Ethna::isError($r)) {
			return;
		}
		$n = $r->numRows();
		if ($n == 0) {
			// try default
			if ($this->_setDefault($key_type, $key) == false) {
				// nop
			}
			return;
		} else if ($n > 1) {
			trigger_error("Invalid key (multiple rows found) [$key]", E_USER_ERROR);
			return;
		}
		$this->prop = $r->fetchRow(DB_FETCHMODE_ASSOC);
	}

	/**
	 *	󥹥ȥ饯ǻꤵ줿ץѥƥꤹ
	 *
	 *	@access	private
	 *	@param	array	$prop	ץѥƥ
	 */
	function _setPropByValue($prop)
	{
		$def = $this->getDef();
		foreach ($def as $key => $value) {
			if ($value['primary'] && isset($prop[$key]) == false) {
				// ץ饤ޥꥭϾάԲ
				trigger_error("primary key is not identical", E_USER_ERROR);
			}
			$this->prop[$key] = $prop[$key];
		}
	}

	/**
	 *	֥ȤΥץ饤ޥơ֥
	 *
	 *	@access	private
	 *	@return	string	֥ȤΥץ饤ޥơ֥̾
	 */
	function _getPrimaryTable()
	{
		$tables = array_keys($this->table_def);
		$table = $tables[0];
		
		return $table;
	}

	/**
	 *	ʣ
	 *
	 *	@access	private
	 *	@return	mixed	0:ʣʤ Ethna_Error:顼 array:ʣΥץѥƥ̾
	 */
	function _getDuplicateKeyList()
	{
		$duplicate_key_list = array();

		// ꤵƤץ饤ޥꥭNULLޤޤϸʤ
		$check_pkey = true;
		foreach (to_array($this->id_def) as $k) {
			if (isset($this->prop[$k]) == false || is_null($this->prop[$k])) {
				$check_pkey = false;
				break;
			}
		}

		// ץ饤ޥꥭmulti columnsˤʤΤ̰
		if ($check_pkey) {
			$sql = $this->_getSQL_Duplicate($this->id_def);
			$r =& $this->my_db_rw->query($sql);
			if (Ethna::isError($r)) {
				return $r;
			} else if ($r->numRows() > 0) {
				$duplicate_key_list = to_array($this->id_def); // we can overwrite $key_list here
			}
		}

		// ˡ
		foreach ($this->prop_def as $k => $v) {
			if ($v['primary'] == true || $v['key'] == false) {
				continue;
			}
			$sql = $this->_getSQL_Duplicate($k);
			$r =& $this->my_db_rw->query($sql);
			if (Ethna::isError($r)) {
				return $r;
			} else if ($r->NumRows() > 0) {
				$duplicate_key_list[] = $k;
			}
		}

		if (count($duplicate_key_list) > 0) {
			return $duplicate_key_list;
		} else {
			return 0;
		}
	}

	/**
	 *	֥ȥץѥƥSQLʸۤ
	 *
	 *	@access	private
	 *	@param	array	$key_type	Ȥʤץѥƥ̾
	 *	@param	array	$key		$key_typeб륭
	 *	@return	string	SELECTʸ
	 */
	function _getSQL_Select($key_type, $key)
	{
		$key_type = to_array($key_type);
		$key = to_array($key);

		// SQL
		Ethna_AppSQL::escapeSQL($key);

		$tables = implode(',', array_keys($this->table_def));
		$columns = implode(',', array_keys($this->prop_def));

		// 
		$condition = null;
		for ($i = 0; $i < count($key_type); $i++) {
			if (is_null($condition)) {
				$condition = "WHERE ";
			} else {
				$condition .= " AND ";
			}
			$condition .= Ethna_AppSQL::getCondition($key_type[$i], $key[$i]);
		}

		$sql = "SELECT $columns FROM $tables $condition";

		return $sql;
	}

	/**
	 *	֥ȤɲäSQLʸۤ
	 *
	 *	@access	private
	 *	@return	string	֥Ȥɲä뤿INSERTʸ
	 */
	function _getSQL_Add()
	{
		$tables = implode(',', array_keys($this->table_def));

		// SET繽
		$set_list = "";
		$prop_arg_list = $this->prop;
		Ethna_AppSQL::escapeSQL($prop_arg_list);
		foreach ($this->prop_def as $k => $v) {
			if (isset($prop_arg_list[$k]) == false) {
				continue;
			}
			if ($set_list != "") {
				$set_list .= ",";
			}
			$set_list .= sprintf("%s=%s", $k, $prop_arg_list[$k]);
		}

		$sql = "INSERT INTO $tables SET $set_list";

		return $sql;
	}

	/**
	 *	֥ȥץѥƥ򹹿SQLʸۤ
	 *
	 *	@access	private
	 *	@return	֥ȥץѥƥ򹹿뤿UPDATEʸ
	 */
	function _getSQL_Update()
	{
		$tables = implode(',', array_keys($this->table_def));

		// SET繽
		$set_list = "";
		$prop_arg_list = $this->prop;
		Ethna_AppSQL::escapeSQL($prop_arg_list);
		foreach ($this->prop_def as $k => $v) {
			if ($set_list != "") {
				$set_list .= ",";
			}
			$set_list .= sprintf("%s=%s", $k, $prop_arg_list[$k]);
		}

		// (primary key)
		$condition = null;
		foreach (to_array($this->id_def) as $k) {
			if (is_null($condition)) {
				$condition = "WHERE ";
			} else {
				$condition .= " AND ";
			}
			$v = $this->prop_backup[$k];	// equals to $this->id
			Ethna_AppSQL::escapeSQL($v);
			$condition .= Ethna_AppSQL::getCondition($k, $v);
		}

		$sql = "UPDATE $tables SET $set_list $condition";

		return $sql;
	}

	/**
	 *	֥ȤSQLʸۤ
	 *
	 *	@access	private
	 *	@return	string	֥Ȥ뤿DELETEʸ
	 */
	function _getSQL_Remove()
	{
		$tables = implode(',', array_keys($this->table_def));

		// (primary key)
		$condition = null;
		foreach (to_array($this->id_def) as $k) {
			if (is_null($condition)) {
				$condition = "WHERE ";
			} else {
				$condition = " AND ";
			}
			$v = $this->prop_backup[$k];	// equals to $this->id
			Ethna_AppSQL::escapeSQL($v);
			$condition .= Ethna_AppSQL::getCondition($k, $v);
		}
		if (is_null($condition)) {
			trigger_error("DELETE with no conditon", E_USER_ERROR);
			return null;
		}

		$sql = "DELETE FROM $tables $condition";

		return $sql;
	}

	/**
	 *	֥ȥץѥƥΥˡåԤSQLʸۤ
	 *
	 *	@access	private
	 *	@param	mixed	$key	ˡåԤץѥƥ̾
	 *	@return	string	ˡåԤSELECTʸ
	 */
	function _getSQL_Duplicate($key)
	{
		$tables = implode(',', array_keys($this->table_def));
		$columns = implode(',', array_keys($this->prop_def));	// any column will do

		$condition = null;
		// (ꤵƤץ饤ޥꥭϸоݤ)
		if (is_null($this->id) == false) {
			$primary_value = to_array($this->getId());
			$n = 0;
			foreach (to_array($this->id_def) as $k) {
				if (is_null($condition)) {
					$condition = "WHERE ";
				} else {
					$condition .= " AND ";
				}
				$value = $primary_value[$n];
				Ethna_AppSQL::escapeSQL($value);
				$condition .= Ethna_AppSQL::getCondition($k, $value, OBJECT_CONDITION_NE);
				$n++;
			}
		}

		foreach (to_array($key) as $k) {
			if (is_null($condition)) {
				$condition = "WHERE ";
			} else {
				$condition .= " AND ";
			}
			$v = $this->prop[$k];
			Ethna_AppSQL::escapeSQL($v);
			$condition .= Ethna_AppSQL::getCondition($k, $v);
		}

		$sql = "SELECT $columns FROM $tables $condition";

		return $sql;
	}

	/**
	 *	֥ȸ(offset, count)SQLʸۤ
	 *
	 *	@access	private
	 *	@param	array	$filter		
	 *	@return	string	뤿SELECTʸ
	 */
	function _getSQL_SearchLength($filter)
	{
		// ơ֥
		$tables = implode(',', array_keys($this->table_def));
		if ($this->_isAdditionalField($filter)) {
			$tables .= " " . $this->_SQLPlugin_SearchTable();
		}

		$id_def = to_array($this->id_def);
		$column_id = $this->_getPrimaryTable() . "." . $id_def[0];	// any id columns will do

		$condition = $this->_getSQL_SearchCondition($filter);
		$sql = "SELECT DISTINCT COUNT($column_id) AS id_count FROM $tables $condition";

		return $sql;
	}

	/**
	 *	֥IDԤSQLʸۤ
	 *
	 *	@access	private
	 *	@param	array	$filter		
	 *	@param	array	$order		̥Ⱦ
	 *	@param	int		$offset		̼եå
	 *	@param	int		$count		̼
	 *	@return	string	֥ȸԤSELECTʸ
	 */
	function _getSQL_SearchId($filter, $order, $offset, $count)
	{
		// ơ֥
		$tables = implode(',', array_keys($this->table_def));
		if ($this->_isAdditionalField($filter) || $this->_isAdditionalField($order)) {
			$tables .= " " . $this->_SQLPlugin_SearchTable();
		}

		$column_id = "";
		foreach (to_array($this->id_def) as $id) {
			if ($column_id != "") {
				$column_id .= ",";
			}
			$column_id .= $this->_getPrimaryTable() . "." . $id;
		}
		$condition = $this->_getSQL_SearchCondition($filter);

		$sort = "";
		if (is_array($order)) {
			foreach ($order as $k => $v) {
				if ($sort == "") {
					$sort = "ORDER BY ";
				} else {
					$sort .= ", ";
				}
				$sort .= sprintf("%s %s", $k, $v == OBJECT_SORT_ASC ? "ASC" : "DESC");
			}
		}

		$limit = "";
		if (is_null($count) == false) {
			$limit = "LIMIT ";
			if (is_null($offset) == false) {
				$limit .= sprintf("%d,", $offset);
			}
			$limit .= sprintf("%d", $count);
		}

		$sql = "SELECT DISTINCT $column_id FROM $tables $condition $sort $limit";

		return $sql;
	}

	/**
	 *	֥ȥץѥƥԤSQLʸۤ
	 *
	 *	@access	private
	 *	@param	array	$keys		ץѥƥ
	 *	@param	array	$filter		
	 *	@param	array	$order		̥Ⱦ
	 *	@param	int		$offset		̼եå
	 *	@param	int		$count		̼
	 *	@return	string	֥ȸԤSELECTʸ
	 */
	function _getSQL_SearchProp($keys, $filter, $order, $offset, $count)
	{
		// ơ֥
		$tables = implode(',', array_keys($this->table_def));
		if ($this->_isAdditionalField($filter) || $this->_isAdditionalField($order)) {
			$tables .= " " . $this->_SQLPlugin_SearchTable();
		}
		$p_table = $this->_getPrimaryTable();

		// ɲåץѥƥ
		if ($this->_isAdditionalField($filter) || $this->_isAdditionalField($order)) {
			$search_prop_def = $this->_SQLPlugin_SearchPropDef();
		} else {
			$search_prop_def = array();
		}
		$def = array_merge($this->getDef(), $search_prop_def);

		// 
		$column = "";
		if (is_null($keys)) {
			$keys = array_keys($def);
		}
		foreach (to_array($keys) as $key) {
			if (isset($def[$key]) == false) {
				continue;
			}
			if ($column != "") {
				$column .= ", ";
			}
			$t = isset($def[$key]['table']) ? $def[$key]['table'] : $p_table;
			$column .= sprintf("%s.%s", $t, $key);
		}

		$condition = $this->_getSQL_SearchCondition($filter);

		$sort = "";
		if (is_array($order)) {
			foreach ($order as $k => $v) {
				if ($sort == "") {
					$sort = "ORDER BY ";
				} else {
					$sort .= ", ";
				}
				$sort .= sprintf("%s %s", $k, $v == OBJECT_SORT_ASC ? "ASC" : "DESC");
			}
		}

		$limit = "";
		if (is_null($count) == false) {
			$limit = "LIMIT ";
			if (is_null($offset) == false) {
				$limit .= sprintf("%d,", $offset);
			}
			$limit .= sprintf("%d", $count);
		}

		$sql = "SELECT $column FROM $tables $condition $sort $limit";

		return $sql;
	}

	/**
	 *	֥ȸSQLξʸۤ
	 *
	 *	@access	private
	 *	@param	array	$filter		
	 *	@return	string	֥ȸξʸ(顼ʤnull)
	 */
	function _getSQL_SearchCondition($filter)
	{
		if (is_array($filter) == false) {
			return "";
		}

		$p_table = $this->_getPrimaryTable();

		// ɲåץѥƥ
		if ($this->_isAdditionalField($filter)) {
			$search_prop_def = $this->_SQLPlugin_SearchPropDef();
		} else {
			$search_prop_def = array();
		}
		$prop_def = array_merge($this->prop_def, $search_prop_def);

		$condition = null;
		foreach ($filter as $k => $v) {
			if (isset($prop_def[$k]) == false) {
				trigger_error(sprintf("Unknown property [%s]", $k), E_USER_ERROR);
				return null;
			}

			if (is_null($condition)) {
				$condition = "WHERE ";
			} else {
				$condition .= " AND ";
			}

			$t = isset($prop_def[$k]['table']) ? $prop_def[$k]['table'] : $p_table;

			if (is_object($v)) {
				// Ethna_AppSearchObjectꤵƤ
				$condition .= $v->toString("$t.$k");
			} else if (is_array($v) && count($v) > 0 && is_object($v[0])) {
				// Ethna_AppSearchObjectǻꤵƤ
				$n = 0;
				foreach ($v as $so) {
					if ($n > 0) {
						$condition .= " AND ";
					}
					$condition .= $so->toStrong("$t.$k");
					$n++;
				}
			} else if ($prop_def[$k]['type'] == VAR_TYPE_STRING) {
				// ά(ʸ)
				Ethna_AppSQL::escapeSQL($v);
				$condition .= Ethna_AppSQL::getCondition("$t.$k", $v, OBJECT_CONDITION_LIKE);
			} else {
				// ά()
				Ethna_AppSQL::escapeSQL($v);
				$condition .= Ethna_AppSQL::getCondition("$t.$k", $v, OBJECT_CONDITION_EQ);
			}
		}

		return $condition;
	}

	/**
	 *	֥ȸSQLץ饰(ɲåơ֥)
	 *
	 *	sample:
	 *	<code>
	 *	return " LEFT JOIN bar_tbl ON foo_tbl.user_id=bar_tbl.user_id";
	 *	</code>
	 *
	 *	@access	protected
	 *	@return	string	ơ֥JOINSQLʸ
	 */
	function _SQLPlugin_SearchTable()
	{
		return "";
	}

	/**
	 *	֥ȸSQLץ饰(ɲþ)
	 *
	 *	sample:
	 *	<code>
	 *	$search_prop_def = array(
	 *	  'group_id' => array(
	 *	    'primary' => true, 'key' => true, 'type' => VAR_TYPE_INT,
	 *	    'form_name' => 'group_id', 'table' => 'group_user_tbl',
	 *	  ),
	 *	);
	 *	return $search_prop_def;
	 *	</code>
	 *
	 *	@access	protected
	 *	@return	array	ɲþ
	 */
	function _SQLPlugin_SearchPropDef()
	{
	}

	/**
	 *	֥ȥץѥƥCSVǥפ
	 *
	 *	@access	protected
	 *	@return	string	׷
	 */
	function _dump_csv()
	{
		$dump = "";

		$n = 0;
		foreach ($this->getDef() as $k => $def) {
			if ($n > 0) {
				$dump .= ",";
			}
			$dump .= Ethna_Util::escapeCSV($this->getName($k));
			$n++;
		}

		return $dump;
	}

	/**
	 *	(|Ⱦ)եɤɲåեɤޤޤ뤫ɤ֤
	 *
	 *	@access	private
	 *	@param	array	$field	(|Ⱦ)
	 *	@return	bool	true:ޤޤ false:ޤޤʤ
	 */
	function _isAdditionalField($field)
	{
		if (is_array($field) == false) {
			return false;
		}

		$def = $this->getDef();
		foreach ($field as $key => $value) {
			if (array_key_exists($key, $def) == false) {
				return true;
			}
		}
		return false;
	}
}
// }}}
?>
