<?php
// vim: foldmethod=marker
/**
 *	Ethna_Logger.php
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@license	http://www.opensource.org/licenses/bsd-license.php The BSD License
 *	@package	Ethna
 *	@version	$Id: Ethna_Logger.php,v 1.3 2004/12/08 12:32:38 fujimoto Exp $
 */

/**
 *	ĥץѥƥ:	ե
 */
define('LOG_FILE', 1 << 16);

/**
 *	ĥץѥƥ:	ؿ̾ɽ
 */
define('LOG_FUNCTION', 1 << 17);


// {{{ ethna_error_handler
/**
 *	顼Хåؿ
 *
 *	@param	int		$errno		顼٥
 *	@param	string	$errstr		顼å
 *	@param	string	$errfile	顼ȯսΥե̾
 *	@param	string	$errline	顼ȯսιֹ
 */
function ethna_error_handler($errno, $errstr, $errfile, $errline)
{
	$c =& Ethna_Controller::getInstance();

	list($level, $name) = Ethna_Logger::errorLevelToLogLevel($errno);
	if ($errno == E_STRICT) {
		// E_STRICTɽʤ
		return E_STRICT;
	}

	$logger =& $c->getLogger();
	$logger->log($level, sprintf("[PHP] %s: %s in %s on line %d", $code, $errstr, $errfile, $errline));
}
// }}}

// {{{ Ethna_Logger
/**
 *	饹
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@access		public
 *	@package	Ethna
 */
class Ethna_Logger extends Ethna_AppManager
{
	/**#@+
	 *	@access	private
	 */

	/**
	 *	@var	array	եƥ
	 */
	var $log_facility_list = array(
		'auth' => array('name' => 'LOG_AUTH'),
		'authpriv' => array('name' => 'LOG_AUTHPRIV'),
		'cron' => array('name' => 'LOG_CRON'),
		'daemon' => array('name' => 'LOG_DAEMON'),
		'kern' => array('name' => 'LOG_KERN'),
		'local0' => array('name' => 'LOG_LOCAL0'),
		'local1' => array('name' => 'LOG_LOCAL1'),
		'local2' => array('name' => 'LOG_LOCAL2'),
		'local3' => array('name' => 'LOG_LOCAL3'),
		'local4' => array('name' => 'LOG_LOCAL4'),
		'local5' => array('name' => 'LOG_LOCAL5'),
		'local6' => array('name' => 'LOG_LOCAL6'),
		'local7' => array('name' => 'LOG_LOCAL7'),
		'lpr' => array('name' => 'LOG_LPR'),
		'mail' => array('name' => 'LOG_MAIL'),
		'news' => array('name' => 'LOG_NEWS'),
		'syslog' => array('name' => 'LOG_SYSLOG'),
		'user' => array('name' => 'LOG_USER'),
		'uucp' => array('name' => 'LOG_UUCP'),
		'file' => array('name' => 'LOG_FILE'),
	);

	/**
	 *	@var	array	٥
	 */
	var $log_level_list = array(
		'emerg' => array('name' => 'LOG_EMERG'),
		'alert' => array('name' => 'LOG_ALERT'),
		'crit' => array('name' => 'LOG_CRIT'),
		'err' => array('name' => 'LOG_ERR'),
		'warning' => array('name' => 'LOG_WARNING'),
		'notice' => array('name' => 'LOG_NOTICE'),
		'info' => array('name' => 'LOG_INFO'),
		'debug' => array('name' => 'LOG_DEBUG'),
	);

	/**
	 *	@var	array	ץ
	 */
	var $log_option_list = array(
		'pid' => array('name' => 'PIDɽ', 'value' => LOG_PID),
		'function' => array('name' => 'ؿ̾ɽ', 'value' => LOG_FUNCTION),
	);

	/**
	 *	@var	array	٥ơ֥
	 */
	var $level_table = array(
		LOG_EMERG	=> 7,
		LOG_ALERT	=> 6,
		LOG_CRIT	=> 5,
		LOG_ERR		=> 4,
		LOG_WARNING	=> 3,
		LOG_NOTICE	=> 2,
		LOG_INFO	=> 1,
		LOG_DEBUG	=> 0,
	);

	/**
	 *	@var	object	Ethna_Controller	controller֥
	 */
	var	$controller;

	/**
	 *	@var	int		٥
	 */
	var $level;

	/**
	 *	@var	int		顼ȥ٥
	 */
	var $alert_level;

	/**
	 *	@var	string	顼ȥ᡼륢ɥ쥹
	 */
	var $alert_mailaddress;

	/**
	 *	@var	string	åե륿()
	 */
	var $message_filter_do;

	/**
	 *	@var	string	åե륿(̵)
	 */
	var $message_filter_ignore;

	/**
	 *	@var	object	Ethna_LogWriter	ϥ֥
	 */
	var	$writer;

	/**#@-*/
	
	/**
	 *	Ethna_Logger饹Υ󥹥ȥ饯
	 *
	 *	@access	public
	 *	@param	object	Ethna_Controller	$controller	controller֥
	 */
	function Ethna_Logger(&$controller)
	{
		$this->controller =& $controller;
		$config =& $controller->getConfig();
		
		// μ
		$this->level = $this->_parseLogLevel($config->get('log_level'));
		if (is_null($this->level)) {
			// ̤ʤLOG_WARNING
			$this->level = LOG_WARNING;
		}
		$facility = $this->_parseLogFacility($config->get('log_facility'));
		$file = sprintf('%s/%s.log', $controller->getDirectory('log'), strtolower($controller->getAppid()));
		$option = $this->_parseLogOption($config->get('log_option'));
		$this->alert_level = $this->_parseLogLevel($config->get('log_alert_level'));
		$this->alert_mailaddress = preg_split('/\s*,\s*/', $config->get('log_alert_mailaddress'));
		$this->message_filter_do = $config->get('log_filter_do');
		$this->message_filter_ignore = $config->get('log_filter_ignore');

		if ($facility == LOG_FILE) {
			$writer_class = "Ethna_LogWriter_File";
		} else if (is_null($facility)) {
			$writer_class = "Ethna_LogWriter";
		} else {
			$writer_class = "Ethna_LogWriter_Syslog";
		}
		$this->writer =& new $writer_class($controller->getAppId(), $facility, $file, $option);

		set_error_handler("ethna_error_handler");
	}

	/**
	 *	PHP顼٥٥Ѵ
	 *
	 *	@access	public
	 *	@param	int		$errno	PHP顼٥
	 *	@return	array	٥(LOG_NOTICE,...), 顼٥ɽ̾("E_NOTICE"...)
	 *	@static
	 */
	function errorLevelToLogLevel($errno)
	{
		switch ($errno) {
		case E_ERROR:			$code = "E_ERROR"; $level = LOG_ERR; break;
		case E_WARNING:			$code = "E_WARNING"; $level = LOG_WARNING; break;
		case E_PARSE:			$code = "E_PARSE"; $level = LOG_CRIT; break;
		case E_NOTICE:			$code = "E_NOTICE"; $level = LOG_NOTICE; break;
		case E_USER_ERROR:		$code = "E_USER_ERROR"; $level = LOG_ERR; break;
		case E_USER_WARNING:	$code = "E_USER_WARNING"; $level = LOG_WARNING; break;
		case E_USER_NOTICE:		$code = "E_USER_NOTICE"; $level = LOG_NOTICE; break;
		case E_STRICT:			$code = "E_STRING"; $level = LOG_NOTICE; return;
		default:				$code = "E_UNKNOWN"; $level = LOG_DEBUG; break;
		}
		return array($level, $code);
	}

	/**
	 *	Ϥ򳫻Ϥ
	 *
	 *	@access	public
	 */
	function begin()
	{
		$this->writer->begin();
	}

	/**
	 *	Ϥ
	 *
	 *	@access	public
	 *	@param	int		$level		٥(LOG_DEBUG, LOG_NOTICE...)
	 *	@param	string	$message	å(+)
	 */
	function log($level, $message)
	{
		// åե륿(٥ե륿ͥ褹)
		$r = $this->_evalMessageMask($message);
		if ($r === false) {
			return;
		}

		// ٥ե륿
		if ($r !== true && $this->_evalLevelMask($this->level, $level)) {
			return;
		}

		// 
		$args = func_get_args();
		if (count($args) > 2) {
			array_splice($args, 0, 2);
			$message = vsprintf($message, $args);
		}
		$output = $this->writer->log($level, $message);

		// 顼Ƚ
		if ($this->_evalLevelMask($this->alert_level, $level) == false) {
			if (count($this->alert_mailaddress) > 0) {
				$this->_alert($output);
			}
		}
	}

	/**
	 *	Ϥλ
	 *
	 *	@access	public
	 */
	function end()
	{
		$this->writer->end();
	}

	/**
	 *	ץ(ե)Ϥ
	 *
	 *	@access	private
	 *	@param	string	$string	ץ(ե)
	 *	@return	array	Ϥ줿ե(顼Υ᡼륢ɥ쥹, 顼оݥ٥, ץ)
	 */
	function _parseLogOption($string)
	{
		$option = null;
		$elts = explode(',', $string);
		foreach ($elts as $elt) {
			if ($elt == 'pid') {
				$option |= LOG_PID;
			} else if ($elt == 'function') {
				$option |= LOG_FUNCTION;
			}
		}

		return $option;
	}

	/**
	 *	顼ȥ᡼
	 *
	 *	@access	protected
	 *	@param	string	$message	å
	 *	@return	int		0:ｪλ
	 */
	function _alert($message)
	{
		restore_error_handler();

		// إå
		$header = "Mime-Version: 1.0\n";
		$header .= "Content-Type: text/plain; charset=ISO-2022-JP\n";
		$header .= "X-Alert: " . $this->writer->getIdent();
		$subject = sprintf("[%s] alert (%s%s)\n", $this->writer->getIdent(), substr($message, 0, 12), strlen($message) > 12 ? "..." : "");
		
		// ʸ
		$mail = sprintf("--- [log message] ---\n%s\n\n", $message);
		if (function_exists("debug_backtrace")) {
			$bt = debug_backtrace();
			$mail .= sprintf("--- [backtrace] ---\n%s\n", Ethna_Util::FormatBacktrace($bt));
		}

		foreach ($this->alert_mailaddress as $mailaddress) {
			mail($mailaddress, $subject, mb_convert_encoding($mail, "ISO-2022-JP", "EUC-JP"), $header);
		}

		set_error_handler("ethna_error_handler");

		return 0;
	}

	/**
	 *	åΥޥåԤ
	 *
	 *	@access	private
	 *	@param	string	$message	å
	 *	@return	mixed	true: false:̵ null:å
	 */
	function _evalMessageMask($message)
	{
		$regexp_do = sprintf("/%s/", $this->message_filter_do);
		$regexp_ignore = sprintf("/%s/", $this->message_filter_ignore);

		if ($this->message_filter_do && preg_match($regexp_do, $message)) {
			return true;
		}
		if ($this->message_filter_ignore && preg_match($regexp_ignore, $message)) {
			return false;
		}
		return null;
	}

	/**
	 *	٥ΥޥåԤ
	 *
	 *	@access	private
	 *	@param	int		$src	٥ޥ
	 *	@param	int		$dst	٥
	 *	@return	bool	true:Ͱʲ false:Ͱʾ
	 */
	function _evalLevelMask($src, $dst)
	{
		// Τʤ٥ʤϤʤ
		if (isset($this->level_table[$src]) == false || isset($this->level_table[$dst]) == false) {
			return true;
		}

		if ($this->level_table[$dst] >= $this->level_table[$src]) {
			return false;
		}

		return true;
	}

	/**
	 *	եƥ(ե)Ϥ
	 *
	 *	@access	private
	 *	@param	string	$facility	եƥ(ե)
	 *	@return	int		եƥ(LOG_LOCAL0, LOG_FILE...)
	 */
	function _parseLogFacility($facility)
	{
		$facility_map_table = array(
			'auth'		=> LOG_AUTH,
			'authpriv'	=> LOG_AUTHPRIV,
			'cron'		=> LOG_CRON,
			'daemon'	=> LOG_DAEMON,
			'kern'		=> LOG_KERN,
			'local0'	=> LOG_LOCAL0,
			'local1'	=> LOG_LOCAL1,
			'local2'	=> LOG_LOCAL2,
			'local3'	=> LOG_LOCAL3,
			'local4'	=> LOG_LOCAL4,
			'local5'	=> LOG_LOCAL5,
			'local6'	=> LOG_LOCAL6,
			'local7'	=> LOG_LOCAL7,
			'lpr'		=> LOG_LPR,
			'mail'		=> LOG_MAIL,
			'news'		=> LOG_NEWS,
			'syslog'	=> LOG_SYSLOG,
			'user'		=> LOG_USER,
			'uucp'		=> LOG_UUCP,
			'file'		=> LOG_FILE,
		);
		if (isset($facility_map_table[strtolower($facility)]) == false) {
			return null;
		}
		return $facility_map_table[strtolower($facility)];
	}

	/**
	 *	٥(ե)Ϥ
	 *
	 *	@access	private
	 *	@param	string	$level	٥(ե)
	 *	@return	int		٥(LOG_DEBUG, LOG_NOTICE...)
	 */
	function _parseLogLevel($level)
	{
		$level_map_table = array(
			'emerg'		=> LOG_EMERG,
			'alert'		=> LOG_ALERT,
			'crit'		=> LOG_CRIT,
			'err'		=> LOG_ERR,
			'warning'	=> LOG_WARNING,
			'notice'	=> LOG_NOTICE,
			'info'		=> LOG_INFO,
			'debug'		=> LOG_DEBUG,
		);
		if (isset($level_map_table[strtolower($level)]) == false) {
			return null;
		}
		return $level_map_table[strtolower($level)];
	}
}
// }}}
?>
