/*
 * Decompiled with CFR 0.152.
 */
package estoc.dbm;

import estoc.dbm.ColumnInfo;
import estoc.dbm.TableAccess;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

class TableAccessPgsql
extends TableAccess {
    public TableAccessPgsql(Connection connection) {
        super(connection);
    }

    @Override
    public void drop(Class<?> clazz) throws SQLException {
        String string = this.getTableName(clazz);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DROP TABLE IF EXISTS ").append(string).toString();
        this.executeDiretory(stringBuilder.toString());
        List<ColumnInfo> list = this.getColumnInfo(clazz);
        for (ColumnInfo columnInfo : list) {
            if (!columnInfo.isAutoInc()) continue;
            this.executeDiretory("DROP SEQUENCE IF EXISTS " + this.getSeqName(string, columnInfo.getName()));
        }
    }

    private String getSeqName(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append("_").append(string2).append("_seq");
        return stringBuilder.toString();
    }

    @Override
    public void create(Class<?> clazz) throws SQLException {
        String string = this.getTableName(clazz);
        List<ColumnInfo> list = this.getColumnInfo(clazz);
        this.validate(list);
        String string2 = this.createTableSql(string, list);
        this.executeDiretory(string2);
        for (ColumnInfo columnInfo : list) {
            if (!columnInfo.isIndex()) continue;
            string2 = this.createIndexSql(string, columnInfo);
            this.executeDiretory(string2);
        }
    }

    private void validate(List<ColumnInfo> list) {
        boolean bl = false;
        for (ColumnInfo columnInfo : list) {
            if (columnInfo.isPk() && columnInfo.isTimeStamp()) {
                throw new UnsupportedOperationException("@Pk and @TimeStam are can't define together");
            }
            if (!columnInfo.isAutoInc()) continue;
            if (bl) {
                throw new UnsupportedOperationException("@AutoInc can't define multi columns");
            }
            bl = true;
            if (columnInfo.getType() == Integer.class) continue;
            throw new UnsupportedOperationException("@AutoInc must be Integer type");
        }
    }

    private String createTableSql(String string, List<ColumnInfo> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" CREATE TABLE ").append(string).append(" ( ");
        boolean bl = false;
        for (ColumnInfo columnInfo : list) {
            if (bl) {
                stringBuilder.append(",");
            } else {
                bl = true;
            }
            stringBuilder.append(columnInfo.getName()).append(" ");
            if (!columnInfo.isAutoInc()) {
                stringBuilder.append(this.getDbType(columnInfo.getType(), columnInfo.getTypeOpt1(), columnInfo.getTypeOpt2()));
            }
            if (!columnInfo.isAutoInc() && (columnInfo.isNotNull() || columnInfo.isPk())) {
                stringBuilder.append(" NOT NULL ");
            }
            if (columnInfo.isAutoInc()) {
                stringBuilder.append(" SERIAL ");
            }
            if (columnInfo.isPk()) {
                stringBuilder.append(" PRIMARY KEY ");
            }
            if (columnInfo.isAutoInc() || !columnInfo.isUnique()) continue;
            stringBuilder.append(" UNIQUE ");
        }
        stringBuilder.append(" ) ");
        return stringBuilder.toString();
    }

    private String createIndexSql(String string, ColumnInfo columnInfo) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" CREATE INDEX ").append("idx_").append(columnInfo.getName());
        stringBuilder.append(" ON ").append(string).append(" (").append(columnInfo.getName()).append(")");
        return stringBuilder.toString();
    }

    @Override
    protected String getBinaryType(int n) {
        return "bytea";
    }

    @Override
    protected String getDateType(int n) {
        return "timestamp without time zone";
    }

    @Override
    protected String getIntType(int n) {
        return "integer";
    }

    @Override
    protected String getStringType(int n) {
        if (n == -1) {
            return "varchar";
        }
        return "varchar(" + n + ")";
    }

    @Override
    protected String getBooleanType(int n) {
        return "boolean";
    }

    @Override
    protected String getDoubleType(int n) {
        return "double precision";
    }

    @Override
    protected String getDecimalType(int n, int n2) {
        if (n == -1) {
            n = 10;
        }
        if (n2 == -1) {
            n2 = 0;
        }
        return "numeric(" + n + "," + n2 + ")";
    }
}

