/*
 * Decompiled with CFR 0.152.
 */
package estoc.dbm;

import estoc.dbm.ColumnInfo;
import estoc.dbm.TableAccess;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

class TableAccessMysql
extends TableAccess {
    public TableAccessMysql(Connection connection) {
        super(connection);
    }

    @Override
    public void drop(Class<?> clazz) throws SQLException {
        String string = this.getTableName(clazz);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DROP TABLE IF EXISTS ").append(string).toString();
        this.executeDiretory(stringBuilder.toString());
    }

    @Override
    public void create(Class<?> clazz) throws SQLException {
        String string = this.getTableName(clazz);
        List<ColumnInfo> list = this.getColumnInfo(clazz);
        this.validate(list);
        String string2 = this.createTableSql(string, list);
        this.executeDiretory(string2);
        for (ColumnInfo columnInfo : list) {
            if (!columnInfo.isIndex()) continue;
            string2 = this.createIndexSql(string, columnInfo);
            this.executeDiretory(string2);
        }
    }

    private void validate(List<ColumnInfo> list) {
        boolean bl = false;
        for (ColumnInfo columnInfo : list) {
            if (columnInfo.isPk() && columnInfo.isTimeStamp()) {
                throw new UnsupportedOperationException("@Pk and @TimeStam are can't define together");
            }
            if (!columnInfo.isAutoInc()) continue;
            if (bl) {
                throw new UnsupportedOperationException("@AutoInc can't define multi columns");
            }
            bl = true;
            if (columnInfo.isPk()) continue;
            throw new UnsupportedOperationException("@AutoInc must be defined as a PK");
        }
    }

    private String createTableSql(String string, List<ColumnInfo> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" CREATE TABLE IF NOT EXISTS ").append(string).append(" ( ");
        boolean bl = false;
        for (ColumnInfo columnInfo : list) {
            if (bl) {
                stringBuilder.append(",");
            } else {
                bl = true;
            }
            stringBuilder.append("`").append(columnInfo.getName()).append("` ");
            stringBuilder.append(this.getDbType(columnInfo.getType(), columnInfo.getTypeOpt1(), columnInfo.getTypeOpt2()));
            if (columnInfo.isNotNull() || columnInfo.isPk()) {
                stringBuilder.append(" NOT NULL ");
            }
            if (columnInfo.isAutoInc()) {
                stringBuilder.append(" AUTO_INCREMENT ");
            }
            if (columnInfo.isPk()) {
                stringBuilder.append(" PRIMARY KEY ");
            }
            if (!columnInfo.isUnique()) continue;
            stringBuilder.append(" UNIQUE ");
        }
        stringBuilder.append(" ) ");
        return stringBuilder.toString();
    }

    private String createIndexSql(String string, ColumnInfo columnInfo) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" CREATE INDEX ");
        stringBuilder.append("`").append("idx_").append(columnInfo.getName()).append("`");
        stringBuilder.append(" ON ").append(string).append(" (`").append(columnInfo.getName()).append("`)");
        return stringBuilder.toString();
    }

    @Override
    protected String getBinaryType(int n) {
        if (n == -1) {
            return "BLOB";
        }
        return "BLOB(" + n + ")";
    }

    @Override
    protected String getDateType(int n) {
        return "TIMESTAMP";
    }

    @Override
    protected String getIntType(int n) {
        return "INT";
    }

    @Override
    protected String getStringType(int n) {
        if (n == -1) {
            return "VARCHAR(125)";
        }
        return "VARCHAR(" + n + ")";
    }

    @Override
    protected String getBooleanType(int n) {
        return "TINYINT";
    }

    @Override
    protected String getDoubleType(int n) {
        return "DOUBLE";
    }

    @Override
    protected String getDecimalType(int n, int n2) {
        if (n == -1) {
            n = 10;
        }
        if (n2 == -1) {
            n2 = 0;
        }
        return "DECIMAL(" + n + "," + n2 + ")";
    }
}

