/*
 * Decompiled with CFR 0.152.
 */
package estoc.dbm;

import estoc.dbm.ColumnInfo;
import estoc.dbm.TypedNull;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;

public class DbmUtil {
    private static final Object[] EMPTY_ARRAY = new Object[0];

    public static String toCommaString(Object[] objectArray, String string, String string2) {
        String string3 = "";
        if (string2 != null) {
            string3 = string2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < objectArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(string3).append(objectArray[i].toString()).append(string3);
        }
        return stringBuilder.toString();
    }

    public static <T> T fillData(Class<T> clazz, ResultSet resultSet) throws SQLException {
        try {
            T t = clazz.newInstance();
            for (Field field : clazz.getDeclaredFields()) {
                ColumnInfo columnInfo = new ColumnInfo(field);
                if (!columnInfo.isColumn()) continue;
                if (columnInfo.isTimeStamp()) {
                    Date date = (Date)resultSet.getObject(field.getName());
                    DbmUtil.setVlaueToField(t, columnInfo, new Date(date.getTime()));
                    continue;
                }
                DbmUtil.setVlaueToField(t, columnInfo, resultSet.getObject(columnInfo.getName()));
            }
            return t;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException);
        }
    }

    public static void setVlaueToField(Object object, ColumnInfo columnInfo, Object object2) {
        String string = DbmUtil.getSetterName(columnInfo.getName());
        try {
            try {
                Class[] classArray = new Class[]{columnInfo.getType()};
                Method method = object.getClass().getDeclaredMethod(string, classArray);
                method.invoke(object, object2);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                columnInfo.getField().set(object, object2);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static Object getVlaueFromField(Object object, ColumnInfo columnInfo) {
        String string = DbmUtil.getGetterName(columnInfo.getName());
        Object object2 = null;
        try {
            try {
                Object var4_4 = null;
                Method method = object.getClass().getDeclaredMethod(string, var4_4);
                object2 = method.invoke(object, EMPTY_ARRAY);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                object2 = columnInfo.getField().get(object);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (object2 == null) {
            object2 = new TypedNull(columnInfo.getType());
        }
        return object2;
    }

    private static String getSetterName(String string) {
        String string2 = string.substring(0, 1);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("set").append(string2.toUpperCase()).append(string.substring(1));
        return stringBuilder.toString();
    }

    private static String getGetterName(String string) {
        String string2 = string.substring(0, 1);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("get").append(string2.toUpperCase()).append(string.substring(1));
        return stringBuilder.toString();
    }
}

