/*
 * Decompiled with CFR 0.152.
 */
package estoc.dbm;

import estoc.dbm.ColumnInfo;
import estoc.dbm.DataAccess;
import estoc.dbm.DbmUtil;
import estoc.dbm.SqlCreator;
import estoc.dbm.TypedNull;
import estoc.dbm.annotate.Table;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

class DataAccessOracleImpl
implements DataAccess {
    private static final Logger LOG = Logger.getLogger("global");
    private final Connection connection;
    private final SqlCreator creator;
    Map<Class<?>, List<ColumnInfo>> fieldMap = new HashMap();
    Map<Class<?>, PreparedStatement> selectStmts = new HashMap();
    Map<Class<?>, PreparedStatement> insertStmts = new HashMap();
    Map<Class<?>, PreparedStatement> autoKeyStmts = new HashMap();
    Map<Class<?>, PreparedStatement> updateStmts = new HashMap();
    Map<Class<?>, PreparedStatement> deleteStmts = new HashMap();

    public DataAccessOracleImpl(Connection connection, SqlCreator sqlCreator) {
        this.connection = connection;
        this.creator = sqlCreator;
    }

    private List<ColumnInfo> getDeclaredFields(Class<?> clazz) {
        List<ColumnInfo> list = this.fieldMap.get(clazz);
        if (list == null) {
            Field[] fieldArray;
            list = new ArrayList<ColumnInfo>();
            for (Field field : fieldArray = clazz.getDeclaredFields()) {
                list.add(new ColumnInfo(field));
            }
            this.fieldMap.put(clazz, list);
        }
        return list;
    }

    @Override
    public <T> T select(Class<T> clazz, Object ... objectArray) throws SQLException {
        PreparedStatement preparedStatement = this.selectStmts.get(clazz);
        if (preparedStatement == null || preparedStatement.getConnection() != this.connection) {
            preparedStatement = this.createSelectStmt(clazz);
        }
        this.setParams(preparedStatement, objectArray);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet != null && resultSet.next()) {
            return DbmUtil.fillData(clazz, resultSet);
        }
        return null;
    }

    private <T> PreparedStatement createSelectStmt(Class<T> clazz) throws SQLException {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        LinkedHashSet<String> linkedHashSet2 = new LinkedHashSet<String>();
        for (Field field : clazz.getDeclaredFields()) {
            ColumnInfo columnInfo = new ColumnInfo(field);
            if (!columnInfo.isColumn()) continue;
            linkedHashSet.add(field.getName());
            if (!columnInfo.isPk()) continue;
            linkedHashSet2.add(field.getName());
        }
        if (linkedHashSet2.size() == 0) {
            throw new UnsupportedOperationException("When if you use SELECT, table have to be defined PK");
        }
        String string = this.getTableName(clazz);
        String string2 = this.creator.getSelectSql(string, linkedHashSet2, linkedHashSet);
        PreparedStatement preparedStatement = this.connection.prepareStatement(string2);
        this.selectStmts.put(clazz, preparedStatement);
        return preparedStatement;
    }

    @Override
    public boolean delete(Object object) throws SQLException {
        Class<?> clazz = object.getClass();
        PreparedStatement preparedStatement = this.deleteStmts.get(clazz);
        if (preparedStatement == null || preparedStatement.getConnection() != this.connection) {
            preparedStatement = this.createDeleteStmt(clazz);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (ColumnInfo columnInfo : this.getDeclaredFields(clazz)) {
            if (!columnInfo.isPk()) continue;
            arrayList.add(DbmUtil.getVlaueFromField(object, columnInfo));
        }
        this.setParams(preparedStatement, arrayList.toArray());
        return preparedStatement.executeUpdate() == 1;
    }

    private PreparedStatement createDeleteStmt(Class<?> clazz) throws SQLException {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (ColumnInfo object2 : this.getDeclaredFields(clazz)) {
            if (!object2.isPk()) continue;
            linkedHashSet.add(object2.getName());
        }
        if (linkedHashSet.size() == 0) {
            throw new UnsupportedOperationException("When if you use DELETE, table have to be defined PK");
        }
        String string = this.getTableName(clazz);
        String string2 = this.creator.getDeleteSql(string, linkedHashSet);
        LOG.info("sql = " + string2);
        PreparedStatement preparedStatement = this.connection.prepareStatement(string2);
        this.deleteStmts.put(clazz, preparedStatement);
        return preparedStatement;
    }

    @Override
    public <T> T insert(T t) throws SQLException {
        AutoCloseable autoCloseable;
        Class<?> clazz = t.getClass();
        PreparedStatement preparedStatement = this.autoKeyStmts.containsKey(clazz) ? this.autoKeyStmts.get(clazz) : this.createGetKeyStmt(clazz);
        int n = -1;
        if (preparedStatement != null) {
            autoCloseable = preparedStatement.executeQuery();
            if (autoCloseable.next()) {
                n = autoCloseable.getInt(1);
            } else {
                throw new RuntimeException("Faild to get nextval for auto inc.");
            }
        }
        if ((autoCloseable = this.insertStmts.get(clazz)) == null || autoCloseable.getConnection() != this.connection) {
            autoCloseable = this.createInsertStmt(clazz);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Date date = new Date();
        ColumnInfo columnInfo = null;
        ArrayList<ColumnInfo> arrayList2 = new ArrayList<ColumnInfo>();
        for (ColumnInfo columnInfo2 : this.getDeclaredFields(clazz)) {
            if (!columnInfo2.isColumn()) continue;
            if (columnInfo2.isAutoInc()) {
                columnInfo = columnInfo2;
                arrayList.add(n);
                continue;
            }
            if (columnInfo2.isTimeStamp()) {
                arrayList2.add(columnInfo2);
                arrayList.add(date);
                continue;
            }
            arrayList.add(DbmUtil.getVlaueFromField(t, columnInfo2));
        }
        this.setParams((PreparedStatement)autoCloseable, arrayList.toArray());
        if (autoCloseable.executeUpdate() == 1) {
            for (ColumnInfo columnInfo2 : arrayList2) {
                DbmUtil.setVlaueToField(t, columnInfo2, date);
            }
            if (columnInfo != null) {
                if (columnInfo.getType() == Integer.class) {
                    DbmUtil.setVlaueToField(t, columnInfo, new Integer(n));
                } else if (columnInfo.getType() == Long.class) {
                    DbmUtil.setVlaueToField(t, columnInfo, new Long(n));
                } else {
                    throw new UnsupportedOperationException("Unsupport type:" + columnInfo.getType());
                }
            }
            return t;
        }
        return null;
    }

    private PreparedStatement createGetKeyStmt(Class<?> clazz) throws SQLException {
        String string = null;
        for (ColumnInfo columnInfo : this.getDeclaredFields(clazz)) {
            if (!columnInfo.isColumn() || !columnInfo.isAutoInc()) continue;
            string = columnInfo.getName();
            break;
        }
        if (string == null) {
            this.autoKeyStmts.put(clazz, null);
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT ").append("seq_").append(this.getTableName(clazz)).append("_").append(string).append(".nextval FROM dual");
        PreparedStatement preparedStatement = this.connection.prepareStatement(stringBuilder.toString());
        this.autoKeyStmts.put(clazz, preparedStatement);
        return preparedStatement;
    }

    private PreparedStatement createInsertStmt(Class<?> clazz) throws SQLException {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (ColumnInfo object2 : this.getDeclaredFields(clazz)) {
            if (!object2.isColumn()) continue;
            linkedHashSet.add(object2.getName());
        }
        String string = this.getTableName(clazz);
        String string2 = this.creator.getInsertSql(string, linkedHashSet);
        LOG.info("sql= " + string2);
        PreparedStatement preparedStatement = this.connection.prepareStatement(string2);
        this.insertStmts.put(clazz, preparedStatement);
        return preparedStatement;
    }

    @Override
    public <T> T update(T t) throws SQLException {
        Class<?> clazz = t.getClass();
        PreparedStatement preparedStatement = this.updateStmts.get(clazz);
        if (preparedStatement == null || preparedStatement.getConnection() != this.connection) {
            preparedStatement = this.createUpdateStmt(clazz);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList<ColumnInfo> arrayList3 = new ArrayList<ColumnInfo>();
        Date date = new Date();
        for (ColumnInfo object : this.getDeclaredFields(clazz)) {
            if (object.isPk()) {
                arrayList2.add(DbmUtil.getVlaueFromField(t, object));
                continue;
            }
            if (!object.isColumn()) continue;
            if (object.isTimeStamp()) {
                arrayList3.add(object);
                arrayList.add(date);
                continue;
            }
            arrayList.add(DbmUtil.getVlaueFromField(t, object));
        }
        ArrayList arrayList4 = new ArrayList();
        arrayList4.addAll(arrayList);
        arrayList4.addAll(arrayList2);
        this.setParams(preparedStatement, arrayList4.toArray());
        if (preparedStatement.executeUpdate() == 1) {
            for (ColumnInfo columnInfo : arrayList3) {
                DbmUtil.setVlaueToField(t, columnInfo, date);
            }
            return t;
        }
        return null;
    }

    private PreparedStatement createUpdateStmt(Class<?> clazz) throws SQLException {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        LinkedHashSet<String> linkedHashSet2 = new LinkedHashSet<String>();
        for (ColumnInfo object2 : this.getDeclaredFields(clazz)) {
            if (object2.isPk()) {
                linkedHashSet.add(object2.getName());
                continue;
            }
            if (!object2.isColumn()) continue;
            linkedHashSet2.add(object2.getName());
        }
        if (linkedHashSet.size() == 0) {
            throw new UnsupportedOperationException("When if you use UPDATE, table have to be defined PK");
        }
        String string = this.getTableName(clazz);
        String string2 = this.creator.getUpdateSql(string, linkedHashSet, linkedHashSet2);
        LOG.info("sql= " + string2);
        PreparedStatement preparedStatement = this.connection.prepareStatement(string2);
        this.updateStmts.put(clazz, preparedStatement);
        return preparedStatement;
    }

    private String getTableName(Class<?> clazz) {
        Table table = clazz.getAnnotation(Table.class);
        return table.value();
    }

    private int getSqlType(Class<?> clazz) {
        if (clazz == String.class) {
            return 12;
        }
        if (clazz == Date.class) {
            return 91;
        }
        if (clazz == Integer.class) {
            return 4;
        }
        if (clazz == BigDecimal.class) {
            return 3;
        }
        if (clazz == Double.class) {
            return 8;
        }
        if (clazz == Boolean.class) {
            return 16;
        }
        if (clazz == byte[].class) {
            return -3;
        }
        throw new UnsupportedOperationException("Unsupport type " + clazz);
    }

    private void setParams(PreparedStatement preparedStatement, Object[] objectArray) throws SQLException {
        int n = 1;
        for (Object object : objectArray) {
            Class<?> clazz;
            if (object instanceof TypedNull) {
                clazz = ((TypedNull)object).getType();
                int n2 = this.getSqlType(clazz);
                preparedStatement.setNull(n, n2);
            } else {
                clazz = object.getClass();
                if (clazz == String.class) {
                    preparedStatement.setString(n, (String)object);
                } else if (clazz == Date.class) {
                    Date date = (Date)object;
                    preparedStatement.setTimestamp(n, new Timestamp(date.getTime()));
                } else if (clazz == Integer.class) {
                    preparedStatement.setInt(n, (Integer)object);
                } else if (clazz == BigDecimal.class) {
                    preparedStatement.setBigDecimal(n, (BigDecimal)object);
                } else if (clazz == Double.class) {
                    preparedStatement.setDouble(n, (Double)object);
                } else if (clazz == Boolean.class) {
                    preparedStatement.setBoolean(n, (Boolean)object);
                } else if (clazz == byte[].class) {
                    byte[] byArray = (byte[])object;
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    preparedStatement.setBinaryStream(n, (InputStream)byteArrayInputStream, byArray.length);
                } else {
                    throw new UnsupportedOperationException("Unsupport type " + object);
                }
            }
            ++n;
        }
    }
}

