/*
 * Decompiled with CFR 0.152.
 */
package estoc.dbm;

import estoc.dbm.DataAccess;
import estoc.dbm.DataAccessImpl;
import estoc.dbm.DataAccessOracleImpl;
import estoc.dbm.DataAccessPgsqlImpl;
import estoc.dbm.DbType;
import estoc.dbm.SqlCreatorImpl;
import estoc.dbm.TableAccess;
import estoc.dbm.TableAccessDerby;
import estoc.dbm.TableAccessH2;
import estoc.dbm.TableAccessMysql;
import estoc.dbm.TableAccessOracle;
import estoc.dbm.TableAccessPgsql;
import java.sql.Connection;

public class AccessManager {
    private final DbType dbType;

    public AccessManager(DbType dbType) {
        if (dbType == null) {
            throw new IllegalArgumentException();
        }
        this.dbType = dbType;
    }

    public DataAccess getDataAccess(Connection connection) {
        SqlCreatorImpl sqlCreatorImpl = new SqlCreatorImpl();
        switch (this.dbType) {
            case H2: 
            case Derby: {
                return new DataAccessImpl(connection, sqlCreatorImpl);
            }
            case Mysql: {
                sqlCreatorImpl.setColumnQuoter("`");
                return new DataAccessImpl(connection, sqlCreatorImpl);
            }
            case Postgresql: {
                return new DataAccessPgsqlImpl(connection, sqlCreatorImpl);
            }
            case Oracle: {
                return new DataAccessOracleImpl(connection, sqlCreatorImpl);
            }
        }
        throw new UnsupportedOperationException("DbType=" + (Object)((Object)this.dbType));
    }

    public TableAccess getTableAccess(Connection connection) {
        TableAccess tableAccess = null;
        switch (this.dbType) {
            case H2: {
                tableAccess = new TableAccessH2(connection);
                break;
            }
            case Derby: {
                tableAccess = new TableAccessDerby(connection);
                break;
            }
            case Postgresql: {
                tableAccess = new TableAccessPgsql(connection);
                break;
            }
            case Mysql: {
                tableAccess = new TableAccessMysql(connection);
                break;
            }
            case Oracle: {
                tableAccess = new TableAccessOracle(connection);
                break;
            }
            default: {
                throw new UnsupportedOperationException("DbType=" + (Object)((Object)this.dbType));
            }
        }
        return tableAccess;
    }
}

